#include "StdAfx.h"
#include "filemoveresponse.h"
#include "connection.h"
#include "UrlUtility.h"
#include "Dir.h"

CFileMoveResponse::CFileMoveResponse(CServer *server,CWorkspaceAccess context,CRequest request,CAlias alias)
: CNormalResponse(server,context,request,alias)
{
	//	OɂłɖƂ
	if(alias.IsExist()==0)
		throw new CSystemResponse(server,context,"w肳ꂽt@C݂͑܂",404);
}

CFileMoveResponse::~CFileMoveResponse(void)
{
}

/*
	X|X
*/
void CFileMoveResponse::CreateResponse()
{
	//	X|XR[h
	SetResponseCode(204);

	//	o͐̎擾
	CString	destUrl = m_request.m_options.GetConfig("Destination","",TRUE);

	//	w悪
	if(destUrl.GetLength() <= 7)
		throw new CSystemResponse(m_server,m_context,"o͐悪ُł",500);

	//	H()
	int	index = destUrl.Find("://");
	if(index!=-1)
		destUrl = destUrl.Mid(index + 3);

	index = destUrl.Find("/");
	if(index!=-1)
		destUrl = destUrl.Mid(index);

	destUrl = CUrlUtility::DecodeUrl(destUrl);
	
	CAlias	destAlias(destUrl,m_alias.GetTargetHost(),m_setting);

	//	ݒH
	if(destAlias.GetPathInfo().GetConfig("LocalPath","") != m_alias.GetPathInfo().GetConfig("LocalPath",""))
		throw CServerFatalException("ړs\ȑgݍ킹ł");

	if(m_request.m_method == "MOVE")
	{
		if(::MoveFile(m_alias.GetTarget(),destAlias.GetTarget())==0)
			throw CServerFatalException("t@C̑Ɏs܂AVXeG[ł");
	}
	else if(m_request.m_method == "COPY")
	{
		if(m_alias.IsDirectory())
		{
			CDir::MakeAllDirectory(destAlias.GetTarget());

			CDir	dir;
			dir.FindFile(m_alias.GetTarget() + "*.*",TRUE);

			CString	destPath = destAlias.GetTarget();
			destPath = CDir::AddBackSlash(destPath);

			int srcLen = m_alias.GetTarget().GetLength();
			for(int i=0;i<dir.GetFileCount();i++)
			{
				CString	path = destPath + dir.GetFilePath(i).Mid(srcLen);
				CDir::MakeAllDirectory(CDir::PathToDir(path));

				if(::CopyFile(dir.GetFilePath(i),path,FALSE)==0)
					throw CServerFatalException("t@C̑Ɏs܂AVXeG[ł");
			}
		}
		else
		{
			if(::CopyFile(m_alias.GetTarget(),destAlias.GetTarget(),FALSE)==0)
				throw CServerFatalException("t@C̑Ɏs܂AVXeG[ł");
		}
	}
}


/*!
	X|XTCY̎擾
*/
__int64 CFileMoveResponse::GetResponseSize()
{
	return(0);
}

/*!
	X|X̎擾
*/
int CFileMoveResponse::GetNextData(CBuffer &data)
{
	data.ReSize(0);
	return(0);
}

