#include "StdAfx.h"
#include ".\fifobuffer.h"

/*!
	RXgN^
*/
CFifoBuffer::CFifoBuffer()
{
	m_buf = NULL;
	m_bufLen = 0;
	m_inBufLen = 0;
}


/*!
	fXgN^
*/
CFifoBuffer::~CFifoBuffer(void)
{
	Close();
}


/////////////////////////////////////////////////////////////////////////////////////////
//	
/////////////////////////////////////////////////////////////////////////////////////////
/*!
	
*/
void CFifoBuffer::InitBuf(int bufLen)
{
	Close();

	m_buf = new char[bufLen];
	m_bufLen = bufLen;
	m_inBufLen = 0;
}

/*!
	I
*/
void CFifoBuffer::Close()
{
	if(m_buf)
	{
		delete m_buf;
		m_buf = NULL;
		m_bufLen = 0;
		m_inBufLen = 0;
	}
}


/////////////////////////////////////////////////////////////////////////////////////////
//	ǂݏ
/////////////////////////////////////////////////////////////////////////////////////////
/*!
	
*/
int CFifoBuffer::WriteBuf(char *data,int dataLen)
{
	//	obt@tH
	if(IsFull())
		return(0);

	//	obt@eʂ𒴂ĂH
	if(dataLen > GetFreeBuf())
		dataLen = GetFreeBuf();

	//	Rs[
	memmove(m_buf + m_inBufLen, data, dataLen);
	m_inBufLen += dataLen;

	//	ۂɏꂽ
	return(dataLen);
}

/*!
	ǂݏo
*/
int CFifoBuffer::ReadBuf(char *data,int dataLen)
{
	//	f[^H
	if(IsEmpty())
		return(0);

	//	f[^ȂH
	if(dataLen > GetInBuf())
		dataLen = GetInBuf();

	//	Rs[
	memmove(data, m_buf, dataLen);

	//	obt@XN[
	m_inBufLen -= dataLen;
	memmove(m_buf, m_buf + dataLen, m_inBufLen);

	//	ۂɂ܂ꂽ
	return(dataLen);
}


/*!
	ǂݏo(obt@Ȃ)
*/
int CFifoBuffer::PeekBuf(char *data, int dataLen)
{
	//	f[^H
	if(IsEmpty())
		return(0);

	//	f[^ȂH
	if(dataLen > GetInBuf())
		dataLen = GetInBuf();

	//	Rs[
	memmove(data, m_buf, dataLen);

	//	ۂɂ܂ꂽ
	return(dataLen);
}

/*!
	NA
*/
void CFifoBuffer::Clear()
{
	m_inBufLen = 0;
}

/////////////////////////////////////////////////////////////////////////////////////////
//	obt@ANZX
/////////////////////////////////////////////////////////////////////////////////////////
/*!
	ݗp|C^擾
*/
char *CFifoBuffer::GetWriteBuffer(int *bufLeft)
{
	if(bufLeft != NULL)
		*bufLeft = GetFreeBuf();
	return(m_buf + m_inBufLen);
}

/*!
	ǂݏop|C^擾
*/
char *CFifoBuffer::GetReadBuffer(int *bufLeft)
{
	if(bufLeft != NULL)
		*bufLeft = GetInBuf();
	return(m_buf);
}

/*!
	񂾒ݒ
*/
void CFifoBuffer::SetWritedLen(int len)
{
	//	obt@eʂ𒴂ĂH
	ASSERT(len <= GetFreeBuf());
	if(len > GetFreeBuf())
		len = GetFreeBuf();

	m_inBufLen += len;
}

/*!
	ǂݏoݒ
*/
void CFifoBuffer::SetReadedLen(int len)
{
	//	obt@eʂ𒴂ĂH
	ASSERT(len <= GetInBuf());
	if(len > GetInBuf())
		len = GetInBuf();

	//	obt@XN[
	m_inBufLen -= len;
	memmove(m_buf, m_buf + len, m_inBufLen);
}



/////////////////////////////////////////////////////////////////////////////////////////
//	Ԏ擾
/////////////////////////////////////////////////////////////////////////////////////////
/*!
	obt@tH
*/
int CFifoBuffer::IsFull()
{
	if(GetFreeBuf() == 0)
		return(1);
	return(0);
}

/*!
	obt@H
*/
int CFifoBuffer::IsEmpty()
{
	if(GetInBuf() == 0)
		return(1);
	return(0);
}


/*!
	gpeʎ擾
*/
int CFifoBuffer::GetInBuf()
{
	return(m_inBufLen);
}

/*!
	󂫗eʎ擾
*/
int CFifoBuffer::GetFreeBuf()
{
	return(m_bufLen - m_inBufLen);
}

