// 04WebServer.h : PROJECT_NAME AvP[ṼC wb_[ t@CłB
//

#pragma once

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"		// C V{
#include "Server.h"
#include "systemservice.h"
#include "PathTools.h"
#include "ServerControlPipeServer.h"
#include "ApplicationModeMsgWnd.h"
#include "SecDesc.h"


// CMy04WebServerApp:
// ̃NX̎ɂẮA04WebServer.cpp QƂĂB
//

class CMy04WebServerApp : public CWinApp
{
protected:
	CCriticalSection	m_scopeLock;

public:
	CMy04WebServerApp();

// I[o[Ch
public:
	virtual BOOL InitInstance();

// 
protected:
	int DoRegister(CString command);
	CString GetCommandOption();
	void SetServerSecurityDescripter();

public:
	//////////////////////////////////////////////////////////////////////////////////
	//	T[oRg[
	//////////////////////////////////////////////////////////////////////////////////
	int StartServer();
	int StopServer();
	CString GetServerErrorInfo();
	int ServerRunning();
	int GetConnectCount();
	int IsService();
	CString GetServerRoot() { return CPathTools::GetAppPath(); };

	//!	T[o擾
	int GetServerInfo(CWorkspaceAccess info);

	//!	T[oݒ擾
	int GetServerSetting(CWorkspaceAccess setting);

	//!	ڑ擾
	int GetServerContext(CWorkspaceAccess context);

	//////////////////////////////////////////////////////////////////////////////////
	//	T[o
	//////////////////////////////////////////////////////////////////////////////////
	CString GetServerInfoXML();
	CString GetServerSettingXML();
	CString GetServerContextXML();

	CString GetAppPath(int directoryPath=TRUE);
	void SetServerStatus(CString stat);

	void WriteDebugLog(LPCTSTR lpszFormat, ...);
	void KillAllController();

	//!	_v
	void DumpContext();

	//!	VXeT[rXReLXg擾
	CSystemService *GetSystemService() { return &m_serviceContext; };

	//!	T[rXo^
	void RegisterService(int reg);

	//!	ڑ̃Rg[
	int GetConnectedControllerCount() { return m_pipeServer.GetConnectionCount(); };

	DECLARE_MESSAGE_MAP()
	virtual int ExitInstance();
	
protected:
	//////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////
	//!	T[o{
	CServer			*m_server;

	//!	VXeT[rX
	CSystemService	m_serviceContext;

	//!	T[rX[hAv[hH
	int				m_serviceMode;

	//!	T[o
	CString			m_serverStatus;

	//!	IR[h
	int				m_exitCode;

	//!	Rg[ʐMppCvT[o
	CServerControlPipeServer	m_pipeServer;

	//!	AvP[V[hp
	CApplicationModeMsgWnd		m_msgWindow;
};

extern CMy04WebServerApp theApp;
