// TreeItem.cpp : CTreeItem ̃Cve[V
#include "stdafx.h"
#include "SeraphyScriptTools.h"
#include "TreeItem.h"
#include "objectmap.h"

#include <list>


/////////////////////////////////////////////////////////////////////////////
// CTreeItem

BOOL CTreeItem::DeleteTreeItemWithData(HWND hWnd, HTREEITEM hItem)
{
	HTREEITEM hRoot = hItem;
	std::list<HTREEITEM> lst;
	lst.push_back(hItem);
	while (!lst.empty()) {
		hItem = lst.front();
		lst.pop_front();
		while (hItem) {
			HTREEITEM hChild = TreeView_GetChild(hWnd, hItem);
			if (hChild) {
				// qO[v悤ɃX^bN
				lst.push_back(hChild);
			}
			// ̃ACeɊ֘AÂꂽIuWFNg
			TVITEM itm = {0};
			itm.mask = TVIF_PARAM;
			itm.hItem = hItem;
			if (TreeView_GetItem(hWnd, &itm) && itm.lParam) {
				IUnknown* pUnk = (IUnknown*)itm.lParam;
				pUnk->Release();
				itm.lParam = NULL;
				TreeView_SetItem(hWnd, &itm);
			}
			// ̃ACeT
			if (hRoot == hItem) {
				// JnʒǔZ͒TĂ͂ȂȂ
				hItem = NULL;
			}
			else {
				hItem = TreeView_GetNextSibling(hWnd, hItem);
			}
		}
	}
	TreeView_DeleteItem(hWnd, hRoot);
	return true;
}

/**
 * c[ACeێIuWFNg𐶐ĕԂ.
 * IUnknown͎QƃJEg1ɐݒ肳Ă邽߁AĂяoReleaseKv.
 */
HRESULT CTreeItem::CreateTreeItem(HWND hWnd, HTREEITEM hParent, LPCTSTR text, IUnknown **punkVal)
{
	if (!punkVal) {
		return E_POINTER;
	}
	*punkVal = NULL;

	// ACeۗLAzz𐶐

	HRESULT hr;

	CComObject<CObjectMap>* pMap = NULL;
	if (FAILED(hr = CComObject<CObjectMap>::CreateInstance(&pMap))) {
		return hr;
	}
	CComPtr<IUnknown> pMapUnk;
	if (FAILED(hr = pMap->QueryInterface(&pMapUnk))) {
		delete pMap;
		return hr;
	}

	// }ACe̒`
	ATL::CString tmp(text);
	TVINSERTSTRUCT is = {0};
	is.hParent = hParent;
	is.hInsertAfter = TVI_LAST;
	is.item.mask = TVIF_TEXT | TVIF_PARAM;
	is.item.pszText = tmp.GetBuffer();
	is.item.cchTextMax = tmp.GetLength();

	IUnknown* pUnk = NULL;
	if (FAILED(hr = pMapUnk.CopyTo(&pUnk))) {
		return hr;
	}
	is.item.lParam = (LPARAM)pUnk;

	HTREEITEM hNewItem = TreeView_InsertItem(hWnd, &is);
	if (!hNewItem) {
		// o^Ȃꍇ̓^OACeɊ֘AÂpUnk
		pUnk->Release();
		return E_FAIL; // sȃG[
	}

	// ACeւ̃IuWFNg쐬
	CComObject<CTreeItem>* pItem = NULL;
	if (FAILED(hr = CComObject<CTreeItem>::CreateInstance(&pItem))) {
		return hr;
	}
	pItem->SetParam(hWnd, hNewItem);

	if (FAILED(hr = pItem->QueryInterface(punkVal))) {
		delete pItem;
		return hr;
	}
	return S_OK;
}

STDMETHODIMP CTreeItem::IsValid(BOOL *pResult)
{
	if (!pResult) {
		return E_FAIL;
	}

	*pResult = (m_hItem != NULL) ? VB_TRUE : VB_FALSE;

	return S_OK;
}

STDMETHODIMP CTreeItem::Sort()
{
	HRESULT ret = InitialCheck();
	if (ret == S_OK) {
		if (m_hItem) {
			TreeView_SortChildren(m_hWnd, m_hItem, 0);
		}
		else {
			// sȃACeQƂĂ
			ret = DISP_E_EXCEPTION;
		}
	}
	return ret;
}

STDMETHODIMP CTreeItem::Expand()
{
	HRESULT ret = InitialCheck();
	if (ret == S_OK) {
		if (m_hItem) {
			TreeView_Expand(m_hWnd, m_hItem, TVE_EXPAND);
		}
		else {
			// sȃACeQƂĂ
			ret = DISP_E_EXCEPTION;
		}
	}
	return ret;
}

STDMETHODIMP CTreeItem::Select()
{
	HRESULT ret = InitialCheck();
	if (ret == S_OK) {
		if (m_hItem) {
			TreeView_SelectItem(m_hWnd, m_hItem);
		}
		else {
			// sȃACeQƂĂ
			ret = DISP_E_EXCEPTION;
		}
	}
	return ret;
}

STDMETHODIMP CTreeItem::Erase()
{
	HRESULT ret = InitialCheck();
	if (ret == S_OK) {
		if (m_hItem) {
			if (DeleteTreeItemWithData(m_hWnd, m_hItem)) {
				// 폜ɐÃnh𖳌ɂ
				m_hWnd = NULL;
				m_hItem = NULL;
			}
		}
		else {
			// sȃACeQƂĂ
			ret = DISP_E_EXCEPTION;
		}
	}
	return ret;
}

STDMETHODIMP CTreeItem::Create(/*[in]*/VARIANT text,/*[out,retval]*/IUnknown** punkVal)
{
	// ACe̍쐬
	*punkVal = NULL;
	HRESULT ret = InitialCheck();
	if (FAILED(ret)) {
		return ret;
	}

	if (m_hItem) {
		CComVariant str;
		ATL::CString mes(_TEXT(""));
		if (str.ChangeType(VT_BSTR, &text) == S_OK) {
			mes = str.bstrVal;
		}
		CreateTreeItem(m_hWnd, m_hItem, mes, punkVal);
		return S_OK;
	}
	// sȃACeQƂĂ
	return DISP_E_EXCEPTION;
}

STDMETHODIMP CTreeItem::get_Object(/*[in,optional]*/VARIANT idx, /*[out, retval]*/ VARIANT *pVal)
{
	// ACeɊ֘AtꂽAzzIuWFNg擾
	::VariantInit(pVal);
	HRESULT ret = InitialCheck();
	if (!m_hItem) {
		ret = DISP_E_EXCEPTION;
	}
	if (ret == S_OK) {
		TVITEM itm = {0};
		itm.mask = TVIF_PARAM;
		itm.hItem = m_hItem;
		if (TreeView_GetItem(m_hWnd, &itm)) {
			IUnknown* pUnk = (IUnknown*)itm.lParam;
			if (pUnk) {
				pUnk->AddRef();
				pVal->vt = VT_UNKNOWN;
				pVal->punkVal = pUnk;
			}
		}
	}
	return ret;
}

HRESULT CTreeItem::InitialCheck()
{
	// EBhEL
	if (m_hWnd && ::IsWindow(m_hWnd)) {
		return S_OK;
	}
	return Error(IDS_ERR_TREEERROR);
}

STDMETHODIMP CTreeItem::get_Text(/*[out, retval]*/ BSTR *pVal)
{
	// eLXg̎擾
	HRESULT hr;
	if (FAILED(hr = InitialCheck())) {
		return hr;
	}
	if (!m_hItem) {
		// sȃACeQƂĂ
		return DISP_E_EXCEPTION;
	}

	TCHAR text[MAX_PATH] = {0};
	TVITEM itm = {0};
	itm.mask = TVIF_TEXT;
	itm.hItem = m_hItem;
	itm.pszText = text;
	itm.cchTextMax = MAX_PATH;
	if (TreeView_GetItem(m_hWnd, &itm)) {
		CComBSTR ret(text);
		*pVal = ret.Detach();
	}
	return S_OK;
}

STDMETHODIMP CTreeItem::put_Text(/*[in]*/ BSTR newVal)
{
	// eLXg̏
	HRESULT hr;
	if (FAILED(hr = InitialCheck())) {
		return hr;
	}
	if (!m_hItem) {
		// sȃACeQƂĂ
		return DISP_E_EXCEPTION;
	}

	ATL::CString tmp(newVal);
	TVITEM itm = {0};
	itm.mask = TVIF_TEXT;
	itm.hItem = m_hItem;
	itm.pszText = tmp.GetBuffer();
	itm.cchTextMax = tmp.GetLength(); // Set̏ꍇ͖
	TreeView_SetItem(m_hWnd, &itm);
	return S_OK;
}

STDMETHODIMP CTreeItem::get_PrevItem(/*[out, retval]*/ IUnknown* *pVal)
{
	// ÕACe
	*pVal = NULL;

	HRESULT hr;
	if (FAILED(hr = InitialCheck())) {
		return hr;
	}

	if (!m_hItem) {
		// sȃACeQƂĂ
		return DISP_E_EXCEPTION;
	}

	CComObject<CTreeItem>* pItem = NULL;
	if (FAILED(hr = CComObject<CTreeItem>::CreateInstance(&pItem))) {
		return hr;
	}

	HTREEITEM hNewItem = TreeView_GetPrevSibling(m_hWnd, m_hItem);
	pItem->SetParam(m_hWnd, hNewItem);

	return pItem->QueryInterface(IID_IUnknown, (void**)pVal);
}

STDMETHODIMP CTreeItem::get_NextItem(/*[out, retval]*/ IUnknown* *pVal)
{
	// ̃ACe
	*pVal = NULL;

	HRESULT hr;
	if (FAILED(hr = InitialCheck())) {
		return hr;
	}

	if (!m_hItem) {
		// sȃACeQƂĂ
		return DISP_E_EXCEPTION;
	}

	CComObject<CTreeItem>* pItem = NULL;
	if (FAILED(hr = CComObject<CTreeItem>::CreateInstance(&pItem))) {
		return hr;
	}

	HTREEITEM hNewItem = TreeView_GetNextSibling(m_hWnd, m_hItem);
	pItem->SetParam(m_hWnd, hNewItem);

	return pItem->QueryInterface(IID_IUnknown, (void**)pVal);
}

STDMETHODIMP CTreeItem::get_ChildItem(/*[out, retval]*/ IUnknown* *pVal)
{
	// qACe
	*pVal = NULL;

	HRESULT hr;
	if (FAILED(hr = InitialCheck())) {
		return hr;
	}

	if (!m_hItem) {
		// sȃACeQƂĂ
		return DISP_E_EXCEPTION;
	}

	CComObject<CTreeItem>* pItem = NULL;
	if (FAILED(hr = CComObject<CTreeItem>::CreateInstance(&pItem))) {
		return hr;
	}

	HTREEITEM hNewItem = TreeView_GetChild(m_hWnd, m_hItem);
	pItem->SetParam(m_hWnd, hNewItem);

	return pItem->QueryInterface(IID_IUnknown, (void**)pVal);
}

STDMETHODIMP CTreeItem::get_Parent(/*[out, retval]*/ IUnknown* *pVal)
{
	// eACe
	*pVal = NULL;

	HRESULT hr;
	if (FAILED(hr = InitialCheck())) {
		return hr;
	}

	if (!m_hItem) {
		// sȃACeQƂĂ
		return DISP_E_EXCEPTION;
	}

	CComObject<CTreeItem>* pItem = NULL;
	if (FAILED(hr = CComObject<CTreeItem>::CreateInstance(&pItem))) {
		return hr;
	}

	HTREEITEM hNewItem = TreeView_GetParent(m_hWnd, m_hItem);
	pItem->SetParam(m_hWnd, hNewItem);

	return pItem->QueryInterface(IID_IUnknown, (void**)pVal);
}

//
void CTreeItem::SetParam(HWND hWnd, HTREEITEM hItem)
{
	m_hWnd = hWnd;
	m_hItem = hItem;
}

