// Control.cpp : CControl ̃Cve[V
#include "stdafx.h"

#include "SeraphyScriptTools.h"
#include "Control.h"
#include "treeitem.h"

#include "objectmap.h"
#include "CComEnumDynaVARIANT.h"

#include <vector>

/////////////////////////////////////////////////////////////////////////////
// CControl

STDMETHODIMP CControl::get_Text(BSTR *pVal)
{
	if (!m_hParent || !m_hWnd) {
		return Error(IDS_ERR_DESTROYED);
	}

	DWORD siz = ::GetWindowTextLength(m_hWnd);

	ATL::CString tmp;
	LPTSTR pMes = tmp.GetBufferSetLength(siz + 1);
	GetWindowText(m_hWnd, pMes, siz + 1);
	tmp.ReleaseBuffer();

	CComBSTR ret(tmp);
	*pVal = ret.Detach();
	return S_OK;
}

STDMETHODIMP CControl::put_Text(BSTR newVal)
{
	if (!m_hParent || !m_hWnd) {
		return Error(IDS_ERR_DESTROYED);
	}

	ATL::CString tmp(newVal);
	::SetWindowText(m_hWnd, tmp);
	return S_OK;
}

STDMETHODIMP CControl::get_ID(short *pVal)
{
	if (m_hWnd) {
		m_nID = (int)GetWindowLong(m_hWnd, GWL_ID);
	}
	*pVal = m_nID;
	return S_OK;
}

STDMETHODIMP CControl::put_ID(short newVal)
{
	m_nID = newVal;
	if (m_hWnd) {
		SetWindowLong(m_hWnd, GWL_ID, newVal);
		if ((m_nID == IDOK) && !lstrcmp(m_classname, _TEXT("BUTTON"))) {
			// IDOKȂ|bV{^^fBtHg{^ɕω
			DWORD m_style = ::GetWindowLong(m_hWnd, GWL_STYLE);
			m_style |= BS_DEFPUSHBUTTON;
			::SetWindowLong(m_hWnd, GWL_STYLE, m_style);
		}
	}
	return S_OK;
}

STDMETHODIMP CControl::get_Visibility(BOOL *pVal)
{
	if (!m_hParent || !m_hWnd) {
		*pVal = 0;
		return Error(IDS_ERR_DESTROYED);
	}

	WINDOWPLACEMENT pls = {0};
	pls.length = sizeof(WINDOWPLACEMENT);
	::GetWindowPlacement(m_hWnd, &pls);
	*pVal = (pls.showCmd != SW_HIDE) ? true : false;
	return S_OK;
}

STDMETHODIMP CControl::put_Visibility(BOOL newVal)
{
	if (!m_hParent || !m_hWnd) {
		return Error(IDS_ERR_DESTROYED);
	}

	::ShowWindow(m_hWnd, newVal ? SW_SHOWNORMAL : SW_HIDE);
	return S_OK;
}

STDMETHODIMP CControl::get_Enable(BOOL *pVal)
{
	if (!m_hParent || !m_hWnd) {
		*pVal = 0;
		return Error(IDS_ERR_DESTROYED);
	}
	*pVal = ::IsWindowEnabled(m_hWnd);
	return S_OK;
}

STDMETHODIMP CControl::put_Enable(BOOL newVal)
{
	if (!m_hParent || !m_hWnd) {
		return Error(IDS_ERR_DESTROYED);
	}
	::EnableWindow(m_hWnd, newVal);
	return S_OK;
}

STDMETHODIMP CControl::get_CheckState(short *pVal)
{
	if (m_hWnd) {
		m_bChecked = (short)::SendMessage(m_hWnd, BM_GETCHECK, 0, 0);
	}
	*pVal = m_bChecked;
	return S_OK;
}

STDMETHODIMP CControl::put_CheckState(short newVal)
{
	m_bChecked = newVal;
	if (m_hWnd && newVal >= 0 && newVal <= 2) {
		// 0:Unchecked 1:Checked 2:interminate
		::SendMessage(m_hWnd, BM_SETCHECK, newVal, 0);
	}
	return S_OK;
}

BOOL CControl::Create(HWND hParent)
{
	// << ftHg̃vbV{^ɕωNp >>
	if ((m_nID == IDOK) && !lstrcmp(m_classname, _TEXT("BUTTON"))) {
		// IDOKȂύX
		m_style |= BS_DEFPUSHBUTTON;
	}

	//@Rg[̐
	ATLASSERT(m_hParent == NULL);
	m_hParent = hParent;
	m_hWnd = ::CreateWindowEx(m_exstyle, m_classname, m_caption,
		m_style | WS_VISIBLE | WS_CHILD | WS_CLIPSIBLINGS,
		m_x, m_y, m_w, m_h,
		hParent,
		NULL,
		_Module.m_hInst,
		NULL);
	::SetWindowLongPtr(m_hWnd, GWLP_ID, m_nID);
	::SetWindowLongPtr(m_hWnd, GWLP_USERDATA, (LONG_PTR) this);
	::SetWindowText(m_hWnd, m_caption);

	// efBZ[uȂqfBZ[uԂō쐬
	if (!::IsWindowEnabled(m_hParent)) {
		::EnableWindow(m_hWnd, false);
	}

	//////////////////////////
	// OԂ̐ݒ
	if (!lstrcmp(m_classname, _TEXT("BUTTON"))) {
		// {^Ȃ`FbNԂ̃Zbg
		if (m_bChecked) {
			::SendMessage(m_hWnd, BM_SETCHECK, 1, 0);
		}
	}
	else if (!lstrcmp(m_classname, WC_LISTVIEW)) {
		// Xgr[ȂJ̐ݒs
		LPCTSTR p = m_caption;
		m_nColumnCount = 0;
		// EBhELvV񌩏o쐬
		while (*p) {
			LPCTSTR st = p;
			while (*p && *p != ',' && *p != ':') {
				p = CharNext(p);
			}

			int sz = p - st;
			TCHAR szColumn[MAX_PATH] = {0};
			_tcsncpy_s(szColumn, MAX_PATH, st, sz);

			LVCOLUMN col = {0};
			col.mask = LVCF_TEXT | LVCF_WIDTH;
			col.pszText = szColumn;
			col.cx = ListView_GetStringWidth(m_hWnd, szColumn) + 16;
			ListView_InsertColumn(m_hWnd, m_nColumnCount, &col);

			if (*p == ',' || *p == ':') {
				p++;
			}
			m_nColumnCount++;
		}
		if (m_afterstyle) {
			ListView_SetExtendedListViewStyle(m_hWnd, m_afterstyle);
		}
	}
	else if (!lstrcmp(m_classname, WC_TREEVIEW)) {
		TreeView_SetImageList(m_hWnd, NULL, TVSIL_NORMAL);
	}
	return true;
}

void CControl::Destroy()
{
	DeleteAllItems();
	if (m_hWnd) {
		// EBhEj
		// EBhE̔jƃC^[tFCX̔j͈vȂB
		::DestroyWindow(m_hWnd);
		m_hWnd = NULL;
	}
}

STDMETHODIMP CControl::get_Width(short *pVal)
{
	if (m_hWnd) {
		WINDOWPLACEMENT pls = {0};
		pls.length = sizeof(WINDOWPLACEMENT);
		::GetWindowPlacement(m_hWnd, &pls);
		m_w = (short)(pls.rcNormalPosition.right - pls.rcNormalPosition.left);
	}
	*pVal = m_w;
	return S_OK;
}

STDMETHODIMP CControl::put_Width(short newVal)
{
	m_w = newVal;
	if (m_hWnd) {
		WINDOWPLACEMENT pls = {0};
		pls.length = sizeof(WINDOWPLACEMENT);
		::GetWindowPlacement(m_hWnd, &pls);
		::SetWindowPos(
			m_hWnd,
			NULL,
			0, 0,
			m_w,
			pls.rcNormalPosition.right - pls.rcNormalPosition.left,
			SWP_NOZORDER | SWP_NOMOVE
			);
	}
	return S_OK;
}

STDMETHODIMP CControl::get_Height(short *pVal)
{
	if (m_hWnd) {
		WINDOWPLACEMENT pls = {0};
		pls.length = sizeof(WINDOWPLACEMENT);
		::GetWindowPlacement(m_hWnd, &pls);
		m_h = (short)(pls.rcNormalPosition.bottom - pls.rcNormalPosition.top);
	}
	*pVal = m_h;
	return S_OK;
}

STDMETHODIMP CControl::put_Height(short newVal)
{
	m_h = newVal;
	if (m_hWnd) {
		WINDOWPLACEMENT pls = {0};
		pls.length = sizeof(WINDOWPLACEMENT);
		::GetWindowPlacement(m_hWnd, &pls);
		::SetWindowPos(
			m_hWnd,
			NULL,
			0, 0,
			m_h,
			pls.rcNormalPosition.right - pls.rcNormalPosition.left,
			SWP_NOZORDER | SWP_NOMOVE
			);
	}
	return S_OK;
}

STDMETHODIMP CControl::get_PosX(short *pVal)
{
	if (m_hWnd) {
		WINDOWPLACEMENT pls = {0};
		pls.length = sizeof(WINDOWPLACEMENT);
		::GetWindowPlacement(m_hWnd, &pls);
		m_x = (short)pls.rcNormalPosition.left;
	}
	*pVal = m_x;
	return S_OK;
}

STDMETHODIMP CControl::put_PosX(short newVal)
{
	m_x = newVal;
	if (m_hWnd) {
		WINDOWPLACEMENT pls = {0};
		pls.length = sizeof(WINDOWPLACEMENT);
		::GetWindowPlacement(m_hWnd, &pls);
		::SetWindowPos(
			m_hWnd,
			NULL,
			m_x, pls.rcNormalPosition.top,
			0, 0,
			SWP_NOZORDER | SWP_NOSIZE
			);
	}
	return S_OK;
}

STDMETHODIMP CControl::get_PosY(short *pVal)
{
	if (m_hWnd) {
		WINDOWPLACEMENT pls = {0};
		pls.length = sizeof(WINDOWPLACEMENT);
		::GetWindowPlacement(m_hWnd, &pls);
		m_y = (short)pls.rcNormalPosition.top;
	}
	*pVal = m_y;
	return S_OK;
}

STDMETHODIMP CControl::put_PosY(short newVal)
{
	m_y = newVal;
	if (m_hWnd) {
		WINDOWPLACEMENT pls = {0};
		pls.length = sizeof(WINDOWPLACEMENT);
		::GetWindowPlacement(m_hWnd, &pls);
		::SetWindowPos(
			m_hWnd,
			NULL,
			pls.rcNormalPosition.left,
			m_y,
			0, 0,
			SWP_NOZORDER | SWP_NOSIZE
			);
	}
	return S_OK;
}

STDMETHODIMP CControl::SetPlacement(VARIANT x, VARIANT y, VARIANT w, VARIANT h, VARIANT *pvarUnk)
{
	// TCYύX
	CComVariant varX, varY, varW, varH;
	if ((x.vt != VT_EMPTY && x.vt != VT_NULL && x.vt != VT_ERROR) && SUCCEEDED(varX.ChangeType(VT_I2, &x))) {
		m_x = varX.iVal;
	}
	if ((y.vt != VT_EMPTY && y.vt != VT_NULL && y.vt != VT_ERROR) && SUCCEEDED(varY.ChangeType(VT_I2, &y))) {
		m_y = varY.iVal;
	}
	if ((h.vt != VT_EMPTY && h.vt != VT_NULL && h.vt != VT_ERROR) && SUCCEEDED(varH.ChangeType(VT_I2, &h))) {
		m_h = varH.iVal;
	}
	if ((w.vt != VT_EMPTY && w.vt != VT_NULL && w.vt != VT_ERROR) && SUCCEEDED(varW.ChangeType(VT_I2, &w))) {
		m_w = varW.iVal;
	}
	// EBhE\Ă΂ɔf
	if (m_hWnd) {
		::SetWindowPos(m_hWnd, NULL, m_x, m_y, m_w, m_h, SWP_NOZORDER);
	}
	GetThisInterface(pvarUnk);
	return S_OK;
}

STDMETHODIMP CControl::SetCheck(VARIANT *pvarUnk)
{
	// Ƀ`FbN
	put_CheckState(true);
	GetThisInterface(pvarUnk);
	return S_OK;
}

STDMETHODIMP CControl::SetID(VARIANT varID, VARIANT *pvarUnk)
{
	// ID蓖Ă
	CComVariant tmp;
	if (varID.vt != VT_EMPTY && varID.vt != VT_EMPTY && varID.vt != VT_EMPTY
		&& SUCCEEDED(tmp.ChangeType(VT_I2, &varID))) {
		if (tmp.iVal > 0) {
			put_ID(tmp.iVal);
		}
	}
	GetThisInterface(pvarUnk);
	return S_OK;
}

void CControl::GetThisInterface(VARIANT *pvarUnk)
{
	// ̃C^[tFCXԂ
	::VariantInit(pvarUnk);
	IUnknown* pUnk = NULL;
	if (SUCCEEDED(QueryInterface(IID_IUnknown, (void**)&pUnk))) {
		pvarUnk->vt = VT_UNKNOWN;
		pvarUnk->punkVal = pUnk;
	}
}

int CControl::GetID()
{
	return m_nID;
}

STDMETHODIMP CControl::get_Style(long *pVal)
{
	if (m_hWnd) {
		m_style = ::GetWindowLong(m_hWnd, GWL_STYLE);
	}
	*pVal = m_style;
	return S_OK;
}

STDMETHODIMP CControl::put_Style(long newVal)
{
	m_style = newVal;
	if (m_hWnd) {
		::SetWindowLong(m_hWnd, GWL_STYLE, m_style);
	}
	return S_OK;
}

STDMETHODIMP CControl::get_Exstyle(long *pVal)
{
	if (m_hWnd) {
		m_exstyle = ::GetWindowLong(m_hWnd, GWL_EXSTYLE);
	}
	*pVal = m_exstyle;
	return S_OK;
}

STDMETHODIMP CControl::put_Exstyle(long newVal)
{
	m_exstyle = newVal;
	if (m_hWnd) {
		::SetWindowLong(m_hWnd, GWL_EXSTYLE, m_exstyle);
	}
	return S_OK;
}

STDMETHODIMP CControl::get_ClassName(BSTR *pVal)
{
	CComBSTR tmp(m_classname);
	*pVal = tmp.Detach();
	return S_OK;
}

STDMETHODIMP CControl::Refresh()
{
	if (!m_hParent || !m_hWnd) {
		return Error(IDS_ERR_DESTROYED);
	}
	::SetWindowPos(
		m_hWnd,
		NULL,
		0, 0, 0, 0,
		SWP_NOMOVE | SWP_NOSIZE | SWP_NOZORDER | SWP_DRAWFRAME | SWP_FRAMECHANGED | SWP_NOCOPYBITS);
	return S_OK;
}

STDMETHODIMP CControl::get_HWND(long *pVal)
{
	*pVal = (long)m_hWnd;
	return S_OK;
}

HRESULT CControl::ConvertVariantToString(VARIANT text, ATL::CString &retval)
{
	CComVariant varText;
	HRESULT hr = varText.ChangeType(VT_BSTR, &text);
	if (FAILED(hr)) {
		return hr;
	}

	retval = varText.bstrVal;
	return S_OK;
}

STDMETHODIMP CControl::AddString(VARIANT text, VARIANT* pRet)
{
	::VariantInit(pRet);

	if (!m_hParent || !m_hWnd) {
		return Error(IDS_ERR_DESTROYED);
	}

	ATL::CString buf;
	HRESULT hr = ConvertVariantToString(text, buf);
	if (FAILED(hr)) {
		return hr;
	}

	CComVariant ret;
	if (!lstrcmp(m_classname, _TEXT("COMBOBOX"))) {
		// R{{bNXɕǉ
		ret = (short)SendMessage(m_hWnd, CB_ADDSTRING, 0, (LPARAM)(LPCTSTR)buf);
	}
	else if (!lstrcmp(m_classname, _TEXT("LISTBOX"))) {
		// AzzIuWFNg쐬
		CComObject<CObjectMap>* pMap = NULL;
		if (FAILED(hr = CComObject<CObjectMap>::CreateInstance(&pMap))) {
			return hr;
		}
		IUnknown* pMapUnk = NULL;
		if (FAILED(hr = pMap->QueryInterface(&pMapUnk))) {
			return hr;
		}

		// Xg{bNXɕǉ
		int nIdx = SendMessage(m_hWnd, LB_ADDSTRING, 0, (LPARAM)(LPCTSTR)buf);

		// Xg{bNX̃ACeɘAzzoCh.
		::SendMessage(m_hWnd, LB_SETITEMDATA, nIdx, (LPARAM)pMapUnk);
		ret = (short)nIdx;
	}
	else if (!lstrcmp(m_classname, WC_LISTVIEW)) {
		// Xgr[ɕǉ
		int cnt = ListView_GetItemCount(m_hWnd);
		LVITEM item = {0};
		item.mask = LVIF_TEXT;
		item.pszText = buf.GetBuffer();
		item.iItem = cnt;
		int nIdx = ListView_InsertItem(m_hWnd, &item);

		// TuJ͋󕶂𖄂߂
		for (int i = 1; i < m_nColumnCount; i++) {
			ListView_SetItemText(m_hWnd, nIdx, i, _TEXT(""));
		}

		// AzzIuWFNgoCh
		CComObject<CObjectMap>* pMap = NULL;
		if (FAILED(hr = CComObject<CObjectMap>::CreateInstance(&pMap))) {
			return hr;
		}

		IUnknown* pUnk = NULL;
		if (FAILED(hr = pMap->QueryInterface(IID_IUnknown, (void**)&pUnk))) {
			return hr;
		}

		LVITEM itm = { 0 };
		itm.iItem = nIdx;
		itm.mask = LVIF_PARAM;
		itm.lParam = (LPARAM)pUnk;
		ListView_SetItem(m_hWnd, &itm);
		ret = (short)nIdx;
	}
	else if (!lstrcmp(m_classname, WC_TREEVIEW)) {
		// c[r[̃[gɃACe쐬
		CComPtr<IUnknown> pUnk;
		HRESULT hr;
		if (FAILED(hr = CTreeItem::CreateTreeItem(m_hWnd, TVI_ROOT, buf, &pUnk))) {
			return hr;
		}
		if (pUnk != NULL) {
			ret = pUnk; // pUnkVariantAddRef̂Detach͕sv.
		}
	}
	else {
		// ȊO̓T|[gO
		return Error(IDS_ERR_NOTSUPPORTCONTROL);
	}
	return ret.Detach(pRet);
}

STDMETHODIMP CControl::SetColumnText(VARIANT item, VARIANT col, VARIANT text)
{
	if (!m_hParent || !m_hWnd) {
		return Error(IDS_ERR_DESTROYED);
	}

	int nIdx = -1;
	int nCol = -1;
	CComVariant varIdx, varCol;
	if (SUCCEEDED(varIdx.ChangeType(VT_I2, &item))) {
		nIdx = varIdx.iVal;
	}
	if (SUCCEEDED(varCol.ChangeType(VT_I2, &col))) {
		nCol = varCol.iVal;
	}
	if (nIdx < 0 || nCol < 0) {
		// sE擾łȂꍇ
		return DISP_E_TYPEMISMATCH;
	}

	ATL::CString buf;
	HRESULT hr = ConvertVariantToString(text, buf);
	if (FAILED(hr)) {
		return hr;
	}

	if (!lstrcmp(m_classname, WC_LISTVIEW)) {
		int mx = ListView_GetItemCount(m_hWnd);
		if (nIdx >= mx || nCol >= m_nColumnCount) {
			// s܂͌I[o[Ăꍇ
			return Error(IDS_ERR_RANDEOUT);
		}
		else {
			// Xgr[ɕǉ
			ListView_SetItemText(m_hWnd, nIdx, nCol, buf.GetBuffer());
		}
	}
	else {
		// ȊO̓T|[gO
		return Error(IDS_ERR_NOTSUPPORTCONTROL);
	}
	return S_OK;
}

STDMETHODIMP CControl::GetColumnText(VARIANT idx, VARIANT col, VARIANT *pText)
{
	CComVariant ret;
	if (!m_hParent || !m_hWnd) {
		return Error(IDS_ERR_DESTROYED);
	}

	int nIdx = -1;
	int nCol = -1;
	CComVariant varIdx, varCol;
	if (SUCCEEDED(varIdx.ChangeType(VT_I2, &idx))) {
		nIdx = varIdx.iVal;
	}
	if (SUCCEEDED(varCol.ChangeType(VT_I2, &col))) {
		nCol = varCol.iVal;
	}

	if (nIdx < 0 || nCol < 0) {
		return DISP_E_BADINDEX;
	}

	if (!lstrcmp(m_classname, WC_LISTVIEW)) {
		// CfbNX𒲍
		int mx = ListView_GetItemCount(m_hWnd);
		if (nIdx >= mx || nCol >= m_nColumnCount) {
			return Error(IDS_ERR_RANDEOUT);
		}

		// Xgr[當擾
		ATL::CString buf;
		LPTSTR pBuf = buf.GetBufferSetLength(MAX_PATH);
		ListView_GetItemText(m_hWnd, nIdx, nCol, pBuf, MAX_PATH);
		ret = pBuf;
	}
	else {
		// ȊO̓T|[gO
		return Error(IDS_ERR_NOTSUPPORTCONTROL);
	}
	return ret.Detach(pText);
}

STDMETHODIMP CControl::get_ItemObject(VARIANT idx, VARIANT *pVal)
{
	::VariantInit(pVal);
	if (!m_hParent || !m_hWnd) {
		return Error(IDS_ERR_DESTROYED);
	}

	int nIdx = -1;
	CComVariant varIdx;
	if (SUCCEEDED(varIdx.ChangeType(VT_I2, &idx))) {
		nIdx = varIdx.iVal;
	}

	if (nIdx < 0) {
		return DISP_E_BADINDEX;
	}

	IUnknown* pUnk = NULL;
	if (!lstrcmp(m_classname, _TEXT("LISTBOX"))) {
		// Xg{bNXAzzIuWFNg擾
		int mx = ::SendMessage(m_hWnd, LB_GETCOUNT, 0, 0);
		if (nIdx >= mx) {
			return Error(IDS_ERR_RANDEOUT);
		}
		LRESULT data = ::SendMessage(m_hWnd, LB_GETITEMDATA, nIdx, 0);
		if (data != LB_ERR && data) {
			pUnk = (IUnknown*)data;
		}
	}
	else if (!lstrcmp(m_classname, WC_LISTVIEW)) {
		// Xgr[AzzIuWFNg擾
		int mx = ListView_GetItemCount(m_hWnd);
		if (nIdx >= mx) {
			return Error(IDS_ERR_RANDEOUT);
		}

		LVITEM itm = {0};
		itm.mask = LVIF_PARAM;
		itm.iItem = nIdx;
		if (ListView_GetItem(m_hWnd, &itm)) {
			if (itm.lParam) {
				pUnk = (IUnknown*)itm.lParam;
			}
		}
	}
	else {
		// ȊO̓T|[gO
		return Error(IDS_ERR_NOTSUPPORTCONTROL);
	}

	if (pUnk) {
		CComVariant tmp(pUnk);
		return tmp.Detach(pVal);
	}
	return S_OK;
}

STDMETHODIMP CControl::DeleteAllItems()
{
	if (!m_hParent || !m_hWnd) {
		return Error(IDS_ERR_DESTROYED);
	}
	// Rg[̓ACeɊ֘AtĂAzzIuWFNg
	if (!lstrcmp(m_classname, _TEXT("LISTBOX"))) {
		// Xg̉
		int mx = ::SendMessage(m_hWnd, CB_GETCOUNT, 0, 0);
		for (int i = 0; i < mx; i++) {
			LRESULT data = ::SendMessage(m_hWnd, LB_GETITEMDATA, i, 0);
			if (data != LB_ERR && data) {
				((IUnknown*)data)->Release();
			}
		}
	}
	else if (!lstrcmp(m_classname, WC_LISTVIEW)) {
		// Xgr[̘Azz̉
		int mx = ListView_GetItemCount(m_hWnd);
		LVITEM itm = {0};
		for (int i = 0; i < mx; i++) {
			itm.mask = LVIF_PARAM;
			itm.iItem = i;
			if (ListView_GetItem(m_hWnd, &itm)) {
				if (itm.lParam) {
					((IUnknown*)itm.lParam)->Release();
				}
			}
		}
	}
	else if (!lstrcmp(m_classname, WC_TREEVIEW)) {
		// c[r[̘Azz̉
		HTREEITEM hItem = TreeView_GetRoot(m_hWnd);
		while (hItem) {
			HTREEITEM hNextItem = TreeView_GetNextSibling(m_hWnd, hItem);
			CTreeItem::DeleteTreeItemWithData(m_hWnd, hItem);
			hItem = hNextItem;
		}
	}
	// AzzȂRg[̏
	else if (!lstrcmp(m_classname, _TEXT("COMBOBOX"))) {
		// COMBOBOX
		int cnt = ::SendMessage(m_hWnd, CB_GETCOUNT, 0, 0);
		while (cnt > 0) {
			::SendMessage(m_hWnd, CB_DELETESTRING, 0, 0);
			cnt--;
		}
	}
	else if (!lstrcmp(m_classname, _TEXT("EDIT"))) {
		// EditB
		CComVariant dmy(L"");
		put_Text(dmy.bstrVal);
	}
	return S_OK;
}
STDMETHODIMP CControl::DeleteString(VARIANT idx, VARIANT *pRet)
{
	::VariantInit(pRet);

	if (!m_hParent || !m_hWnd) {
		return Error(IDS_ERR_DESTROYED);
	}

	int nIdx = -1;
	CComVariant varIdx;
	if (SUCCEEDED(varIdx.ChangeType(VT_I2, &idx))) {
		nIdx = varIdx.iVal;
	}
	if (nIdx < 0) {
		return DISP_E_BADINDEX;
	}

	CComVariant ret;
	if (!lstrcmp(m_classname, _TEXT("COMBOBOX"))) {
		// R{{bNX當폜
		int mx = ::SendMessage(m_hWnd, CB_GETCOUNT, 0, 0);
		if (nIdx >= mx) {
			return Error(IDS_ERR_RANDEOUT);
		}
		int result = ::SendMessage(m_hWnd, CB_DELETESTRING, nIdx, 0);
		ret = (bool)(result != LB_ERR);
	}
	else if (!lstrcmp(m_classname, _TEXT("LISTBOX"))) {
		// Xg{bNX當폜
		int mx = ::SendMessage(m_hWnd, LB_GETCOUNT, 0, 0);
		if (nIdx >= mx) {
			return Error(IDS_ERR_RANDEOUT);
		}

		// AzzIuWFNgj
		LRESULT data = ::SendMessage(m_hWnd, LB_GETITEMDATA, nIdx, 0);
		if (data != LB_ERR && data) {
			((IUnknown*)data)->Release();
		}

		// 폜
		int result = ::SendMessage(m_hWnd, LB_DELETESTRING, nIdx, 0);
		ret = (bool)(result != LB_ERR);
	}
	else if (!lstrcmp(m_classname, WC_LISTVIEW)) {
		// Xgr[當폜
		int mx = ListView_GetItemCount(m_hWnd);
		if (nIdx >= mx) {
			return Error(IDS_ERR_RANDEOUT);
		}

		// AzzIuWFNgj
		LVITEM itm = {0};
		itm.mask = LVIF_PARAM;
		itm.iItem = nIdx;
		if (ListView_GetItem(m_hWnd, &itm)) {
			if (itm.lParam) {
				((IUnknown*)itm.lParam)->Release();
			}
		}

		// 폜
		ret = ListView_DeleteItem(m_hWnd, nIdx) ? true : false;
	}
	else {
		// ȊO̓T|[gO
		return Error(IDS_ERR_NOTSUPPORTCONTROL);
	}

	return ret.Detach(pRet);
}

STDMETHODIMP CControl::GetCount(VARIANT *pRet)
{
	::VariantInit(pRet);

	if (!m_hParent || !m_hWnd) {
		return Error(IDS_ERR_DESTROYED);
	}

	CComVariant ret;
	if (!lstrcmp(m_classname, _TEXT("COMBOBOX"))) {
		// Xg{bNX̃JEg
		int mx = ::SendMessage(m_hWnd, CB_GETCOUNT, 0, 0);
		if (mx == LB_ERR) {
			mx = 0;
		}
		ret = (short)mx;
	}
	else if (!lstrcmp(m_classname, _TEXT("LISTBOX"))) {
		// Xg{bNX̃JEg
		int mx = ::SendMessage(m_hWnd, LB_GETCOUNT, 0, 0);
		if (mx == LB_ERR) {
			mx = 0;
		}
		ret = (short)mx;
	}
	else if (!lstrcmp(m_classname, WC_LISTVIEW)) {
		// Xgr[̃JEg
		ret = (short)ListView_GetItemCount(m_hWnd);
	}
	else {
		// ȊO̓T|[gO
		return Error(IDS_ERR_NOTSUPPORTCONTROL);
	}
	return ret.Detach(pRet);
}

STDMETHODIMP CControl::get_CurrentSelectedItem(VARIANT *pVal)
{
	::VariantInit(pVal);

	if (!m_hParent || !m_hWnd) {
		return Error(IDS_ERR_DESTROYED);
	}

	CComVariant ret;
	if (!lstrcmp(m_classname, _TEXT("COMBOBOX"))) {
		// R{{bNX݂̌̑IԂ
		ret = (long)::SendMessage(m_hWnd, CB_GETCURSEL, 0, 0);
	}
	else if (!lstrcmp(m_classname, _TEXT("LISTBOX"))) {
		// Xg{bNX݂̌̑IACeԂ
		if (!(m_style & LBS_MULTIPLESEL)) {
			// VOZNg̏ꍇ
			ret = (long)::SendMessage(m_hWnd, LB_GETCURSEL, 0, 0);
		}
		else {
			// }`ZNg̏ꍇ͍ŏ̑IACeԂ
			ret = (long)-1;
			int mx = ::SendMessage(m_hWnd, LB_GETCOUNT, 0, 0);
			if (mx > 0) {
				std::vector<long> buf(mx + 1);
				long* pBuf = &buf[0];
				int cnt = ::SendMessage(m_hWnd, LB_GETSELITEMS, mx, (LPARAM)pBuf);
				if (cnt != LB_ERR && cnt > 0) {
					ret = buf[0];
				}
			}
		}
	}
	else if (!lstrcmp(m_classname, WC_LISTVIEW)) {
		// Xgr[̍ŏ̑IACeT
		ret = (long)ListView_GetNextItem(m_hWnd, -1, LVNI_SELECTED);
	}
	else if (!lstrcmp(m_classname, WC_TREEVIEW)) {
		// c[r[̎wACȇ𒲂ׂ
		HTREEITEM hItem = TreeView_GetSelection(m_hWnd);
		if (hItem) {
			CComObject<CTreeItem>* pItem = NULL;
			HRESULT hr;
			if (FAILED(hr = CComObject<CTreeItem>::CreateInstance(&pItem))) {
				return hr;
			}

			IUnknown* pUnk = NULL;
			if (FAILED(hr = pItem->QueryInterface(&pUnk))) {
				delete pItem;
				return hr;
			}

			//FIXME: sv̂͂ pItem->AddRef();
			pItem->SetParam(m_hWnd, hItem);
			ret = pUnk;
		}
	}
	else {
		// ȊO̓T|[gO
		return Error(IDS_ERR_NOTSUPPORTCONTROL);
	}
	return ret.Detach(pVal);
}

STDMETHODIMP CControl::put_CurrentSelectedItem(VARIANT newVal)
{
	if (!m_hParent || !m_hWnd) {
		return Error(IDS_ERR_DESTROYED);
	}

	long nIdx = -1;
	CComVariant varIdx;
	if (SUCCEEDED(varIdx.ChangeType(VT_I4, &newVal))) {
		nIdx = varIdx.lVal;
	}

	if (!lstrcmp(m_classname, _TEXT("COMBOBOX"))) {
		// R{{bNXIw肷
		::SendMessage(m_hWnd, CB_SETCURSEL, nIdx, 0);
	}
	else if (!lstrcmp(m_classname, _TEXT("LISTBOX"))) {
		// Xg{bNX̑I
		if (!(m_style & LBS_MULTIPLESEL)) {
			// VOZNg̏ꍇ
			::SendMessage(m_hWnd, LB_SETCURSEL, nIdx, 0);
		}
		else {
			// }`ZNg̏ꍇ
			int mx = ::SendMessage(m_hWnd, LB_GETCOUNT, 0, 0);
			for (int i = 0; i < mx; i++) {
				::SendMessage(m_hWnd, LB_SETSEL, FALSE, i);
			}
			if (nIdx >= 0 && nIdx < mx) {
				::SendMessage(m_hWnd, LB_SETSEL, TRUE, nIdx);
			}
		}
	}
	else if (!lstrcmp(m_classname, WC_LISTVIEW)) {
		// Xgr[̑I
		int mx = ListView_GetItemCount(m_hWnd);
		ListView_SetItemState(m_hWnd, -1, LVIS_SELECTED, 0);
		if (nIdx >= 0 && nIdx < mx) {
			ListView_SetItemState(m_hWnd, nIdx, LVIS_SELECTED, LVIS_SELECTED);
		}
	}
	else {
		// ȊO̓T|[gO
		return Error(IDS_ERR_NOTSUPPORTCONTROL);
	}
	return S_OK;
}

STDMETHODIMP CControl::get__NewEnum(IUnknown **pVal)
{
	*pVal = NULL;

	if (!m_hParent || !m_hWnd) {
		return Error(IDS_ERR_DESTROYED);
	}

	std::vector<VARIANT> varArray;
	int mx = 0;

	if (!lstrcmp(m_classname, _TEXT("COMBOBOX"))) {
		// R{{bNX݂̌̑IԂ
		int nIdx = ::SendMessage(m_hWnd, CB_GETCURSEL, 0, 0);
		mx = 1;
		varArray.resize(1);
		::VariantInit(&varArray[0]);
		varArray[0].vt = VT_I2;
		varArray[0].iVal = nIdx;
	}
	else if (!lstrcmp(m_classname, _TEXT("LISTBOX"))) {
		// Xg{bNX݂̌̑IACeԂ
		if (!(m_style & LBS_MULTIPLESEL)) {
			// VOZNg̏ꍇ
			int nIdx = ::SendMessage(m_hWnd, LB_GETCURSEL, 0, 0);
			mx = 1;
			varArray.resize(1);
			::VariantInit(&varArray[0]);
			varArray[0].vt = VT_I2;
			varArray[0].iVal = nIdx;
		}
		else {
			// }`ZNg̏ꍇ͍ŏ̑IACeԂ
			int sz = ::SendMessage(m_hWnd, LB_GETCOUNT, 0, 0);
			std::vector<long> buf(sz + 1);
			long* pBuf = &buf[0];
			mx = ::SendMessage(m_hWnd, LB_GETSELITEMS, sz, (LPARAM)pBuf);
			if (mx != LB_ERR) {
				// IԂꂽꍇ
				varArray.resize(mx + 1);
				for (int i = 0; i < mx; i++) {
					::VariantInit(&varArray[i]);
					varArray[i].vt = VT_I2;
					varArray[i].iVal = (short)pBuf[i];
				}
			}
		}
	}
	else if (!lstrcmp(m_classname, WC_LISTVIEW)) {
		// Xgr[̍ŏ̑IACeT
		mx = ListView_GetSelectedCount(m_hWnd);
		varArray.resize(mx + 1);
		int nIdx = -1;
		int i = 0;
		while ((nIdx = ListView_GetNextItem(m_hWnd, nIdx, LVNI_SELECTED)) != -1
			&& i < mx) {
			::VariantInit(&varArray[i]);
			varArray[i].vt = VT_I2;
			varArray[i].iVal = (short)nIdx;
			i++;
		}
	}
	else {
		// ȊO̓T|[gO
		return Error(IDS_ERR_NOTSUPPORTCONTROL);
	}

	// 񋓃C^[tFCX̐
	CComObject<CComEnumVARIANT>* pCol = NULL;
	HRESULT hr;
	if (FAILED(hr = CComObject<CComEnumVARIANT>::CreateInstance(&pCol))) {
		return hr;
	}
	pCol->Init(&varArray[0], &varArray[mx], pCol, AtlFlagCopy);

	return pCol->QueryInterface(pVal);
}


STDMETHODIMP CControl::get_ItemSelectState(VARIANT idx, VARIANT *pVal)
{
	::VariantInit(pVal);
	CComVariant ret;

	if (!m_hParent || !m_hWnd) {
		return Error(IDS_ERR_DESTROYED);
	}

	int nIdx = -1;
	CComVariant varIdx;
	if (SUCCEEDED(varIdx.ChangeType(VT_I2, &idx))) {
		nIdx = idx.iVal;
	}

	if (!lstrcmp(m_classname, _TEXT("COMBOBOX"))) {
		// R{{bNX݂̌̑IԂ
		int nSel = ::SendMessage(m_hWnd, CB_GETCURSEL, 0, 0);
		// w肵ACeƑIvĂtrue
		ret = (bool)((nSel == nIdx) ? true : false);
	}
	else if (!lstrcmp(m_classname, _TEXT("LISTBOX"))) {
		// Xg{bNX݂̌̑IACeԂ
		if (!(m_style & LBS_MULTIPLESEL)) {
			// VOZNg̏ꍇ
			int nSel = ::SendMessage(m_hWnd, LB_GETCURSEL, 0, 0);
			// w肵ACeƑIvĂtrue
			ret = (nSel == nIdx);
		}
		else {
			// }`ZNg̏ꍇ
			ret = ::SendMessage(m_hWnd, LB_GETSEL, nIdx, 0) > 0;
		}
	}
	else if (!lstrcmp(m_classname, WC_LISTVIEW)) {
		// Xgr[̎wACȇ𒲂ׂ
		int mx = ListView_GetItemCount(m_hWnd);
		if (nIdx >= 0 && nIdx < mx) {
			UINT state = ListView_GetItemState(m_hWnd, nIdx, LVNI_SELECTED);
			ret = (state & LVNI_SELECTED) != 0;
		}
	}
	else {
		// ȊO̓T|[gO
		return Error(IDS_ERR_NOTSUPPORTCONTROL);
	}
	ret.Detach(pVal);
	return S_OK;
}

STDMETHODIMP CControl::put_ItemSelectState(VARIANT idx, VARIANT newVal)
{
	if (!m_hParent || !m_hWnd) {
		return Error(IDS_ERR_DESTROYED);
	}

	int nIdx = -1;
	CComVariant varIdx;
	if (SUCCEEDED(varIdx.ChangeType(VT_I2, &idx))) {
		nIdx = idx.iVal;
	}

	bool bSelected = false;
	CComVariant varSelected;
	if (SUCCEEDED(varSelected.ChangeType(VT_I2, &newVal))) {
		bSelected = newVal.iVal != 0;
	}

	if (!lstrcmp(m_classname, _TEXT("COMBOBOX"))) {
		// R{{bNX݂̌̑IύX
		::SendMessage(m_hWnd, CB_SETCURSEL, bSelected ? nIdx : -1, 0);
	}
	else if (!lstrcmp(m_classname, _TEXT("LISTBOX"))) {
		// Xg{bNX݂̌̑IACeԂ
		if (!(m_style & LBS_MULTIPLESEL)) {
			// VOZNg̏ꍇ
			::SendMessage(m_hWnd, LB_SETCURSEL, bSelected ? nIdx : -1, 0);
		}
		else {
			// }`ZNg
			::SendMessage(m_hWnd, LB_SETSEL, nIdx, bSelected);
		}
	}
	else if (!lstrcmp(m_classname, WC_LISTVIEW)) {
		// Xgr[̎wACȇ𒲂ׂ
		int mx = ListView_GetItemCount(m_hWnd);
		if (nIdx >= 0 && nIdx < mx) {
			ListView_SetItemState(m_hWnd, nIdx, bSelected ? LVNI_SELECTED : 0, LVNI_SELECTED);
		}
	}
	else {
		// ȊO̓T|[gO
		return Error(IDS_ERR_NOTSUPPORTCONTROL);
	}
	return S_OK;
}

STDMETHODIMP CControl::get_SelectedCount(short *pVal)
{
	*pVal = 0;
	if (!m_hParent || !m_hWnd) {
		return Error(IDS_ERR_DESTROYED);
	}

	if (!lstrcmp(m_classname, _TEXT("COMBOBOX"))) {
		// Xg{bNX̃JEg
		int nIdx = ::SendMessage(m_hWnd, CB_GETCURSEL, 0, 0);
		*pVal = (short)(nIdx >= 0 ? 1 : 0);
	}
	else if (!lstrcmp(m_classname, _TEXT("LISTBOX"))) {
		// Xg{bNX̃JEg
		if (!(m_style & LBS_MULTIPLESEL)) {
			int nIdx = ::SendMessage(m_hWnd, LB_GETCURSEL, 0, 0);
			*pVal = (short)(nIdx >= 0 ? 1 : 0);
		}
		else {
			// }`ZNg
			*pVal = (short)::SendMessage(m_hWnd, LB_GETSELCOUNT, 0, 0);
		}
	}
	else if (!lstrcmp(m_classname, WC_LISTVIEW)) {
		// Xgr[̃JEg
		*pVal = (short)ListView_GetSelectedCount(m_hWnd);
	}
	else {
		// ȊO̓T|[gO
		return Error(IDS_ERR_NOTSUPPORTCONTROL);
	}
	return S_OK;
}

STDMETHODIMP CControl::get_TreeRoot(VARIANT *pVal)
{
	if (!m_hParent || !m_hWnd) {
		return Error(IDS_ERR_DESTROYED);
	}
	::VariantInit(pVal);
	if (!lstrcmp(m_classname, WC_TREEVIEW)) {
		CComObject<CTreeItem>* pItem = NULL;
		HRESULT hr;
		if (FAILED(hr = CComObject<CTreeItem>::CreateInstance(&pItem))) {
			return hr;
		}

		HTREEITEM hItem = TreeView_GetRoot(m_hWnd);
		pItem->SetParam(m_hWnd, hItem);

		IUnknown* pUnk = NULL;
		if (FAILED(hr = pItem->QueryInterface(IID_IUnknown, (void**)&pUnk))) {
			delete pItem;
			return hr;
		}
		pVal->vt = VT_UNKNOWN;
		pVal->punkVal = pUnk;
	}
	return S_OK;
}

void CControl::ListSort(int column)
{
	if (!m_hParent || !m_hWnd) {
		return;
	}

	// ȂJ\[gꍇ͋tƂ
	if (m_dLastSortColumn == column) {
		m_bSortReverse = !m_bSortReverse;
	}
	else {
		m_bSortReverse = false;
	}

	m_dLastSortColumn = column;
	m_typCompare = VT_EMPTY;
	// \[gĂяo
	ListView_SortItems(m_hWnd, CompareFunc, (LPARAM)this);
}

int CControl::CompareFunc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
	if (!lParam1 || !lParam2) {
		// CM[Bf[^[Ȃ̂Ŕrs\
		return 0;
	}

	CControl* me = (CControl*)lParamSort;

	IObjectMap* pMap1 = (IObjectMap*)lParam1;
	IObjectMap* pMap2 = (IObjectMap*)lParam2;

	TCHAR mes[16];
	wsprintf(mes, _TEXT("SORT%d"), me->m_dLastSortColumn);
	CComVariant key(mes);

	CComVariant val1, val2;
	if (!me->m_bSortReverse) {
		pMap1->get_Value(key, &val1);
		pMap2->get_Value(key, &val2);
	}
	else {
		pMap1->get_Value(key, &val2);
		pMap2->get_Value(key, &val1);
	}

	if (me->m_typCompare == VT_EMPTY) {
		// ܂rJnĂȂȂr^Cv肷
		me->m_typCompare = val1.vt;
		if (val1.vt != val2.vt) {
			me->m_typCompare = VT_BSTR;
		}
	}

	int ret = 0;
	switch (me->m_typCompare) {
		case VT_UI1:
		{
			val1.ChangeType(VT_UI1);
			val2.ChangeType(VT_UI1);
			ret = val1.bVal - val2.bVal;
			break;
		}
		case VT_I2:
		{
			val1.ChangeType(VT_I2);
			val2.ChangeType(VT_I2);
			ret = val1.iVal - val2.iVal;
			break;
		}
		case VT_I4:
		{
			val1.ChangeType(VT_I4);
			val2.ChangeType(VT_I4);
			ret = val1.lVal - val2.lVal;
			break;
		}
		case VT_R4:
		{
			val1.ChangeType(VT_R4);
			val2.ChangeType(VT_R4);
			ret = val1.fltVal > val2.fltVal;
			break;
		}
		case VT_R8:
		{
			val1.ChangeType(VT_R8);
			val2.ChangeType(VT_R8);
			ret = val1.dblVal > val2.dblVal;
			break;
		}
		case VT_CY:
		{
			val1.ChangeType(VT_CY);
			val2.ChangeType(VT_CY);
			ret = (int)(val1.cyVal.int64 - val2.cyVal.int64); //FIXME: 낵ȂBZʂӂꂵꍇAr֐j]BȂ˂΁B
			break;
		}
		case VT_DATE:
		{
			val1.ChangeType(VT_DATE);
			val2.ChangeType(VT_DATE);
			ret = val1.date > val2.date;
			break;
		}
		case VT_BSTR:
		{
			if (SUCCEEDED(val1.ChangeType(VT_BSTR)) &&
				SUCCEEDED(val2.ChangeType(VT_BSTR))) {
				ret = lstrcmpW(val1.bstrVal, val2.bstrVal);
			}
			break;
		}
		default:
		break;
	}
	return ret;
}

void CControl::OnRClick()
{
	if (!m_hParent || !m_hWnd) {
		return;
	}

	if (!lstrcmp(m_classname, WC_TREEVIEW)) {
		// c[r[ł΃hbvnCCgIɂ
		HTREEITEM hItem = TreeView_GetDropHilight(m_hWnd);
		if (hItem) {
			TreeView_SelectItem(m_hWnd, hItem);
		}
	}
}


STDMETHODIMP CControl::get_ItemCheckState(VARIANT idx, BOOL *pVal)
{
	if (!m_hParent || !m_hWnd) {
		return Error(IDS_ERR_DESTROYED);
	}

	if (lstrcmp(m_classname, WC_LISTVIEW)) {
		// Xgr[ȊO̓T|[gO
		return Error(IDS_ERR_NOTSUPPORTCONTROL);
	}

	CComVariant varIdx;
	HRESULT hr = varIdx.ChangeType(VT_I2, &idx);
	if (FAILED(hr)) {
		return hr;
	}

	*pVal = VB_FALSE;
	if (m_afterstyle & LVS_EX_CHECKBOXES) {
		*pVal = ListView_GetCheckState(m_hWnd, varIdx.iVal) ? VB_TRUE : VB_FALSE;
	}
	return S_OK;
}

STDMETHODIMP CControl::put_ItemCheckState(VARIANT idx, BOOL newVal)
{
	if (!m_hParent || !m_hWnd) {
		return Error(IDS_ERR_DESTROYED);
	}

	if (lstrcmp(m_classname, WC_LISTVIEW)) {
		// Xgr[ȊO̓T|[gO
		return Error(IDS_ERR_NOTSUPPORTCONTROL);
	}

	CComVariant varIdx;
	HRESULT hr = varIdx.ChangeType(VT_I2, &idx);
	if (FAILED(hr)) {
		return hr;
	}

	if (m_afterstyle & LVS_EX_CHECKBOXES) {
		ListView_SetCheckState(m_hWnd, varIdx.iVal, newVal);
	}
	return S_OK;
}

STDMETHODIMP CControl::DeleteSelectedItem()
{
	if (!m_hParent || !m_hWnd) {
		return Error(IDS_ERR_DESTROYED);
	}

	if (!lstrcmp(m_classname, _TEXT("LISTBOX"))) {
		// Xg{bNX̑I폜
		CComVariant varRet, dmy;
		while (SUCCEEDED(get_CurrentSelectedItem(&varRet)) && varRet.vt != VT_EMPTY) {
			varRet.ChangeType(VT_I4);
			if (varRet.lVal < 0) {
				break;
			}
			DeleteString(varRet, &dmy);
		}
	}
	else if (!lstrcmp(m_classname, WC_LISTVIEW)) {
		// Xgr[̍폜
		int nIdx = -1;
		while ((nIdx = ListView_GetNextItem(m_hWnd, nIdx, LVNI_SELECTED)) != -1) {
			CComVariant varIdx((long)nIdx), dmy;
			DeleteString(varIdx, &dmy);
			nIdx = -1;
		}
	}
	else {
		// ȊO̓T|[gO
		return Error(IDS_ERR_NOTSUPPORTCONTROL);
	}
	return S_OK;
}

STDMETHODIMP CControl::get_ItemText(VARIANT idx, BSTR *pVal)
{
	if (!m_hParent || !m_hWnd) {
		return Error(IDS_ERR_DESTROYED);
	}

	int nIdx = -1;
	CComVariant varIdx;
	if (SUCCEEDED(varIdx.ChangeType(VT_I2, &idx))) {
		nIdx = varIdx.iVal;
	}

	if (nIdx < 0) {
		return DISP_E_TYPEMISMATCH;
	}

	CComBSTR ret;
	if (!lstrcmp(m_classname, _TEXT("COMBOBOX"))) {
		// Rz{bNX當擾
		int siz = ::SendMessage(m_hWnd, CB_GETLBTEXTLEN, nIdx, 0);
		if (siz > 0) {
			ATL::CString tmp;
			LPTSTR p = tmp.GetBufferSetLength(siz + 1);
			if (::SendMessage(m_hWnd, CB_GETLBTEXT, nIdx, (LPARAM)p) > 0) {
				ret = p;
			}
		}
	}
	else if (!lstrcmp(m_classname, _TEXT("LISTBOX"))) {
		// Xg當擾
		int siz = ::SendMessage(m_hWnd, LB_GETTEXTLEN, nIdx, 0);
		if (siz > 0) {
			ATL::CString tmp;
			LPTSTR p = tmp.GetBufferSetLength(siz + 1);
			if (::SendMessage(m_hWnd, LB_GETTEXT, nIdx, (LPARAM)p) > 0) {
				ret = p;
			}
		}
	}
	else if (!lstrcmp(m_classname, WC_LISTVIEW)) {
		CComVariant arg, text;
		arg = (long)0;
		HRESULT hr;
		if (SUCCEEDED(GetColumnText(idx, arg, &text))) {
			if (SUCCEEDED(text.ChangeType(VT_BSTR))) {
				ret = text.bstrVal;
			}
		}
	}
	else {
		// ȊO̓T|[gO
		return Error(IDS_ERR_NOTSUPPORTCONTROL);
	}
	*pVal = ret.Detach();
	return S_OK;
}

STDMETHODIMP CControl::put_ItemText(VARIANT idx, BSTR newVal)
{
	if (!m_hParent || !m_hWnd) {
		return Error(IDS_ERR_DESTROYED);
	}

	int nIdx = -1;
	CComVariant varIdx;
	if (SUCCEEDED(varIdx.ChangeType(VT_I2, &idx))) {
		nIdx = varIdx.iVal;
	}

	if (nIdx < 0) {
		return DISP_E_BADINDEX;
	}

	if (!lstrcmp(m_classname, WC_LISTVIEW)) {
		CComVariant arg, text;
		arg = (long)0;
		text = (BSTR)newVal;
		return SetColumnText(idx, arg, text);
	}

	// ȊO̓T|[gO
	return Error(IDS_ERR_NOTSUPPORTCONTROL);
}

STDMETHODIMP CControl::SetClassEvent(BSTR name, VARIANT* pvarUnk)
{
	m_bstrClassEvent = name;
	GetThisInterface(pvarUnk);
	return S_OK;
}

void CControl::GetClassEvent(BSTR *pEventName)
{
	*pEventName = m_bstrClassEvent.copy();
}

STDMETHODIMP CControl::CreateChild(VARIANT text, VARIANT varItem, VARIANT* pvarUnk)
{
	::VariantInit(pvarUnk);
	if (!m_hParent || !m_hWnd) {
		return Error(IDS_ERR_DESTROYED);
	}

	// ACě
	CComVariant tmp;
	if (SUCCEEDED(tmp.ChangeType(VT_UNKNOWN, &varItem))) {
		ITreeItem * pItem = NULL;
		if (tmp.punkVal->QueryInterface(IID_ITreeItem, (void**)&pItem) != S_OK) {
			return DISP_E_UNKNOWNINTERFACE;
		}

		IUnknown* pUnk = NULL;
		if (SUCCEEDED(pItem->Create(text, &pUnk))) {
			pvarUnk->vt = VT_UNKNOWN;
			pvarUnk->punkVal = pUnk;
		}
		pItem->Release();
	}
	else {
		tmp.ChangeType(VT_VARIANT, &varItem);
		if (tmp.vt == VT_ERROR || tmp.vt == VT_NULL || tmp.vt == VT_EMPTY) {
			// [gɃACe쐬
			AddString(text, pvarUnk);
		}
		else {
			return DISP_E_TYPEMISMATCH;
		}
	}
	return S_OK;
}
