# Ring ノートパットアプリケーション (RNote)
# 原作者 : Mahmoud Fayed <msfclipper@yahoo.com>

class RNoteMainWindow

	func CreateMainWindow 

		oDesktop = new qDesktopWidget()

		win1 = new qMainWindow() {
			setwindowtitle("Ring ノートパッド")
			setwinicon(self,this.cCurrentDir + "/image/notepad.png")
			this.oFilter = new qAllEvents(this.win1)
			this.oFilter.setCloseEvent(Method(:RingNotepadXButton))
			installEventFilter(this.oFilter)
			this.CreateToolbars()	
			this.CreateMenubar()
			this.CreateStatusbar()
			this.CreateProjectFiles()	
			this.CreateSourceCode()
			this.CreateWebBrowser()	
			this.CreateFunctionsList()
			this.CreateClassesList()
			this.CreateOutputWindow()
			this.CreateFormDesigner()
			this.PrepareDockableWindows()
		}
	
	func CreateToolBars
		win1 {
			aBtns = [
					new qtoolbutton(this.win1) {
						setbtnimage(self,"image/new.png")
						setclickEvent(Method(:NewFile))
						settooltip("新規作成 (Ctrl+N)")
					} ,
					new qtoolbutton(this.win1) {
						setbtnimage(self,"image/open.png")
						setclickEvent(Method(:Open))
						settooltip("ファイルを開く (Ctrl+O)")
					} ,
					new qtoolbutton(this.win1) {
						setbtnimage(self,"image/save.png")
						setclickEvent(Method(:Save))
						settooltip("保存 (Ctrl+S)")
					 } ,
					new qtoolbutton(this.win1) {
						setbtnimage(self,"image/saveas.png")
						setclickEvent(Method(:SaveAs))
						settooltip("名前を付けて保存 (Ctrl+E)")
					 } ,
					new qtoolbutton(this.win1) {
						setbtnimage(self,"image/undo.png")
						setclickEvent(Method(:Undo))
						settooltip("元に戻す (Ctrl+Z)")
					} ,
					new qtoolbutton(this.win1) {
						setbtnimage(self,"image/cut.png")
						setclickEvent(Method(:Cut))
						settooltip("切り取り (Ctrl+X)")
					 } ,
					new qtoolbutton(this.win1) {
						setbtnimage(self,"image/copy.png")
						setclickEvent(Method(:CopyText))
						settooltip("コピー (Ctrl+C)")
					} ,
					new qtoolbutton(this.win1) {
						setbtnimage(self,"image/paste.png")
						setclickEvent(Method(:Paste))
						settooltip("貼り付け (Ctrl+V)")
					} ,
					new qtoolbutton(this.win1) {
						setbtnimage(self,"image/font.png")
						setclickEvent(Method(:Font))
						settooltip("フォント (Ctrl+I)")
					} ,
					new qtoolbutton(this.win1) {
						setbtnimage(self,"image/search.png")
						setclickEvent(Method(:OpenFindWindow))
						settooltip("検索と置換 (Ctrl+F)")
					} ,
					new qtoolbutton(this.win1) {
						setbtnimage(self,"image/print.png")
						setclickEvent(Method(:Print))
						settooltip("印刷 (Ctrl+P)")
					} ,
					new qtoolbutton(this.win1) {
						setbtnimage(self,"image/debug.png")
						setclickevent(Method(:Debug)) 
						settooltip("デバッグ - 実行後に待機！ (Ctrl+D)")
					} ,
					new qtoolbutton(this.win1) {
						setbtnimage(self,"image/run.png")
						setclickEvent(Method(:Run))
						settooltip("プログラムの実行 (Ctrl+R) ")
					} ,
					new qtoolbutton(this.win1) {
						setbtnimage(self,"image/rungui.png")
						setclickEvent(Method(:RunNoConsole))
						settooltip("GUI アプリケーションの実行 - コンソール非表示 (Ctrl+F5)")
					} ,
					new qtoolbutton(this.win1) {
						setbtnimage(self,"image/web.png")
						setclickEvent(Method(:RunInBrowser))
						settooltip("ウェブ・アプリケーションの実行 - ブラウザで開く (Ctrl+F6)")
					} ,
					new qtoolbutton(this.win1) {
						setbtnimage(self,"image/close.png")
						setclickEvent(Method(:Quit))
						settooltip("終了 (Ctrl+Q)")
					}
				]
	
			tool1 = addtoolbar("ツールバー：ファイル")  {
				for x in aBtns addwidget(x) addseparator() next
			}
	
			# Main File Toolbar
			tool2 = addtoolbar("ツールバー：メインファイル")  {
				oLblMainFile = new qLabel(this.win1) {
					setText("メインファイル : ")
				}
				this.oTxtMainFile = new qLineEdit(this.win1) {
					setStylesheet("border: 0px;  background-color: rgba(0, 0, 0, 0);")
					setReadOnly(True)
				}
				oBtnSetFile = new qtoolbutton(this.win1) {
					setbtnimage(self,"image/open.png")
					setclickEvent(Method(:SetMainFile))
					settooltip("現在のソースファイルをメインファイルとして設定 (Ctrl+Shift+M)")
				}
				oBtnDebugMainFile = new qtoolbutton(this.win1) {
						setbtnimage(self,"image/debug.png")
						setclickevent(Method(:DebugMainFile)) 
						settooltip("メインファイル : デバッグ  - 実行後に待機！ (Ctrl+Shift+D)")
				} 
				oBtnRunMainFile = new qtoolbutton(this.win1) {
						setbtnimage(self,"image/run.png")
						setclickEvent(Method(:RunMainFile))
						settooltip("メインファイル : プログラムの実行 (Ctrl+Shift+R)")
				} 
				oBtnRunGUIMainFile = new qtoolbutton(this.win1) {
						setbtnimage(self,"image/rungui.png")
						setclickEvent(Method(:RunGUIMainFile))
						settooltip("メインファイル : GUI アプリケーションの実行 - コンソール非表示 (Ctrl+Shift+F5)")
				} 
				oBtnRunWebMainFile = new qtoolbutton(this.win1) {
						setbtnimage(self,"image/web.png")
						setclickEvent(Method(:RunInBrowserMainFile))
						settooltip("メインファイル : ウェブ・アプリケーションの実行 - ブラウザで開く (Ctrl+Shift+F6)")
				} 
				AddWidget(oLblMainFile)
				AddWidget(this.oTxtMainFile)
				AddWidget(oBtnSetFile)
				AddWidget(oBtnDebugMainFile)
				AddWidget(oBtnRunMainFile)
				AddWidget(oBtnRunGUIMainFile)
				AddWidget(oBtnRunWebMainFile)
			}
		}
	
	func CreateMenubar 
		win1 {
				menu1 = new qmenubar(this.win1) {
					subFile 	= addmenu("ファイル(&F)")
					subEdit 	= addmenu("編集(&E)")
					subView 	= addmenu("表示(&V)")
					subProgram 	= addmenu("プログラム(&P)")
					subBrowser 	= addmenu("ブラウザ(&B)")
					subTools 	= addmenu("ツール(&T)")
					subDistribute   = addmenu("配布(&D)")
					subHelp 	= addmenu("ヘルプ(&H)")
					subFile {
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+n"))
							setbtnimage(self,"image/new.png")
							settext("新規作成")
							setclickEvent(Method(:NewFile))
						}
						addaction(oAction)
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+o"))
							setbtnimage(self,"image/open.png")
							settext("開く...")
							setclickEvent(Method(:Open))
						}
						addaction(oAction)
						addseparator()
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+s"))
							setbtnimage(self,"image/save.png")
							settext("保存")
							setclickEvent(Method(:Save))
						}
						addaction(oAction)
						addseparator()
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+e"))
							setbtnimage(self,"image/saveas.png")
							settext("名前を付けて保存...")
							setclickEvent(Method(:SaveAs))
						}
						addaction(oAction)
						addseparator()
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+p"))
							setbtnimage(self,"image/print.png")
							settext("PDF へ出力")
							setclickEvent(Method(:Print))
						}
						addaction(oAction)
						addseparator()
						oAction = new qaction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+q"))
							setbtnimage(self,"image/close.png")
							settext("終了")
							setstatustip("Ring ノートパッドを終了します")
							setclickEvent(Method(:Quit))
						}
						addaction(oAction)
					}
					subEdit {
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+z"))
							setbtnimage(self,"image/undo.png")
							settext("元に戻す")
							setclickEvent(Method(:Undo))
						}
						addaction(oAction)
						addseparator()
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+x"))
							setbtnimage(self,"image/cut.png")
							settext("切り取り")
							setclickEvent(Method(:Cut))
						}
						addaction(oAction)
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+c"))
							setbtnimage(self,"image/copy.png")
							settext("コピー")
							setclickEvent(Method(:CopyText))
						}
						addaction(oAction)
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+v"))
							setbtnimage(self,"image/paste.png")
							settext("貼り付け")
							setclickEvent(Method(:Paste))
						}
						addaction(oAction)
						addseparator()
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+i"))
							setbtnimage(self,"image/font.png")
							settext("フォント")
							setclickEvent(Method(:Font))
						}
						addseparator()
						addaction(oAction)
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+t"))
							setbtnimage(self,"image/colors.png")
							settext("テキストの色")
							setclickEvent(Method(:SelectColor))
						}
						addaction(oAction)
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+b"))
							setbtnimage(self,"image/colors.png")
							settext("背景の色")
							setclickEvent(Method(:SelectColor2))
						}
						addaction(oAction)
						addseparator()
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+h"))
							settext("タブ幅の設定...")
							setclickEvent(Method(:TabWidth))
						}
						addaction(oAction)
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+g"))
							settext("指定行へ移動...")
							setclickEvent(Method(:Goto))
						}
						addaction(oAction)
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+f"))
							setbtnimage(self,"image/search.png")
							settext("検索と置換...")
							setclickEvent(Method(:OpenFindWindow))
						}
						addaction(oAction)
						addseparator()
                                                oAction = new qAction(this.win1) {
	                                                setShortcut(new QKeySequence("Ctrl+Shift+i"))
	                                                settext("テキストの挿入...")
	                                                setclickEvent(Method(:OpenInsertWindow))
                                                }
						addaction(oAction)
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+Shift+L"))
							settext("小文字へ変換")
							setclickEvent(Method(:lowerCase))
						}
						addaction(oAction)
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+Shift+U"))
							settext("大文字へ変換")
							setclickEvent(Method(:upperCase))
						}
						addaction(oAction)
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+Shift+C"))
							settext("語頭を大文字へ変換")
							setclickEvent(Method(:capitalize))
						}
						addaction(oAction)
						addseparator()
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+alt+C"))
							setbtnimage(self,"image/comment2.png")
							settext("一行コメント")
							setclickEvent(Method(:CommentLines))
						}
						addaction(oAction)
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+alt+B"))
							setbtnimage(self,"image/comment.png")
							settext("複数行コメント")
							setclickEvent(Method(:CommentBlockLines))
						}
						addaction(oAction)
						addseparator()
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+alt+f"))
							setbtnimage(self,"image/search.png")
							settext("ファイルの検索")
							setclickEvent(Method(:OpenFindInFiles))
						}
						addaction(oAction)
	
					}
					subView {
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+j"))
							setbtnimage(self,"image/project.png")
							settext("プロジェクトのファイル")
							setclickEvent(Method(:ProjectWindowStatus))
						}
						addaction(oAction)
						addseparator()
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+u"))
							setbtnimage(self,"image/source.png")
							setclickEvent(Method(:SourceCodeWindowStatus))
							settext("ソースコード")
						}
						addaction(oAction)
						addseparator()
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+w"))
							setbtnimage(self,"image/richtext.png")
							setclickEvent(Method(:WebBrowserWindowStatus))
							settext("ウェブ・ブラウザ")
						}
						addaction(oAction)
						addseparator()
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Alt+f"))
							setbtnimage(self,"image/source.png")
							setclickEvent(Method(:FunctionsListWindowStatus))
							settext("関数のリスト")
						}
						addaction(oAction)
						addseparator()
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Alt+c"))
							setbtnimage(self,"image/source.png")
							setclickEvent(Method(:ClassesListWindowStatus))
							settext("クラスのリスト")
						}
						addaction(oAction)
						addseparator()
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Alt+o"))
							setbtnimage(self,"image/source.png")
							setclickEvent(Method(:OutputWindowStatus))
							settext("実行結果のウィンドウ")
						}
						addaction(oAction)
						addseparator()
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("CTRL+SHIFT+f"))
							setbtnimage(self,"image/formdesigner.png")
							setclickEvent(Method(:FormDesignerWindowStatus))
							settext("フォームデザイナーのウィンドウ")
						}
						addaction(oAction)
						addseparator()
						subStyle = addmenu("スタイル")
						subStyle {
							setbtnimage(self,"image/colors.png")
							oAction = new qAction(this.win1) {
								setclickEvent(Method("SetStyleColor(0)"))
								settext("Windows 標準")
							}
							addaction(oAction)
							addseparator()
							oAction = new qAction(this.win1) {
								setclickEvent(Method("SetStyleColor(1)"))
								settext("フュージョン : 白")
							}
							addaction(oAction)
							addseparator()
							oAction = new qAction(this.win1) {
								setclickEvent(Method("SetStyleColor(2)"))
								settext("フュージョン : 青")
							}
							addaction(oAction)
							addseparator()
							oAction = new qAction(this.win1) {
								setclickEvent(Method("SetStyleColor(3)"))
								settext("フュージョン : 黒")
							}
							addaction(oAction)
							addseparator()
							oAction = new qAction(this.win1) {
								setclickEvent(Method("SetStyleColor(4)"))
								settext("モダン")
							}
							addaction(oAction)
							addseparator()
							oAction = new qAction(this.win1) {
								setclickEvent(Method("SetStyleColor(5)"))
								settext("モダン : 黒")
							}
							addaction(oAction)
							addseparator()
							oAction = new qAction(this.win1) {
								setclickEvent(Method("SetStyleColor(6)"))
								settext("モダン : 黒２")
							}
							addaction(oAction)
							addseparator()
							oAction = new qAction(this.win1) {
								setclickEvent(Method("SetStyleColor(7)"))
								settext("ノートパッド : 白")
							}
							addaction(oAction)
							addseparator()
							oAction = new qAction(this.win1) {
								setclickEvent(Method("SetStyleColor(8)"))
								settext("ノートパッド : 紫")
							}
							addaction(oAction)
							addseparator()
							oAction = new qAction(this.win1) {
								setclickEvent(Method("SetStyleColor(9)"))
								settext("ノートパッド : 暗青")
							}
							addaction(oAction)
							addseparator()
							oAction = new qAction(this.win1) {
								setclickEvent(Method("SetStyleColor(10)"))
								settext("ノートパッド : 黒")
							}
							addaction(oAction)
							addseparator()
							oAction = new qAction(this.win1) {
								setclickEvent(Method("SetStyleColor(11)"))
								settext("アート")
							}
							addaction(oAction)
							addseparator()
							oAction = new qAction(this.win1) {
								setclickEvent(Method("SetStyleColor(12)"))
								settext("アート２")
							}
							addaction(oAction)
							addseparator()
							oAction = new qAction(this.win1) {
								setclickEvent(Method("SetStyleColor(13)"))
								settext("アート３")
							}
							addaction(oAction)
							addseparator()
							oAction = new qAction(this.win1) {
								setclickEvent(Method("SetStyleColor(14)"))
								settext("イメージ")
							}
							addaction(oAction)
							addseparator()
							oAction = new qAction(this.win1) {
								setclickEvent(Method("SetStyleColor(15)"))
								settext("イメージ２")
							}
							addaction(oAction)
						}
						addseparator()
						subStyle = addmenu("モード")
						subStyle {
							oAction = new qAction(this.win1) {
								setShortcut(new QKeySequence("Ctrl+1"))
								setclickEvent(Method("SetMode(1)"))
								settext("一般用途")
							}
							addaction(oAction)
							addseparator()
							oAction = new qAction(this.win1) {
								setShortcut(new QKeySequence("Ctrl+2"))
								setclickEvent(Method("SetMode(2)"))
								settext("Ring の学習 (エディタ + 取扱説明書)")
							}
							addaction(oAction)
							addseparator()
							oAction = new qAction(this.win1) {
								setShortcut(new QKeySequence("Ctrl+3"))
								setclickEvent(Method("SetMode(3)"))
								settext("コーディング (プロジェクトのファイル + エディタ)")
							}
							addaction(oAction)
							addseparator()
							oAction = new qAction(this.win1) {
								setShortcut(new QKeySequence("Ctrl+4"))
								setclickEvent(Method("SetMode(4)"))
								settext("コーディング (すべてのウィンドウ)")
							}
							addaction(oAction)
							addseparator()
							oAction = new qAction(this.win1) {
								setShortcut(new QKeySequence("Ctrl+5"))
								setclickEvent(Method("SetMode(5)"))
								settext("コーディング (コードエディタ)")
							}
							addaction(oAction)
							addseparator()
							oAction = new qAction(this.win1) {
								setShortcut(new QKeySequence("Ctrl+6"))
								setclickEvent(Method("SetMode(6)"))
								settext("GUI 開発 (コードエディタ + フォームデザイナー)")
							}
							addaction(oAction)
							addseparator()
							oAction = new qAction(this.win1) {
								setShortcut(new QKeySequence("Ctrl+7"))
								setclickEvent(Method("SetMode(7)"))
								settext("ウェブ開発 (コードエディタ + ウェブブラウザ)")
							}
							addaction(oAction)
							addseparator()
							oAction = new qAction(this.win1) {
								setShortcut(new QKeySequence("Ctrl+8"))
								setclickEvent(Method("SetMode(8)"))
								settext("動作検証 (プロジェクトのファイル + コードエディタ + 実行結果のウィンドウ)")
							}
							addaction(oAction)
							addseparator()
							oAction = new qAction(this.win1) {
								setShortcut(new QKeySequence("Ctrl+9"))
								setclickEvent(Method("SetMode(9)"))
								settext("通常 (すべてのウィンドウ + 下部に実行結果のウィンドウ)")
							}
							addaction(oAction)
						}
					} 
					subProgram {
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+d"))
							setbtnimage(self,"image/debug.png")
							settext("デバッグ  - 実行後に待機！")
							setclickEvent(Method(:Debug))
						}
						addaction(oAction)
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+r"))
							setbtnimage(self,"image/run.png")
							settext("実行")
							setclickEvent(Method(:Run))
						}
						addaction(oAction)
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+F5"))
							setbtnimage(self,"image/rungui.png")
							settext("GUI アプリケーションの実行 (コンソール非表示)")
							setclickEvent(Method(:RunNoConsole))
						}
						addaction(oAction)
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+F6"))
							setbtnimage(self,"image/web.png")
							settext("ウェブアプリケーションの実行 (ブラウザで開く)")
							setclickEvent(Method(:RunInBrowser))
						}
						addaction(oAction)
						addseparator()
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+Shift+M"))
							setbtnimage(self,"image/open.png")
							settext("現在のソースファイルをメインファイルとして設定")
							setclickEvent(Method(:SetMainFile))
						}
						addaction(oAction)
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+Shift+d"))
							setbtnimage(self,"image/debug.png")
							settext("メインファイル : デバッグ (実行後に待機！)")
							setclickEvent(Method(:DebugMainFile))
						}
						addaction(oAction)
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+Shift+r"))
							setbtnimage(self,"image/run.png")
							settext("メインファイル : 実行")
							setclickEvent(Method(:RunMainFile))
						}
						addaction(oAction)
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+Shift+F5"))
							setbtnimage(self,"image/rungui.png")
							settext("メインファイル : GUI アプリケーションの実行 (コンソール非表示)")
							setclickEvent(Method(:RunGUIMainFile))
						}
						addaction(oAction)
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Ctrl+Shift+F6"))
							setbtnimage(self,"image/web.png")
							settext("メインファイル : ウェブアプリケーションの実行 (ブラウザで開く)")
							setclickEvent(Method(:RunInBrowserMainFile))
						}
						addaction(oAction)
					}  
					subBrowser {
						for x=1 to len(this.aBrowserLinks)
							item = this.aBrowserLinks[x]
							oAction = new qAction(this.win1) {
								settext(item[1])
								setclickEvent(Method(:BrowserLink+"("+x+")"))
							}
							addaction(oAction)
							if x != len(this.aBrowserLinks)
								addseparator()
							ok
						next
					}
					subTools {
						oAction = new qAction(this.win1) {
							settext("フォームデザイナー")
							setclickEvent(Method(:OpenFormDesigner))
						}
						addaction(oAction)
						addseparator()
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Alt+R"))
							settext("RingREPL - コンソール")
							setclickEvent(Method(:REPLConsole))
						}
						addaction(oAction)
						oAction = new qAction(this.win1) {
							setShortcut(new QKeySequence("Alt+Shift+R"))
							settext("RingREPL - GUI")
							setclickEvent(Method(:REPLGUI))
						}
						addaction(oAction)
						addseparator()
						subOSTools = addmenu("オペレーティングシステムのツール")
						subOSTools {
							oAction = new qAction(this.win1) {
								settext("端末 (コマンドプロンプト)")
								setShortcut(new QKeySequence("Alt+Shift+T"))
								setclickEvent(Method(:OSTerminal))
							}
							addaction(oAction)
							addseparator()
							oAction = new qAction(this.win1) {
								settext("ファイルの管理 (エクスプローラ)")
								setShortcut(new QKeySequence("Alt+Shift+F"))
								setclickEvent(Method(:OSFilesManager))
							}
							addaction(oAction)
						}
					}
					subDistribute {
						oAction = new qAction(this.win1) {
							settext("オブジェクトファイルの生成 (*.ringo)")
							setclickEvent(Method("Distribute(1)"))
						}
						addaction(oAction)
						addseparator()
						oAction = new qAction(this.win1) {
							settext("Ring2EXE (コンソールアプリケーションのビルド)")
							setclickEvent(Method("Distribute(2)"))
						}
						addaction(oAction)
						addseparator()
						oAction = new qAction(this.win1) {
							settext("Ring2EXE (アプリケーションの配布 - ランタイムをすべて使用)")
							setclickEvent(Method("Distribute(3)"))
						}
						addaction(oAction)
						oAction = new qAction(this.win1) {
							settext("Ring2EXE (アプリケーションの配布 - ランタイムをすべて使用 - コンソール非表示)")
							setclickEvent(Method("Distribute(4)"))
						}
						addaction(oAction)
						oAction = new qAction(this.win1) {
							settext("Ring2EXE (RingQt アプリケーションの配布)")
							setclickEvent(Method("Distribute(5)"))
						}
						addaction(oAction)
						oAction = new qAction(this.win1) {
							settext("Ring2EXE (RingAllegro ゲームの配布)")
							setclickEvent(Method("Distribute(6)"))
						}
						addaction(oAction)
						addseparator()
						oAction = new qAction(this.win1) {
							settext("Ring2EXE (Qt プロジェクトの準備 - モバイル機器用の配布)")
							setclickEvent(Method("Distribute(7)"))
						}
						addaction(oAction)
					}
					subHelp {
						subHelpLF = addmenu("言語リファレンス")
						subHelpLF {
							oAction = new qAction(this.win1) {
								settext("CHM ファイル")
								setclickEvent(Method(:OpenCHM))
							}
							addaction(oAction)
							oAction = new qAction(this.win1) {
								settext("PDF ファイル")
								setclickEvent(Method(:OpenPDF))
							}
							addaction(oAction)
						}
						addseparator()
						subHelpTools = addmenu("開発ツール")
						subHelpTools {
	
							oAction = new qAction(this.win1) {
								settext("プログラミング言語")
								setclickEvent(Method(:Lang))
							}
							addaction(oAction)
							oAction = new qAction(this.win1) {
								settext("GUI ライブラリ")
								setclickEvent(Method(:GUI))
							}
							addaction(oAction)
						}
						addseparator()
						oAction = new qAction(this.win1) {
							settext("Ring ノートパッドについて")
							setclickEvent(Method(:pAbout))
						}
						addaction(oAction)
					}
				}
				setmenubar(menu1)
		}

	func CreateStatusbar
		win1 {
			this.status1 = new qstatusbar(this.win1) {
				showmessage("準備完了！",0)
			}
			setstatusbar(this.status1)
		}

	func StatusMessage cMsg
		status1.showmessage(cMsg,0)

	func CreateProjectFiles
		win1 {
			this.tree1 = new qtreeview(this.win1) {
				setStylesheet("font-size: 30")
				setclickedEvent(Method(:ChangeFile))
				setActivatedEvent(Method(:ChangeFile))
				setGeometry(00,00,200,400)
				setminimumwidth(floor(this.oDesktop.width()*0.2))
                		chdir(this.cStartUpFolder)
				oDir = new QDir()
				this.ofile = new QFileSystemModel() {
					setrootpath(oDir.currentpath())
					myfiles = new qstringlist() {
						append("*.ring")
						append("*.rh")
						append("*.rform")
						append("*.txt")
						append("*.html")
						append("*.rhtml")
						append("*.css")
						append("*.js")
						append("*.xml")
						append("*.data")
						append("*.sh")
						append("*.bat")
						append("*.md")
						append("*.cf")
						append("*.qml")
						append("*.ini")
					}
					setnamefilters(myfiles)
					setNameFilterDisables(false)
				}
				setmodel(this.ofile)
				myindex = this.ofile.index(oDir.currentpath(),0)
				for x = 1 to this.ofile.columncount()
					hidecolumn(x)
				next
				setcurrentindex(myindex)
				setexpanded(myindex,true)
				header().hide()
				chdir(exefolder())
				if not ismacosx()
					this.cWebsite = "file:///"+oDir.CurrentPath() + "/../docs/build/html/index.html"
				ok
			}
			this.oDockProjectFiles = new qdockwidget(this.win1,0) {
				setGeometry(00,00,200,200)
				setwindowtitle("プロジェクトのファイル")
				setwidget(this.tree1)
			}
		}

	func CreateSourceCode
		win1 {
			oTabsFilter = new qAllEvents(this.win1) {
				setContextmenuEvent(Method(:TabsContextMenu))
	                }

			this.filestabs = new qTabWidget(this.win1) {
				setFixedheight(35)
				settabsclosable(True)
				AddTab(new qWidget(),"無題")
				setcurrentchangedevent(Method(:ChangeFileTab))
				Settabcloserequestedevent(Method(:CloseFileTab))
				installeventfilter(oTabsFilter)
			}

			this.textedit1 = new codeeditor(this.win1) {
				setCursorPositionChangedEvent(Method(:CursorPositionChanged))
				setLineWrapMode(QTextEdit_NoWrap)
				setTextChangedEvent(Method(:TextChanged))
				setLineNumbersAreaColor(this.aStyleColors[:LineNumbersAreaColor])
				setLineNumbersAreaBackColor(this.aStyleColors[:LineNumbersAreaBackColor])
			}
			this.AutoComplete()
			this.oACTimer = new qtimer(this.win1) {
				setinterval(5000)
				settimeoutevent(Method(:AutoCompleteTimer))
				start()
			}
			new RingCodeHighLighter(this.textedit1.document() ) {
				if ismethod(self,:setkeywordsbold) 
					setKeywordsbold(this.lKeywordsBold)
				ok
				setColors(
					this.aStyleColors[:SyntaxKeywordsColor],
					this.aStyleColors[:SyntaxClassNamesColor],
					this.aStyleColors[:SyntaxCommentsColor],
					this.aStyleColors[:SyntaxLiteralsColor],
					this.aStyleColors[:SyntaxFunctionCallsColor]
				)
			}
			oTabsAndText = new qWidget() {
				oLayoutTabsText = new qVBoxlayout() {
					AddWidget(this.filestabs)
					AddWidget(this.textedit1)
					setContentsMargins(0,0,0,0)
					setspacing(0)
				}
				setLayout(oLayoutTabsText)
			}
			this.oDockSourceCode = new qdockwidget(this.win1,0) {
				setwidget(oTabsAndText)
				setwindowtitle("ソースコード")
				setminimumwidth(floor(this.oDesktop.width()*0.17))                                                     
			}
		}

	func CreateWebBrowser
		win1 {
			this.oWebBrowser = new qWidget() {
				setstylesheet("color: black ; background-color: rgba(239,235,231,255);")
				setWindowFlags(Qt_SubWindow)
				oWBLabel = new qLabel(this.win1) {
					setText("ウェブサイト: ")
				}
				this.oWBText = new qLineEdit(this.win1) {
					setText(this.cWebSite)
					setReturnPressedEvent(Method(:WebGo))
				}
				oWBGo = new qPushButton(this.win1) {
					setText("移動")
					setClickEvent(Method(:WebGo))
				}
				oWBBack = new qPushButton(this.win1) {
					setText("戻る")
					setClickEvent(Method(:WebBack))
				}
				oWBLayout1 = new qHBoxLayout() {
					addWidget(oWBLabel)
					addWidget(this.oWBText)
					addWidget(oWBGo)
					addWidget(oWBBack)
				}
				this.oWebView = new qWebView(this.win1) {
					loadpage(new qurl(this.cWebSite))
				}
				oWBlayout2 = new qVBoxLayout() {
					addLayout(oWBLayout1)
					addWidget(this.oWebView)
				}
				setLayout(oWBLayout2)
			}
			this.oDockWebBrowser = new qdockwidget(this.win1,0) {
				setwidget(this.oWebBrowser)
				setwindowtitle("ウェブ・ブラウザ")
			}
		}

	func CreateFunctionsList
		win1 {
			this.aFunctionsPos = []	# Lines Numbers for each function
			this.oFunctionsList = new qListwidget(this.win1) {
				setitemdoubleclickedEvent(Method(:SelectFunction))
				setitemactivatedEvent(Method(:SelectFunction))
			}
			this.oDockFunctionsList = new qDockwidget(this.win1,0) {
				setWidget(this.oFunctionsList)
				setwindowtitle("関数")
			}
		}

	func CreateClassesList
		win1 {
			this.aClassesPos = []	# Lines Numbers for each class
			this.oClassesList = new qListwidget(this.win1) {
				setitemdoubleclickedEvent(Method(:SelectClass))
				setitemactivatedEvent(Method(:SelectClass))
			}
			this.oDockClassesList = new qDockwidget(this.win1,0) {
				setWidget(this.oClassesList)
				setwindowtitle("クラス")
			}
		}

	func CreateOutputWindow
		win1 {
			this.oProcess = NULL
			this.oOutputWindow = new qWidget()
			oProcessLabel = new qLabel(this.oOutputWindow) {
				setText("入力 :")
			}
			this.oProcessText = new qlineEdit(this.oOutputWindow) {
				setreturnPressedEvent(Method(:SendProcessData))
			}
			oProcessbtnSend = new qpushbutton(this.oOutputWindow) {
				setText("送る")
				setClickEvent(Method(:SendProcessData))
			}
			oClearbtn = new qpushbutton(this.oOutputWindow) {
				setText("消去")
				setClickEvent(Method(:ClearProcess))
			}
			oProcessLayout1 = new qhboxlayout() {
				AddWidget(oProcessLabel)
				AddWidget(this.oProcessText)
				Addwidget(oProcessbtnSend)
                		Addwidget(oClearbtn)
			}
			this.oProcessEditbox = new qPlaintextedit(this.oOutputWindow) 
			oProcessLayout2 = new qvboxlayout() {
				addWidget(this.oProcesseditbox)
				addlayout(oProcesslayout1)
			}
			this.oOutputWindow.setlayout(oProcessLayout2)
			this.oDockOutputWindow = new qDockWidget(this.win1,0) {
				setwidget( this.oOutputWindow )
				setwindowtitle("実行結果")
			}
		}

	func CreateFormDesigner
		win1 {
			this.oDockFormDesigner = new qDockwidget(this.win1,0) {
				setwindowtitle("フォームデザイナー")
			}
			this.FormDesignerDock()
		}

	func PrepareDockableWindows
		win1 {
			adddockwidget(Qt_LeftDockWidgetArea,this.oDockProjectFiles,1)
			adddockwidget(Qt_RightDockWidgetArea,this.oDockSourceCode,2)
			adddockwidget(Qt_RightDockWidgetArea,this.oDockFunctionsList,1)
			adddockwidget(Qt_RightDockWidgetArea,this.oDockClassesList,1)
			adddockwidget(Qt_RightDockWidgetArea,this.oDockWebBrowser,1)
			adddockwidget(Qt_BottomDockWidgetArea,this.oDockOutputWindow,1)
			adddockwidget(Qt_RightDockWidgetArea,this.oDockFormDesigner,1)
			this.win1 {
				tabifydockwidget(this.oDockFunctionsList,this.oDockClassesList)
				tabifydockwidget(this.oDockFunctionsList,this.oDockOutputWindow)
				tabifydockwidget(this.oDockSourceCode,this.oDockFormDesigner)
				tabifydockwidget(this.oDockSourceCode,this.oDockWebBrowser)
			}
			this.oDockSourceCode.raise()
			this.oDockFunctionsList.raise()
		}

	func RingNotepadXButton
		SaveSettings() 

