# Ring ノートパットアプリケーション (RNote)
# 原作者 : Mahmoud Fayed <msfclipper@yahoo.com>
# FindPrevValue() Added by Gal Zsolt 

class RNoteFind

	func OpenFindWindow
		if isobject(oSearch)
			oSearch.activatewindow()
			return
		ok
		oSearch = new qWidget()
		{
			oLblFindWhat = new qLabel(this.oSearch)
			{
				setText("検索対象 : ")
			}
			this.oSearchValue = new qlineedit(this.oSearch)
			{
				setText(this.cSearchText)
				setReturnPressedEvent(Method(:FindValue))
			}
			oLayout1 = new qHBoxLayout()
			{
				addWidget(oLblFindWhat)
				addWidget(this.oSearchValue)
			}
			oLblReplaceWith = new qLabel(this.oSearch)
			{
				setText("置換対象 ")
			}
			this.oReplaceValue = new qlineedit(this.oSearch)
			{
				setText(this.cReplaceText)
			}

			oLayout2 = new qHBoxLayout()
			{
				addWidget(oLblReplaceWith)
				addWidget(this.oReplaceValue)
			}
			this.oSearchCase = new qCheckbox(this.oSearch)
			{
				setText("英数大小区別")
			}
			oLayout3 = new qHBoxLayout()
			{
				addWidget(this.oSearchCase)
			}
			oBtnFind = new qPushButton(this.oSearch)
			{
				setText("検索/次を検索")
				setclickEvent(Method(:FindValue))
			}
			oBtnFindPrev = new qPushButton(this.oSearch)
			{
				setText("検索/前を検索")
				setclickEvent(Method(:FindPrevValue))
			}
			oBtnReplace = new qPushButton(this.oSearch)
			{
				setText("置換")
				setclickEvent(Method(:Replace))
			}
			oBtnReplaceAll = new qPushButton(this.oSearch)
			{
				setText("すべて置換")
				setclickEvent(Method(:ReplaceAll))
			}
			oBtnClose = new qPushButton(this.oSearch)
			{
				setText("閉じる")
				setclickEvent(Method(:SearchClose))
			}
			oLayout4 = new qHBoxLayout()
			{
				addWidget(oBtnFind)
				addWidget(oBtnFindPrev)
				addWidget(oBtnReplace)
				addWidget(oBtnReplaceAll)
				addWidget(oBtnClose)
			}
			oLayout5 = new qVBoxLayout()
			{
				AddLayout(oLayout1)
				AddLayout(oLayout2)
				AddLayout(oLayout3)
				AddLayout(oLayout4)
			}
			setLayout(oLayout5)
			setwinicon(this.oSearch,"image/notepad.png")
			setWindowTitle("検索と置換")
			setFixedsize(550,160)
			setwindowflags(Qt_CustomizeWindowHint | Qt_WindowTitleHint) 
			this.oSearchFilter = new qallevents(this.oSearch)
			this.oSearchFilter.setKeyPressEvent(Method(:SearchKeyPress))
			installeventfilter(this.oSearchFilter)
			show()
		}

	func Replace
		oCursor = textedit1.textCursor()
		if oCursor.HasSelection() = false
			new qMessagebox(oSearch)
			{
				SetWindowTitle("置換")
				SetText("選択されていません")
				show()
			}
			return false
		ok
		cValue = oSearchValue.text()
		if len(cValue) < 1 return ok
		cSelected = oCursor.SelectedText()
		if oSearchCase.checkState() = Qt_Unchecked
			cValue = lower(cValue)
			cSelected = lower(cSelected)
		ok
		if cSelected != cValue
			new qMessagebox(oSearch)
			{
				SetWindowTitle("置換")
				SetText("一致するものがありません")
				show()
			}
			return false
		ok
		cValue = oReplaceValue.text()
		nStart = oCursor.SelectionStart()
		nEnd = oCursor.SelectionEnd()
		cStr = textedit1.toPlainText()
		cStr = left(cStr,nStart)+cValue+substr(cStr,nEnd+1)
		setTextAllowUndo(cStr)
		oCursor.setposition(nEnd+1,1)
		textedit1.settextcursor(oCursor)
		return FindValue()

	func ReplaceAll
		cStr = textedit1.toPlainText()
		cOldValue = oSearchValue.text()
		cNewValue = oReplaceValue.text()
		cnt = count(cStr,cOldValue)
		if len(cStr) < 1 or len(cOldValue) < 1 return ok
		if oSearchCase.checkState() = Qt_Unchecked
			# Not Case Sensitive
			cStr = SubStr(cStr,cOldValue,cNewValue,true)
		else
			# Case Sensitive
			cStr = SubStr(cStr,cOldValue,cNewValue)
		ok
		if cStr != textedit1.toPlainText()
			cMsg = "処理完了"
			cMsg = cMsg + " - 置換済み : " + cnt
		else 
			cMsg = "置換対象なし！"
		ok
		setTextAllowUndo(cStr)
		new qMessagebox(oSearch)
		{
			SetWindowTitle("すべて置換")
			SetText(cMsg)
			show()
		}

	func SearchClose
		oSearch.close()
		oSearch = NULL
		cSearchText = oSearchValue.text()
		cReplaceText = oReplaceValue.text()


	func SearchKeyPress
		if oSearchFilter.getKeyCode() = Qt_Key_Escape
			SearchClose()
		ok

	func FindValue
		oCursor = textedit1.textcursor()
		nPosStart = oCursor.Position() + 1
		cValue = oSearchValue.text()
		cStr = textedit1.toplaintext()
		if len(cStr) < 1 or len(cValue) < 1 return ok
		cStr = substr(cStr,nPosStart)
		if oSearchCase.checkState() = Qt_Unchecked
			cStr = lower(cStr)  cValue = lower(cValue)
		ok
		nPos = substr(cStr,cValue)
		if nPos > 0
			nPos += nPosStart - 2
			oCursor = textedit1.textcursor()
			oCursor.setposition(nPos,0)
			textedit1.settextcursor(oCursor)
			oCursor = textedit1.textcursor()
			oCursor.setposition(nPos+len(cValue),1)
			textedit1.settextcursor(oCursor)
			return true
		else
			new qMessagebox(oSearch)
			{
				SetWindowTitle("検索")
				SetText("見つかりません : " + cValue)
				show()
			}
			return false
		ok

	func FindPrevValue
		oCursor = textedit1.textcursor()
		nPosStart = oCursor.Position()
		cValue = oSearchValue.text()
		cStr = textedit1.toplaintext()
		if len(cStr) < 1 or len(cValue) < 1 return ok  
		if nPosStart < 1 nPosStart = len(cStr) ok
		cStr = substr(cStr,1,nPosStart-1)
		if oSearchCase.checkState() = Qt_Unchecked
			cStr = lower(cStr)  cValue = lower(cValue)
		ok
                cnt = count(cStr,cValue)
                postemp = 0
		nPos = 0
                for n = 1 to cnt
                      nPos = substring(cStr,cValue,postemp+1)
                      postemp = nPos
                next
		if nPos > 0
                        nPos--
			oCursor = textedit1.textcursor()
			oCursor.setposition(nPos,0)
			textedit1.settextcursor(oCursor)
			oCursor = textedit1.textcursor()
			oCursor.setposition(nPos+len(cValue),1)
			textedit1.settextcursor(oCursor)
			return true
		else
			new qMessagebox(oSearch)
			{
				SetWindowTitle("検索")
				SetText("見つかりません : " + cValue)
				show()
			}
			return false
		ok

        func count(cString,dString)
		sum = 0
		while substr(cString,dString) > 0
			sum++
			cString = substr(cString,substr(cString,dString)+len(dString))
		end
		return sum

	func setTextAllowUndo cText 
		# Get the Text Size 
			nTextSize = len(textedit1.toplaintext())
		# Select All of the Text 
			oCursor = textedit1.textcursor()
			# Save the current position 
				nPosStart = oCursor.Position()
			oCursor.setposition(0,0)
			textedit1.settextcursor(oCursor)
			oCursor = textedit1.textcursor()
			oCursor.setposition(nTextSize,1)
			textedit1.settextcursor(oCursor)
		# Set the new text using InsertPlainText() that support the Undo process 
			textedit1.InsertPlainText(cText)
		# Restore the Cursor Position 
			oCursor = textedit1.textcursor()
			oCursor.setposition(nPosStart,1)
			textedit1.settextcursor(oCursor)
