# Ring ノートパットアプリケーション (RNote)
# 原作者 : Mahmoud Fayed <msfclipper@yahoo.com>

class RNoteAutoComplete

	func PrepareAutoComplete
		oAutoCompleteList = new qStringList()
		# Ring キーワードの追加
			aKeywords = ["again","and","but","bye","call","case","catch",
				"changeringkeyword","changeringoperator","class",
				"def","do","done","else","elseif","end","exit","for","from",
				"func","get","give","if","import","in","load","loadsyntax",
				"loop","new","next","not","off","ok","on","or","other",
				"package","private","put","return","see","step","switch",
				"to","try","while"]
			AddItems(aKeywords,oAutoCompleteList)
		# Ring 関数の追加
			aCFunctionsList = cfunctions()
			for cFunction in aCFunctionsList
				cFunction += "()"
			next
			AddItems(aCFunctionsList,oAutoCompleteList)
		# Ring メソッドの追加
			aCMethodsList = aCFunctionsList
			for x = len(aCMethodsList) to 1 step -1
				cMethod = aCMethodsList[x]
				nPos = substr(cMethod,"_")
				if nPos
					aCMethodsList[x] = substr(aCMethodsList[x],nPos+1)
				else
					del(aCMethodsList,x)
				ok
			next
			AddItems(aCMethodsList,oAutoCompleteList)
			oAutoCompleteList.RemoveDuplicates()
		# Ring クラスの追加
			aClassesList = classes()
			aClassesNoInit = ["qapp"]
			for cClass in aClassesList
				if find(aClassesNoInit,cClass) = 0
					cClass = cClass + "() {" + nl + "}"
				else
					cClass = cClass + " {" + nl + "}"
				ok
			next
			AddItems(aClassesList,oAutoCompleteList)
		# Ring ライブラリの追加
			aLibsList = ['load "guilib.ring"' , 'load "stdlib.ring"' ,
					'load "weblib.ring"', 'load "ringlibcurl.ring"']
			AddItems(aLibsList,oAutoCompleteList)
		# リストサイズの保存
			nAutoCompleteListSize = oAutoCompleteList.Count()

	func AutoCompleteTimer
 		cFileContent = textedit1.toplaintext() # read(cActiveFileName)
		if len(cFileContent) > 3 and len(cFileContent) < 1024 # 1KByte
			CallAutoComplete()
		else
			if len(cFileContent) > 3
				CallAutoComplete()
				oACTimer.stop()
			ok
		ok

	func CallAutoComplete
		if isObject(oCompleter)
			if oCompleter.popup().isvisible() = false
				AutoComplete()
			ok
		ok


	func AutoComplete
		StatusMessage("自動補完の準備をしています ... しばらくお待ちください！")
		# 現在のファイルにある語句を追加
			cFileContent = textedit1.toplaintext() # read(cActiveFileName)
			if len(cFileContent) < 102400	# 100 KByte
				StatusMessage("自動補完の準備をしています ... ファイル内の語句を取得しています！")
				aList = Split(cFileContent," ")
				StatusMessage("自動補完の準備をしています ... 篩い分けています！")
				nMax = len(aList)
				for x = nMax to 1 step -1
					if not isalnum(aList[x])
						del(aList,x)
					ok
				next
				AddItems(aList,oAutoCompleteList)
			ok
		StatusMessage("自動補完の準備をしています ... 重複物の除去をしています！")
		oAutoCompleteList.RemoveDuplicates()
		StatusMessage("自動補完の準備をしています ... 並べ替えています！")
		oAutoCompleteList.Sort()
		oCompleter = new qCompleter3(oAutoCompleteList,textedit1)
		oCompleter.setCaseSensitivity(Qt_CaseInsensitive)
		oCompleter.setCompletionMode(QCompleter_PopupCompletion)
		oTFont.fromstring(cFont)
		oCompleter.popup().setFont(oTFont)
		textedit1.setCompleter(oCompleter)
		StatusMessage("自動補完の準備をしています ... 完了！")
		StatusMessage("準備完了...")
		if isObject(oACTimer)
			oACTimer.start()
		ok
