#!/usr/bin/perl -- 
use utf8;
use strict;
use warnings;
no warnings "redefine";
use Encode;
use DBI;
use Digest::MD5  qw(md5 md5_hex md5_base64);
use WWWFormParser;
use Carp qw(cluck confess);

# no thumbnail for these file extension
our %extNoThum = map{ ($_,1) } qw( zip 7z raw nef pef crw cr2 arw );

#####################################################################################
# low-level functions

# return first defined value in arguments list
sub dor{
	for(@_){ return $_ if defined $_; }
	return;
}

# make format time string
sub timestr{
	my($t) = @_;
	my @lt = localtime $t;
	$lt[5]+=1900;$lt[4]+=1;
	return sprintf "%d/%02d/%02d_%02d:%02d:%02d",reverse @lt[0..5];
}

# make format time string
sub timestr822{
	my($t) = @_;
	my ($week, $month, $day, $time, $year) = split /\s+/, scalar(localtime($t));
	return "$week, $day $month $year $time +0900";
}

# make size str
sub sizestr{
	my($s)=@_;
	( $s >= 1000000 ) and return sprintf("%.1fMB",$s/1000000);
	( $s >= 1000    ) and return sprintf("%.1fKB",$s/1000);
	return "${s}B";
}

# clip numeric in range
sub clipRange{
	return $_[0]<$_[1]?$_[1]:$_[0]>$_[2]?$_[2]:$_[0];
}

#####################################################################################

our $now;
our $cookie;
our $form;
our $dbh;
our $param;
our $session;

our $sql_error;
sub getSQLResult{
	my $sql = shift;
	$sql_error = '';
	my $sth = $dbh->prepare($sql);
	if( not $sth ){
		$sql_error = $dbh->errstr;
		confess $sql_error,": sql=",$sql,"\n";
		return;
	}elsif( not $sth->execute( @_ ) ){
		$sql_error = $sth->errstr;
		cluck $sql_error,": sql=",$sql,"\n";
		$sth->finish;
		return;
	}
	defined(wantarray) and return $sth;
	$sth->finish;
}
sub getSQLRow{
	my $sth = getSQLResult(@_);
	$sth or return;
	my $h = $sth->fetchrow_hashref;
	$sth->finish;
	return $h;
}
sub doSQL{
	my $sth = getSQLResult(@_);
	my $r = ($sth?1:0);
	$sth and $sth->finish;
	return $r;
}

sub startTransaction(){
	for(my $try=0;$try<30;++$try){
		return if doSQL("begin immediate");
		cluck "begin : $sql_error\n";
		sleep 1;
	}
	exitError("lock failure at begin. $sql_error");
}
sub endTransaction(){
	for(my $try=0;$try<30;++$try){
		return if doSQL("commit");
		last if $sql_error =~ /statements in progress/;
		cluck "commit: $sql_error\n";
		sleep 1;
	}
	exitError("lock failure at commit. $sql_error");
}

sub db_update($$$$){
	my($table,$keyname,$key,$item)=@_;
	my @keys = keys %$item;
	my $sql = "update $table set ".join(',',map{ "${_}=?"} @keys )." where $keyname=?";
	return doSQL($sql,(map{$item->{$_}} @keys),$key );
}

sub db_insert($$){
	my($table,$item)=@_;
	my @keys = keys %$item;
	my $sql = "insert into $table(".join(',',@keys).")values(".join(',',map{'?'}@keys).")";
	doSQL($sql,map{$item->{$_}} @keys ) and return $dbh->func('last_insert_rowid');
	return; # return undef if failed
}

##################################################################


sub main{
	$param= {@_};
	WWWFormParser::init($param->{cookie_path});
	
	$now = time;
	chdir $param->{sitedir} or exitError("cannot chdir to sitedir:$!");

	$cookie = readCookie();
	$form = eval{ parseForm($param->{multipart_max});};
	$@ and exitError($@);


	$dbh = DBI->connect("dbi:SQLite:dbname=data/.db.sqlite","","");

	# make db
	$dbh->do($_) for grep{length} split /\s*;\s*/,<<'END';

create table if not exists session(
	sid INTEGER PRIMARY KEY AUTOINCREMENT,
	uid text,
	lastaccess integer,
	sender text
);
create UNIQUE index if not exists session_uid on session(uid);
create index if not exists session_lastaccess on session(lastaccess);

create table if not exists command (
	cid INTEGER PRIMARY KEY AUTOINCREMENT,
	sid integer,
	line text
);
create index if not exists command_sid on command(sid,cid);

create table if not exists response (
	rid INTEGER PRIMARY KEY AUTOINCREMENT,
	sid integer,
	type text,
	extra text
);
create index if not exists response_sid on response(sid,rid);

END

	my @result;
	my $bHUP = 0;

	# check proxy password
	if( dor($form->{password},'') ne $param->{proxy_password} ){
		push @result,"AuthFail","proxy password not match";
	}else{
		startTransaction();

		# check session
		my $uid = $form->{client};
		$uid and $session = getSQLRow("select * from session where uid=?",$uid);
		if( $session ){
			# update last access
			db_update('session','uid',$uid,{lastaccess=>$now});
		}else{
			# create session
			my $sender = "";
			for(qw( REMOTE_ADDR HTTP_VIA FORWARDED_FOR PROXY_CONNECTION HTTP_FORWARDED )){
				$ENV{$_} and $sender.="$_=$ENV{$_},";
			}
			$session = {
				lastaccess=>$now,
				sender=>$sender,
			};
			my $seed = 0;
			for(;;){
				$session->{uid} = md5_hex($ENV{REMOTE_ADDR}.$now.$seed);
				my $sid = db_insert("session",$session);
				if(defined $sid){
					$session->{sid} = $sid;
					last;
				}
				++$seed;
			}
			push @result,"ClientID",$session->{uid};
		}

		# save command line
		for(my $i=0;;++$i){
			my $line = $form->{"line$i"};
			last if not defined $line;
			if( defined $line and length $line and $line ne 'poll' ){
				db_insert( 'command', { sid=>$session->{sid},line=>$line } );
				$bHUP = 1;
				( $line eq 'connect' ) and push @result,"ConnectRequested","wait for a time..";
				( $line eq 'disconnect' ) and push @result,"DisconnectRequested","wait for a time..";
			}
		}

		# clear old response
		my $old_rid = $form->{rowid} ||'';
		length($old_rid) and doSQL("delete from response where sid=? and rid <=?",$session->{sid},$old_rid);

		# read latest response
		{
			my $rid;
			my $sth = getSQLResult("select * from response where sid=? order by rid",$session->{sid});
			while( my $item = $sth->fetchrow_hashref ){
				push @result,$item->{type},$item->{extra};
				$rid = $item->{rid};
			}
			$sth->finish;
			defined($rid) and push @result,"RowID",$rid;
		}
		endTransaction();
	}
	print qq(Content-type: application/json; charset=UTF-8\x0d\x0a);
	print qq(\x0d\x0a);
	print "[";
	my $first =1;
	for(@result){
		if($first){
			$first=0;
		}else{
			print ',';
		}
		s/([\"\\])/\\$1/g;
		s/([\x00-\x1f\x7f])/'\\u00' . unpack('H2',$1)/eg;
		print qq("$_");
	}
	print "]\n";
	if($bHUP){
		my $fh;
		if( open($fh,"data/ircproxy.pid") ){
			my $pid = <$fh>;
			$pid =~ /(\d+)/ and kill 1 ,$pid;
			close($fh);
		}
	}
}

main(
	sitedir => '/home/www/qi2',
	cookie_path => '/qi2/',
	multipart_max => 20000,
	proxy_password =>'noenoepuu',
);

1;
