#!perl

=tmp

日本のIRCで使われている文字コードはISO-2022-JPということになっているが、
実際には
・半角カナを扱う必要がある
・漢字部分に8ビットのコードが出てくる
などの特徴を持っている。
そのあたりの事情をテストしてみよう。

=cut


use Encode;

sub hexBytes{
	my($a)=@_;
	$a =~ s/(.)/unpack('H2', $1)/egs;
	return $a;
}
sub same{
	my($a,$b)=@_;
	if(defined $a){
		if(defined $b){
			return $a eq $b;
		}
	}elsif(not defined $b){
		return 1;
	}
	return 0;
}

open(X201,">x201.txt");
open(X208,">x208.txt");
open(X212,">x212.txt");

for(my $i=0x80;$i<0xFFFF;++$i){
	# skip Surrogate Pair
	next if $i>=0xD800 && $i <= 0xDFFF;
	# unicode character
	my $u = chr($i);
	next if -1 != index("?%\x20\x22",$u);
	my $badjis = "\x5c\x78\x7b\x30\x31\x64\x65\x7d";

	my %map;
	my $count =0;
	for(qw(
		sjis
		cp932
		eucjp
		MacJapanese
  jis0201-raw
  jis0208-raw
  jis0212-raw
  	)){
		my $v = Encode::encode($_,$u);
		next if $v eq '?' or $v eq "\x20" or $v eq "\x22";
		$map{$_} = $v;
		++$count;
	}
	next if not $count;

	my $ue;
	if($i <= 0x20 || $i==0x7f || $i == '%'){
		$ue = '%'.unpack('H2',$u);
	}else{
		$ue = Encode::encode('utf8',$u);
	}
	my $fh = \*STDOUT;
	$map{'jis0212-raw'} and same($map{'sjis'},$map{'cp932'}) and $fh = \*X212;
	$map{'jis0201-raw'} and same($map{'sjis'},$map{'cp932'}) and $fh = \*X201;
	$map{'jis0208-raw'} and same($map{'sjis'},$map{'cp932'}) and $fh = \*X208;

	printf $fh "unicode=%04x %s",$i,$ue;
	for(sort keys %map){
		printf $fh  " %s=%s",$_,hexBytes($map{$_});
	}
	print $fh "\n";
}
