
	
    .file   "crt0.S"
	
#define XGLUE(a,b) a##b
#define GLUE(a,b) XGLUE(a,b)
	
#ifdef __USER_LABEL_PREFIX__
#define SYM_NAME( name ) GLUE (__USER_LABEL_PREFIX__, name)
#else
#error __USER_LABEL_PREFIX is not defined
#endif

    .text
     /*
      * Setup the assembly entry point.
      */
    .code 32
    .globl SYM_NAME(start)
    .globl SYM_NAME(_start)
SYM_NAME(start):
SYM_NAME(_start):
	mov	fp, #0	/* Null frame pointer */
	mov	r7, #0	/* Null frame pointer for Thumb */

	/* enable interrupts for gdb debugging */
	mrs    r0, cpsr
	bic    r0, r0, #0xC0
	msr    cpsr, r0
	
	mov 	a2, #0			/* Second arg: fill value */
	ldr	a1, .LC1		/* First arg: start of memory block */
	ldr	a3, .LC2	
	sub	a3, a3, a1		/* Third arg: length of block */

#ifdef __thumb__		/* Enter Thumb mode.... */
	add	a4, pc, #1	/* Get the address of the Thumb block */
	bx	a4		/* Go there and start Thumb decoding  */

	.code 16
	.global __change_mode
	.thumb_func
__change_mode:	
#endif

	bl	SYM_NAME(memset)
	
	mov 	a1, #0
	ldr	a2, .LC3
	mov	a3, a2
	bl	SYM_NAME(main)
    1:	bl	SYM_NAME(exit)
	b	1b
.LC1:
	.word	__bss_start__
.LC2:
	.word	__bss_end__
.LC3:
	.word	0
	
#if 0
#ifdef __thumb__
	.code 16
#endif
	.global SYM_NAME(__syscall)
#ifdef __thumb__
        .thumb_func
#else
	.align  4
#endif
SYM_NAME(__syscall):
	mov	r12, lr
#ifdef __thumb__
	swi	0x18
#else
	swi	0x180001
#endif
	mov	pc, r12
#endif
