package jp.sourceforge.pdt_tools.codeFolding.preferences;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.pdt_tools.codeFolding.CodeFolding;

import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.php.ui.folding.IPHPFoldingPreferenceBlock;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class FoldingPreference implements IPHPFoldingPreferenceBlock {

	public static final int FOLD_DISABLE = 0;
	public static final int FOLD_ENABLE = 1;
	public static final int FOLD_INITIALLY = 2;

	public static final String FOLD_CLASSES = "FoldClasses"; //$NON-NLS-1$
	public static final String FOLD_INTERFACES = "FoldInterfaces"; //$NON-NLS-1$
	public static final String FOLD_METHODS = "FoldMethods"; //$NON-NLS-1$
	public static final String FOLD_FUNCTIONS = "FoldFunctions"; //$NON-NLS-1$
	public static final String FOLD_PHPDOC = "FoldPHPDoc"; //$NON-NLS-1$
	public static final String FOLD_COMMENTS = "FoldComments"; //$NON-NLS-1$
	public static final String FOLD_IF = "FoldIf"; //$NON-NLS-1$
	public static final String FOLD_FOR = "FoldFor"; //$NON-NLS-1$
	public static final String FOLD_WHILE = "FoldWhile"; //$NON-NLS-1$
	public static final String FOLD_DO = "FoldDo"; //$NON-NLS-1$
	public static final String FOLD_SWITCH = "FoldSwitch"; //$NON-NLS-1$
	public static final String FOLD_CASE = "FoldCase"; //$NON-NLS-1$
	public static final String FOLD_TRY = "FoldTry"; //$NON-NLS-1$
	public static final String FOLD_CATCH = "FoldCatch"; //$NON-NLS-1$
	public static final String FOLD_ARRAY = "FoldArray"; //$NON-NLS-1$
	public static final String FOLD_HEREDOC = "FoldHereDoc"; //$NON-NLS-1$
	public static final String FOLD_REGION = "FoldRegion"; //$NON-NLS-1$
	public static final String REGION_BEGINNING = "RegionBeginning"; //$NON-NLS-1$
	public static final String REGION_ENDING = "RegionEnding"; //$NON-NLS-1$
	public static final String FOLD_BLOCKS = "FoldBlocks"; //$NON-NLS-1$

	private IPreferenceStore pref;
	private List<TriStateButton> triGroup;
	private TriStateButton foldRegion;
	private Text regionBeginning;
	private Text regionEnding;
	private PreferencePage preferencePage;

	public FoldingPreference() {
		pref = CodeFolding.getDefault().getPreferenceStore();
		IPreferenceNode node = PlatformUI
				.getWorkbench()
				.getPreferenceManager()
				.find("org.eclipse.php.ui.preferences.PHPBasePreferencePage/" + //$NON-NLS-1$
						"org.eclipse.php.ui.preferences.PHPEditorPreferencePage/"
						+ //$NON-NLS-1$
						"org.eclipse.php.ui.preferences.PHPFoldingPreferencePage"); //$NON-NLS-1$
		if (node != null) {
			IPreferencePage page = node.getPage();
			if (page instanceof PreferencePage) {
				preferencePage = (PreferencePage) page;
			}
		}
	}

	public Control createControl(Composite parent) {
		Composite compo = new Composite(parent, SWT.NONE);
		compo.setLayout(new GridLayout());
		compo.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		new Label(compo, SWT.NONE).setText(Messages.FoldingPreference_Caption);
		triGroup = new ArrayList<TriStateButton>();
		triGroup.add(new TriStateButton(compo, FOLD_CLASSES,
				Messages.FoldingPreference_FoldClasses));
		triGroup.add(new TriStateButton(compo, FOLD_INTERFACES,
				Messages.FoldingPreference_FoldInterfaces));
		triGroup.add(new TriStateButton(compo, FOLD_METHODS,
				Messages.FoldingPreference_FoldMethods));
		triGroup.add(new TriStateButton(compo, FOLD_FUNCTIONS,
				Messages.FoldingPreference_FoldFunctions));
		triGroup.add(new TriStateButton(compo, FOLD_PHPDOC,
				Messages.FoldingPreference_FoldPHPDoc));
		triGroup.add(new TriStateButton(compo, FOLD_COMMENTS,
				Messages.FoldingPreference_FoldComments));
		triGroup.add(new TriStateButton(compo, FOLD_IF,
				Messages.FoldingPreference_FoldIf));
		triGroup.add(new TriStateButton(compo, FOLD_FOR,
				Messages.FoldingPreference_FoldFor));
		triGroup.add(new TriStateButton(compo, FOLD_WHILE,
				Messages.FoldingPreference_FoldWhile));
		triGroup.add(new TriStateButton(compo, FOLD_DO,
				Messages.FoldingPreference_FoldDo));
		triGroup.add(new TriStateButton(compo, FOLD_SWITCH,
				Messages.FoldingPreference_FoldSwitch));
		triGroup.add(new TriStateButton(compo, FOLD_CASE,
				Messages.FoldingPreference_FoldCase));
		triGroup.add(new TriStateButton(compo, FOLD_TRY,
				Messages.FoldingPreference_FoldTry));
		triGroup.add(new TriStateButton(compo, FOLD_CATCH,
				Messages.FoldingPreference_FoldCatch));
		triGroup.add(new TriStateButton(compo, FOLD_ARRAY,
				Messages.FoldingPreference_FoldArray));
		triGroup.add(new TriStateButton(compo, FOLD_HEREDOC,
				Messages.FoldingPreference_FoldHereDoc));
		foldRegion = new TriStateButton(compo, FOLD_REGION,
				Messages.FoldingPreference_FoldRegion);
		foldRegion.getButton().addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				checkRegion();
			}

			public void widgetDefaultSelected(SelectionEvent e) {
			}
		});
		triGroup.add(foldRegion);
		Composite region = new Composite(compo, SWT.NONE);
		region.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false));
		GridLayout regGridLayout = new GridLayout(2, false);
		regGridLayout.marginLeft = 16;
		region.setLayout(regGridLayout);
		new Label(region, SWT.NONE)
				.setText(Messages.FoldingPreference_RegionBeginning);
		regionBeginning = new Text(region, SWT.BORDER | SWT.SINGLE);
		regionBeginning.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true,
				false));
		new Label(region, SWT.NONE)
				.setText(Messages.FoldingPreference_RegionEnding);
		regionEnding = new Text(region, SWT.BORDER | SWT.SINGLE);
		regionEnding.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true,
				false));
		regionBeginning.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				checkRegion();
			}
		});
		regionEnding.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				checkRegion();
			}
		});
		triGroup.add(new TriStateButton(compo, FOLD_BLOCKS,
				Messages.FoldingPreference_FoldBlocks));
		return compo;
	}

	public void dispose() {
	}

	public void initialize() {
		pref.setDefault(FOLD_CLASSES, FOLD_ENABLE);
		pref.setDefault(FOLD_INTERFACES, FOLD_ENABLE);
		pref.setDefault(FOLD_METHODS, FOLD_ENABLE);
		pref.setDefault(FOLD_FUNCTIONS, FOLD_ENABLE);
		pref.setDefault(FOLD_PHPDOC, FOLD_ENABLE);
		pref.setDefault(FOLD_COMMENTS, FOLD_ENABLE);
		pref.setDefault(FOLD_IF, FOLD_DISABLE);
		pref.setDefault(FOLD_FOR, FOLD_DISABLE);
		pref.setDefault(FOLD_WHILE, FOLD_DISABLE);
		pref.setDefault(FOLD_DO, FOLD_DISABLE);
		pref.setDefault(FOLD_SWITCH, FOLD_DISABLE);
		pref.setDefault(FOLD_CASE, FOLD_DISABLE);
		pref.setDefault(FOLD_TRY, FOLD_DISABLE);
		pref.setDefault(FOLD_CATCH, FOLD_DISABLE);
		pref.setDefault(FOLD_ARRAY, FOLD_DISABLE);
		pref.setDefault(FOLD_HEREDOC, FOLD_DISABLE);
		pref.setDefault(FOLD_REGION, FOLD_DISABLE);
		pref.setDefault(REGION_BEGINNING, ""); //$NON-NLS-1$
		pref.setDefault(REGION_ENDING, ""); //$NON-NLS-1$
		pref.setDefault(FOLD_BLOCKS, FOLD_DISABLE);
		for (TriStateButton tri : triGroup) {
			tri.initialize();
		}
		regionBeginning.setText(pref.getString(REGION_BEGINNING));
		regionEnding.setText(pref.getString(REGION_ENDING));
		checkRegion();
	}

	public void performDefaults() {
		for (TriStateButton tri : triGroup) {
			tri.setDefault();
		}
		regionBeginning.setText(pref.getDefaultString(REGION_BEGINNING));
		regionEnding.setText(pref.getDefaultString(REGION_ENDING));
	}

	public void performOk() {
		for (TriStateButton tri : triGroup) {
			tri.save();
		}
		pref.setValue(REGION_BEGINNING, regionBeginning.getText());
		pref.setValue(REGION_ENDING, regionEnding.getText());
	}

	private void checkRegion() {
		if (foldRegion.getState() != FOLD_DISABLE) {
			regionBeginning.setEnabled(true);
			regionEnding.setEnabled(true);
			if (preferencePage != null) {
				String beginning = regionBeginning.getText().trim();
				String ending = regionEnding.getText().trim();
				if (beginning.equals("") //$NON-NLS-1$
						|| ending.equals("") //$NON-NLS-2$
						|| beginning.equals(ending)) {
					preferencePage
							.setErrorMessage(Messages.FoldingPreference_RegionError);
					preferencePage.setValid(false);
					return;
				}
			}
		} else {
			regionBeginning.setEnabled(false);
			regionEnding.setEnabled(false);
		}
		preferencePage.setErrorMessage(null);
		preferencePage.setValid(true);
	}

	/**
	 * 3 state button
	 */
	private class TriStateButton {

		private Button button;
		private int state;
		private String prefKey;

		public TriStateButton(Composite parent, String key, String caption) {
			button = new Button(parent, SWT.CHECK);
			button.setText(caption);
			prefKey = key;
			state = FOLD_DISABLE;
			button.addSelectionListener(new SelectionListener() {
				public void widgetDefaultSelected(SelectionEvent e) {
				}

				public void widgetSelected(SelectionEvent e) {
					if (++state > 2) {
						state = 0;
					}
					setState();
				}
			});
		}

		public int getState() {
			return state;
		}

		public void setState(int state) {
			if (state < 0 || state > 2) {
				this.state = FOLD_DISABLE;
			} else {
				this.state = state;
			}
			setState();
		}

		private void setState() {
			switch (state) {
			case FOLD_DISABLE:
				button.setSelection(false);
				button.setGrayed(false);
				break;
			case FOLD_ENABLE:
				button.setSelection(true);
				button.setGrayed(true);
				break;
			case FOLD_INITIALLY:
				button.setSelection(true);
				button.setGrayed(false);
				break;
			}
		}

		public void initialize() {
			setState(pref.getInt(prefKey));
		}

		public void setDefault() {
			setState(pref.getDefaultInt(prefKey));
		}

		public void save() {
			pref.setValue(prefKey, getState());
		}

		public Button getButton() {
			return button;
		}
	}

}
