------------------------------------------------------------------------------
-- Copyright 2018 Levashev Ivan Aleksandrovich                              --
--                                                                          --
-- Licensed under the Apache License, Version 2.0 (the "License");          --
-- you may not use this file except in compliance with the License.         --
-- You may obtain a copy of the License at                                  --
--                                                                          --
--     http://www.apache.org/licenses/LICENSE-2.0                           --
--                                                                          --
-- Unless required by applicable law or agreed to in writing, software      --
-- distributed under the License is distributed on an "AS IS" BASIS,        --
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. --
-- See the License for the specific language governing permissions and      --
-- limitations under the License.                                           --
------------------------------------------------------------------------------

with Ada.Unchecked_Deallocation;
with System;
with Ada.Unchecked_Conversion;

package Referencing.Types.Operations is

   type Referenced_Access is access all Referenced'Class;
   function To_Access is
     new Ada.Unchecked_Conversion (System.Address, Referenced_Access);
   procedure Free is new Ada.Unchecked_Deallocation (Object => Referenced'Class, Name => Referenced_Access);
   function To_Address is
     new Ada.Unchecked_Conversion (Referenced_Access, System.Address);

   function Is_Unique (Object : Referenced'Class) return Boolean;
   pragma Inline(Is_Unique);
   procedure Retain (Object : in out Referenced'Class);
   pragma Inline(Retain);
   procedure Release (Object : in out Referenced'Class; Result : out Boolean);
   pragma Inline(Release);

end Referencing.Types.Operations;
