package portablesimulator.skillset;

public final class SkillKind implements Comparable {
    static int staticSeq = 1;

    public SkillKind(String name) {
        this.seq = staticSeq ++;
        this.name = name;
    }

    public final String name;
    public final int seq;

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        SkillKind that = (SkillKind)o;
        if (seq < that.seq) return -1;
        if (seq > that.seq) return  1;
        return 0;
    }

    public String toString() {
        return name;
    }
}
