package portablesimulator.gui;

import java.awt.Color;
import javax.swing.JCheckBox;
import portablesimulator.csv.Repository;

public class JCheckBoxEx extends JCheckBox {
    public JCheckBoxEx() {
        super();
    }

    public JCheckBoxEx(String text) {
        super(text);
    }

    public void updateUI() {
        super.updateUI();

        if (Repository.getConfig().themeLabelColorful) {
            if (saveColor != null) {
                super.setForeground(saveColor);
            }else {
                super.setForeground(Color.white);
            }
        }else {
            if (saveColor != null) {
                Color c = saveColor;
                while (c.getBlue() + c.getGreen() + c.getRed() > 240) {
                    c = c.darker();
                }
                super.setForeground(c);
            }else {
                super.setForeground(Color.black);
            }
        }
    }

    public void setForegroundEx(Color color) {
        saveColor = color;
        super.setForeground(saveColor);
    }

    Color saveColor = null;
}
