package portablesimulator.decoration;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import portablesimulator.Engine;
import portablesimulator.PSArmorSet;
import portablesimulator.PSItem;
import portablesimulator.PSItemType;
import portablesimulator.PSWrap;
import portablesimulator.csv.PSSession;
import portablesimulator.csv.PSSearchItems;
import portablesimulator.csv.Repository;
import portablesimulator.skillset.SkillKind;
import portablesimulator.skillset.SkillSet;

public class DecorationMatcher {

    public List<PSItem> decorations;
    public boolean debug = false;
    public boolean quickScan = true;
    private Map<SkillKind, Double[]> decorationWeight = new HashMap<SkillKind, Double[]>();
    private List<DecorationSlot> cacheDecorationSet = new ArrayList<DecorationSlot>();
    private DecorationSlot cacheSlot = null;
    private boolean existSomeRelation;
    public boolean existConflict;
    public DecorationMatcher conflictMatcher = null;
    public PSSession session;
    public PSSearchItems items;
    public SkillSet targetSkills;
    public boolean useAnotherCheck = false;
    public boolean existAnotherSlot = false;
    public boolean existAnotherSkill = false;

    public DecorationMatcher(PSSession session, SkillSet skills, PSSearchItems items) {
        this.session = session;
        this.targetSkills = skills;
        this.decorations = new ArrayList<PSItem>();
        this.items = items;

        List<PSItem> deco0 = Repository.getBaseItems().listDecoration;
        for (int i = 0; i < deco0.size(); ++i) {
            PSItem deco = deco0.get(i);
            if (decoIsForSkillKind(deco, skills)) {
                if (session.searchWithUsableStatus && items != null) {
                    int uc = items.searchUsableCount.get(deco);
                    if (uc == 0) {
                        continue;
                    }
                    if (uc != Integer.MAX_VALUE) {
                        quickScan = false;
                    }
                } else {
                    if (deco.existHunterRank > session.searchHunterRank
                            && deco.existTownRank > session.searchTownRank) {
                        continue;
                    }
                }
                this.decorations.add(deco0.get(i));
            }
        }

        int[] fullRelation = getPlusRelation(skills);
        existSomeRelation = fullRelation != null ? true : false;
        if (existSomeRelation) {
            for (int i = 0; i < fullRelation.length; ++i) {
                if (fullRelation[i] != 0) {
                    existConflict = true;
                }
            }
        }
        if (existConflict) {
            SkillSet skill1 = skills;
            SkillSet skill2 = new SkillSet();
            skill2.set_all(skill1);
            for (int x = 0; x < skill1.size(); ++x) {
                if (skill1.positive(x) == true) {
                    skill2.set(skill1.kind(x), skill1.point(x), skill1.positive(x));
                } else {
                    skill2.set(skill1.kind(x), 0, skill1.positive(x));
                }
            }

            PSSession search2 = session.makeCopy();
            conflictMatcher = new DecorationMatcher(search2, skill2, items);
        }
    }

    public double getDecorationWeight(SkillKind kind, boolean range, int slotMax) {
        Double[] x = decorationWeight.get(kind);
        if (x == null) {
            x = new Double[5];
            for (int width = 0; width <= 3; width++) {
                double savedWeight = 10;
                for (int i = 0; i < decorations.size(); ++i) {
                    SkillSet skills = decorations.get(i).skills;
                    int n = skills.indexOfKind(kind);
                    if (n < 0) {
                        continue;
                    }
                    if (decorations.get(i).slotCount > width) {
                        continue;
                    }
                    int point = skills.point(n);
                    if (!range) {
                        point = -point;
                    }
                    if (point >= 1) {
                        double weight = (double) point;
                        weight = decorations.get(i).slotCount / weight;

                        if (weight < savedWeight) {
                            savedWeight = weight;
                        }
                    }
                }
                x[width] = savedWeight;
            }
            decorationWeight.put(kind, x);
        }
        return x[slotMax];
    }

    public static class RelationKey {

        public RelationKey() {
        }

        public void set(SkillSet diffSkills) {
            if (key == null || key.length != diffSkills.size()) {
                key = new boolean[diffSkills.size()];
            }
            StringBuilder str = new StringBuilder();
            hashCode = 0;
            for (int i = 0; i < diffSkills.size(); ++i) {
                hashCode <<= 1;
                key[i] = false;
                SkillKind kind = diffSkills.kind(i);
                boolean range = diffSkills.positive(i);
                int point = diffSkills.point(i);
                if (range && point <= 0) {
                    continue;
                }
                if (!range && point >= 0) {
                    continue;
                }
                key[i] = true;
                hashCode += 1;
            }
        }

        public RelationKey makeCopy() {
            RelationKey another = new RelationKey();
            another.key = new boolean[key.length];
            another.hashCode = hashCode;
            for (int i = 0; i < key.length; ++i) {
                another.key[i] = key[i];
            }
            return another;
        }
        boolean[] key;
        int hashCode;

        @Override
        public int hashCode() {
            return hashCode;
        }

        @Override
        public boolean equals(Object t) {
            RelationKey target = (RelationKey) t;
            if (hashCode != target.hashCode) {
                return false;
            }
            if (key.length != target.key.length) {
                return false;
            }
            for (int i = 0; i < key.length; ++i) {
                if (key[i] != target.key[i]) {
                    return false;
                }
            }
            return true;
        }
    }
    HashMap<RelationKey, int[]> relationCache = new HashMap<RelationKey, int[]>();
    RelationKey pool1 = new RelationKey();

    public int[] getPlusRelationCached(SkillSet diffSkills) {
        pool1.set(diffSkills);

        if (relationCache.containsKey(pool1)) {
            return relationCache.get(pool1);
        }

        int[] ret = getPlusRelation(diffSkills);
        relationCache.put(pool1.makeCopy(), ret);
        return ret;
    }

    public int[] getPlusRelation(SkillSet diffSkills) {
        int[] relation = new int[diffSkills.size()];
        boolean found = false;
        int counter = 1;
        for (int i = 0; i < relation.length; ++i) {
            relation[i] = 0;
        }
        for (int i = 0; i < diffSkills.size(); ++i) {
            SkillKind kind = diffSkills.kind(i);
            boolean range = diffSkills.positive(i);
            int point = diffSkills.point(i);
            if (range && point <= 0) {
                continue;
            }
            if (!range && point >= 0) {
                continue;
            }
            for (int k = 0; k < decorations.size(); ++k) {
                PSItem deco = decorations.get(k);
                int x = deco.skills.indexOfKind(kind);
                if (x < 0) {
                    continue;
                }
                int decoPoint = deco.skills.point(x);
                if (range && decoPoint <= 0) {
                    continue;
                }
                if (!range && decoPoint >= 0) {
                    continue;
                }
                //now, found decoration
                //check another plus
                SkillKind anotherDecoSkill = deco.skills.kind(1 - x);
                int anotherDecoPoint = deco.skills.point(1 - x);

                for (int j = 0; j < diffSkills.size(); ++j) {
                    if (i == j) {
                        continue;
                    }
                    SkillKind kind2 = diffSkills.kind(j);
                    if (kind2 != anotherDecoSkill) {
                        continue;
                    }
                    boolean range2 = diffSkills.positive(j);
                    int point2 = diffSkills.point(j);
                    if (range2 && point2 <= 0) {
                        continue;
                    }
                    if (!range2 && point2 >= 0) {
                        continue;
                    }
                    if (range2 && anotherDecoPoint <= 0) {
                        continue;
                    }
                    if (!range2 && anotherDecoPoint >= 0) {
                        continue;
                    }
                    //now, found another plus
                    found = true;
                    if (relation[i] >= 1) {
                        if (relation[i] == relation[j]) {
                            continue;
                        } else if (relation[j] >= 1) {
                            int org = relation[j];
                            for (int m = 0; m < relation.length; ++m) {
                                if (relation[m] == org) {
                                    relation[m] = relation[i];
                                }
                            }
                        } else {
                            relation[j] = relation[i];
                        }
                    } else if (relation[j] >= 1) {
                        if (relation[i] == relation[j]) {
                            continue;
                        } else if (relation[i] >= 1) {
                            int org = relation[i];
                            for (int m = 0; m < relation.length; ++m) {
                                if (relation[m] == org) {
                                    relation[m] = relation[j];
                                }
                            }
                        } else {
                            relation[i] = relation[j];
                        }
                    } else {
                        relation[i] = counter;
                        relation[j] = counter;
                        counter++;
                    }
                }
            }
        }
        if (found) {
            return relation;
        }
        return null;
    }
    int[] step_cache = null;

    public int getNeedSlotCount(DecorationSlot slot) {
        int width = slot.getSlotMaxCount();
        int width2 = slot.getBodyAvailable();

        if (width2 > width) {
            width = width2;
        }
        if (step_cache == null || step_cache.length != slot.diffSkills.size()) {
            step_cache = new int[slot.diffSkills.size()];
        }
        int[] stepCount = step_cache;
        for (int i = 0; i < stepCount.length; ++i) {
            stepCount[i] = 0;
        }
        int needSlotCount = 0;
        for (int i = 0; i < slot.diffSkills.size(); ++i) {
            SkillKind kind = slot.diffSkills.kind(i);
            boolean range = slot.diffSkills.positive(i);
            int point = slot.diffSkills.point(i);
            if (!range) {
                point = -point;
            }
            if (point >= 1) {
                double weight = getDecorationWeight(kind, range, width);
                stepCount[i] = (int) Math.ceil(weight * point - 0.1);
            }
        }

        needSlotCount = 0;
        for (int i = 0; i < slot.diffSkills.size(); ++i) {
            needSlotCount += stepCount[i];
        }

        if (needSlotCount == 0) {
            return 0;
        }
        //another have minus
        //-> nothing

        //another have plus
        //-> only_max(that, another)
        if (existSomeRelation) {
            int[] relation = getPlusRelationCached(slot.diffSkills);
            if (relation != null) {
                int[] sumPositive = new int[slot.diffSkills.size()];
                int[] sumNegative = new int[slot.diffSkills.size()];
                for (int x = 0; x < relation.length; ++x) {
                    int pos = relation[x];

                    if (pos == 0 || slot.diffSkills.positive(x)) {
                        sumPositive[pos] += stepCount[x];
                    } else {
                        sumNegative[pos] += stepCount[x];
                    }
                }
                needSlotCount = 0;
                for (int i = 0; i < sumPositive.length; ++i) {
                    if (i == 0) {
                        needSlotCount += sumPositive[i] + sumNegative[i];
                    } else if (sumPositive[i] > sumNegative[i]) {
                        needSlotCount += sumPositive[i];
                    } else {
                        needSlotCount += sumNegative[i];
                    }
                }
                return needSlotCount;
            } else {
                return needSlotCount;
            }
        } else {
            return needSlotCount;
        }
    }
    //TreeSet<DecorationSlot> queue = new TreeSet<DecorationSlot>();
    SkillSet cache1 = new SkillSet();
    SkillSet cache2 = new SkillSet();
    static int maxQueue = 0;
    public static Comparator quickComp = new Comparator() {

        public int compare(Object a, Object b) {
            DecorationSlot that = (DecorationSlot) a;
            DecorationSlot target = (DecorationSlot) b;

            int x = 0;

            if (x == 0) {
                for (int i = 0; i < that.diffSkills.size(); ++i) {
                    x = that.diffSkills.point(i) - target.diffSkills.point(i);
                    if (x != 0) {
                        break;
                    }
                }
            }
            if (x == 0) {
                for (int i = 0; i < that.slotAvail.length; ++i) {
                    x = that.slotAvail[i] - target.slotAvail[i];
                    if (x != 0) {
                        break;
                    }
                }
            }
            if (x < 0) {
                return -1;
            }
            if (x > 0) {
                return 1;
            }
            return 0;
        }
    };
    TreeSet<DecorationSlot> queue = null;
    TreeSet<DecorationSlot> already = null;

    public boolean canHaveEnoughDecoration(PSArmorSet set, boolean fullScan, List<DecorationSlot> result) {
        if (debug) {
            System.out.println("canHaveEnough " + set + ", " + fullScan);
        }
        if (useAnotherCheck) {
            existAnotherSlot = false;
            existAnotherSkill = false;
        }

        if (conflictMatcher != null) {
            if (conflictMatcher.canHaveEnoughDecoration(set, fullScan, null) == false) {
                return false;
            }
        }

        boolean isCached = false;

        if (queue != null) {
            if (quickScan && !fullScan) {
                if (queue.comparator() == quickComp) {
                    isCached = true;
                }
            } else {
                if (queue.comparator() != quickComp) {
                    isCached = true;
                }
            }
        }

        if (!isCached) {
            if (quickScan && !fullScan) {
                queue = new TreeSet<DecorationSlot>(quickComp);
                already = new TreeSet<DecorationSlot>(quickComp);
            } else {
                queue = new TreeSet<DecorationSlot>();
                already = new TreeSet<DecorationSlot>();
            }
        } else {
            queue.clear();
            already.clear();
        }

        boolean found = false;
        SkillSet masked = cache2;

/*        SkillSet temp1 = set.listItems.get(0).maskedSkills;
        if (temp1 != null && temp1.isFixedBy(targetSkills)) {
            set.calculateUseList(masked, true);
        }else*/ {
            masked.clear();
            set.calculateUseList(masked, false);
            //masked = masked.fixColumnBy(targetSkills);
        }
        SkillSet diffSkill = cache1;
        diffSkill.clear();
        diffSkill.set_all(targetSkills);
        diffSkill.minus_only(masked);

        if (cacheSlot == null) {
            cacheSlot = new DecorationSlot(decorations);
        }
        DecorationSlot slot = cacheSlot;
        int slotCount = set.weaponSlotCount;
        if (slotCount < 0) {
            slotCount = 0;
        }

        slot.construct(diffSkill, set, slotCount);

        int needSlotCount = getNeedSlotCount(slot);

        if (debug) {
            System.out.println("need Slot:" + needSlotCount + "/" + diffSkill);
        }

        if (set.weaponSlotCount < 0) {
            if (needSlotCount == 0) {
                if (result != null) {
                    result.add(slot);
                }
                return true;
            } else {
                return false;
            }
        }
        if (needSlotCount > slot.totalAvailCount()) {
            if (debug) {
                System.out.println("overflow");
            }
            return false;
        }
        if (debug) {
            System.out.println("enter       " + set);

            System.out.println("searchSkill " + targetSkills);
            System.out.println("setSkill    " + set.targetSkills);
            System.out.println("diffSkill   " + slot.diffSkills);
            System.out.println("test        " + needSlotCount + " <= " + slot.totalAvailCount());
        }

        queue.add(slot);

        while (queue.isEmpty() == false) {
            slot = queue.first();
            queue.remove(slot);

            if (already.contains(slot)) {
                continue;
            }
            already.add(slot);
            //if (already.size() >= 2000) {
            //    already.clear();
            //}

            boolean hit = slot.diffSkills.totalDiffPoint() == 0;

            if (hit && session.searchWithUsableStatus && items != null) {
                if (checkUsableCount(slot) == false) {
                    hit = false;
                }
            }

            if (hit) {
                found = true;
                if (result != null) {
                    result.add(slot);
                }
                if (!fullScan) {
                    return found;
                }
                continue;
            } else if (debug) {
                System.out.println("diffSkill   " + slot.diffSkills);
                System.out.println("test        " + needSlotCount + " <= " + slot.totalAvailCount());
            }

            //int bodyWidth = slot.getBodyAvailable();
            //int maxWidth = slot.getSlotMaxCount();

            for (int i = 0; i < decorations.size(); ++i) {
                PSItem deco = decorations.get(i);
                if (decoIsForDiffSkill(deco, slot.diffSkills, quickScan /*&& result != null*/)) {
                    //if (bodyWidth >= deco.slotCount) {
                        DecorationSlot next = slot.applyToBody(deco);
                        if (next != null && already.contains(next) == false && next.totalAvailCount() >= getNeedSlotCount(next)) {
                            queue.add(next);
                        }
                    //}
                    //if (maxWidth >= deco.slotCount) {
                        DecorationSlot next2 = slot.applyAuto(deco);
                        if (next2 != null && already.contains(next2) == false && next2.totalAvailCount() >= getNeedSlotCount(next2)) {
                            queue.add(next2);
                        }
                    //}
                }
            }
        }

        return found;
    }

    public boolean checkUsableCount(DecorationSlot set) {
        if (items.searchUsableCount == null) {
            return true;
        }

        DecorationCount map = new DecorationCount(decorations);
        map.addAll(set.mapDecoration);
        map.addAll(set.mapBodyDecoration);
        for (int i = 0; i < map.size(); ++i) {
            PSItem item = map.deco(i);
            int count = map.count(i);

            Integer x = items.searchUsableCount.get(item);
            if (x != null && x != Integer.MAX_VALUE) {
                if (count > x) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean decoIsForDiffSkill(PSItem item, SkillSet skills, boolean quickScan) {
        for (int i = 0; i < skills.size(); ++i) {
            SkillKind kind = skills.kind(i);
            boolean range = skills.positive(i);
            int point1 = skills.point(i);

            if ((range && point1 >= 1) || (!range & point1 <= -1)) {
                int x = item.skills.indexOfKind(kind);
                if (x >= 0) {
                    int point2 = item.skills.point(x);
                    if (range) {
                        if (point2 >= 1) {
                            return true;
                        }
                    } else {
                        if (point2 <= -1) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public boolean decoIsForSkillKind(PSItem item, SkillSet skills) {
        for (int i = 0; i < skills.size(); ++i) {
            SkillKind kind = skills.kind(i);
            boolean range = skills.positive(i);
            int point1 = skills.point(i);

            int x = item.skills.indexOfKind(kind);
            if (x >= 0) {
                int point2 = item.skills.point(x);
                if (range) {
                    if (point2 >= 1) {
                        return true;
                    }
                } else {
                    if (point2 <= -1) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean existMoreSlot(List<DecorationSlot> prevResult) {
        for (DecorationSlot slot : prevResult) {
            int x = slot.totalAvailCount();
            if (x >= 1) {
                return true;
            }
        }
        return false;
    }

    public int fixRealWeaponSlot(PSArmorSet set, List<DecorationSlot> prevResult) {
        if (set.weaponSlotCount <= 0) {
            return set.weaponSlotCount;
        }

        int maxAvailable = 0;
        for (DecorationSlot slot : prevResult) {
            int x = slot.getWeaponSlotAvailable();
            if (x >= maxAvailable) {
                maxAvailable = x;
                ;
            }
        }
        return set.weaponSlotCount - maxAvailable;
    }
}
