package portablesimulator.csv;

import javax.swing.JOptionPane;
import portablesimulator.charm.CharmDB;
import portablesimulator.skillset.SkillCategories;
import portablesimulator.skillset.SkillFukugo;

public class Repository {
    private static GameResource resource;

    public static GameResource getResource() {
        return resource;
    }

    private static SkillCategories categories;

    public static SkillCategories getSkillCategories() {
        return categories;
    }

    private static CharmDB charm;

    public static CharmDB getCharmDB() {
        return charm;
    }

    private static PSConfig config;

    public static PSConfig getConfig() {
        return config;
    }

    private static PSMySet myset;

    public static PSMySet getMySet() {
        return myset;
    }

    private static PSBaseItems baseItems;

    public static PSBaseItems getBaseItems() {
        return baseItems;
    }

    private static SkillFukugo fukugo;

    public static SkillFukugo getFukugo() {
        return fukugo;
    }

    static boolean inited = false;

    public static void init() {
        if (inited) {
            return;
        }

        inited = true;

        try {
            baseItems = new PSBaseItems();
            resource = new MHP2GResource();//ύXƂR̃[Xł܂
            config = new PSConfig(resource.getConfigFile());
            myset = new PSMySet(resource.getMysetFile());
            categories = new SkillCategories();
            charm = new CharmDB(categories);
            fukugo = new SkillFukugo();

            resource.readCSV();
            config.readProperties();
            myset.readProperties();

            baseItems.invalidate();
            if (resource.existCharm()) {
                charm.readProperties();
            }
        } catch (Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "AvP[Vł܂B" + e);
            System.exit(-1);
        }

        Runtime.getRuntime().addShutdownHook(new Thread() {

            public void run() {
                try {
                    getConfig().writeProperties();
                    getMySet().writeProperties();
                    getResource().shutdownHook();
                } catch (Throwable e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, e.toString());
                }
            }
        });
    }
}
