package portablesimulator.charm;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import portablesimulator.PSItem;
import portablesimulator.PSItemType;
import portablesimulator.csv.CSVReader;
import portablesimulator.csv.Repository;
import portablesimulator.skillset.SkillCategories;
import portablesimulator.skillset.SkillKind;
import portablesimulator.skillset.SkillSet;

public class CharmDB {

    public static final ArrayList<String> acceptTypes = new ArrayList<String>();
    
    static void init() {
        acceptTypes.add("m");
        acceptTypes.add("Rm");
        acceptTypes.add("m");
        acceptTypes.add("");
        acceptTypes.add("");
        acceptTypes.add("");
        acceptTypes.add("");
        if (Repository.getResource().existCharmG()) {
            acceptTypes.add("pY");
            acceptTypes.add("`");
            acceptTypes.add("V");
        }
    }

    SkillCategories categories;
    List<Charm> listCharm = new ArrayList<Charm>();

    public CharmDB(SkillCategories categories) {
        this.categories = categories;
    }

    public void readProperties() throws IOException {
        listCharm.clear();
        readPropertiesSub(Charm.STONE_NAZO, "data_mhp3/CHARM_NAZO.csv");
        readPropertiesSub(Charm.STONE_HIKAR, "data_mhp3/CHARM_HIKARU.csv");
        readPropertiesSub(Charm.STONE_FURUI, "data_mhp3/CHARM_FURUI.csv");
    }

    public void readPropertiesSub(int stone, String fileName) throws IOException {
        CSVReader in = new CSVReader(fileName);
        ArrayList<PSItem> infoList = new ArrayList<PSItem>();
        List<String> str = new ArrayList<String>();

        try {
            while (true) {
                if (in.readLine(str) == false) {
                    break;
                }

                if (str.size() < 8) {
                    System.out.println("SKIP: " + str);
                    continue;
                }

                String strSeed = str.get(0);
                String strSkill1 = str.get(1);
                String strPoint1 = str.get(2);
                String strSkill2 = str.get(3);
                String strPoint2 = str.get(4);
                String strSlot = str.get(5);
                String strName = str.get(6);
                String strTable = str.get(7);

                int nSeed;
                int nPoint1;
                int nPoint2;
                int nTable;
                int nSlot;
                SkillKind kind1;
                SkillKind kind2;

                try {/*
                    boolean okName = false;
                    for (int i = 0; i < acceptTypes.size(); ++ i) {
                        if (strName.equals(acceptTypes.get(i))) {
                            okName = true;
                            break;
                        }
                    }
                    if (!okName) {
                        continue;
                    }*/
                    nSeed = Integer.parseInt(strSeed);
                    nPoint1 = Integer.parseInt(strPoint1);
                    nPoint2 = Integer.parseInt(strPoint2);
                    nTable = Integer.parseInt(strTable);
                    nSlot = Integer.parseInt(strSlot);
                    kind1 = null;
                    kind2 = null;
                    if (strSkill1.length() > 0) {
                        if (strSkill1.startsWith("--") == false) {
                            if (strSkill1.equals("Ƃ")) {
                                strSkill1 = "";
                            }
                            if (strSkill1.endsWith("rǉ")) {
                                strSkill1 = strSkill1.substring(0, strSkill1.length() - 4) + "rǉ";
                            }
                            if (strSkill1.equals("ڌrǉ")) {
                                strSkill1 = "ڌrǉ";
                            }
                        }else {
                            continue;
                        }
                        kind1 = categories.findKindByName(strSkill1);
                        if (kind1 == null) {
                            throw new IllegalArgumentException(strSkill1);
                        }
                    }
                    if (strSkill2.length() > 0) {
                        if (strSkill2.startsWith("--") == false) {
                            if (strSkill2.equals("Ƃ")) {
                                strSkill2 = "";
                            }
                            if (strSkill2.endsWith("rǉ")) {
                                strSkill2 = strSkill2.substring(0, strSkill2.length() - 4) + "rǉ";
                            }
                            if (strSkill2.equals("ڌrǉ")) {
                                strSkill2 = "ڌrǉ";
                            }
                        }else {
                            continue;
                        }
                        kind2 = categories.findKindByName(strSkill2);
                        if (kind2 == null) {
                            throw new IllegalArgumentException(strSkill2);
                        }
                    }
                } catch (Exception e) {
                    continue;
                }


                Charm charm = new Charm(stone, nTable, strName, nSlot, kind1, nPoint1, kind2, nPoint2);

                listCharm.add(charm);
            }
        } finally {
            in.close();
        }
    }

    public List<PSItem> readExtraCharm(SkillSet searchSkills) {
        List<PSItem> listCharm2 = new ArrayList<PSItem>();

        for (Charm charm : listCharm) {
            boolean hit = false;

            for (int i = 0; i < charm.skills.size(); ++i) {
                int x = searchSkills.indexOfKind(charm.skills.kind(i));
                if (x >= 0) {
                    if (searchSkills.positive(x)) {
                        if (charm.skills.point(i) > 0) {
                            hit = true;
                            break;
                        }
                    } else {
                        if (charm.skills.point(i) < 0) {
                            hit = true;
                            break;
                        }
                    }
                    break;
                }
            }

            if (!hit) {
                continue;
            }

            PSItem item = new PSItem(PSItemType.TYPE_CHARM);
            item.name = charm.name + " T" + charm.tableNumber;
            item.slotCount = charm.slotCount;
            item.skills.set_all(charm.skills);

            listCharm2.add(item);
        }
        System.out.println("readExtraCharm " + searchSkills + "= " + listCharm2.size());
        return listCharm2;
    }
}
