/*
 * OpenI2CRADIO
 * Rotary encoder routine.
 * Copyright (C) 2013-10-21 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */
#include "rencoder.h"

static unsigned char renc_state_a;
static unsigned char renc_state_b;
unsigned char renc_dir;
unsigned int renc_count;
static unsigned int renc_reset_count;
//static unsigned char renc_penalty;
unsigned char renc_flag;


void rencoder_init(void)
{
   RENC_TRIS_A = 1;
   RENC_TRIS_B = 1;
   renc_count = 0;
   renc_dir = RENC_NONE;
   renc_state_a = RENC_PH_A;
   renc_state_b = RENC_PH_B;
   renc_reset_count = 0;
   renc_flag = 0;
//   renc_penalty = 0;
}


void rencoder_restart(void)
{
 //  T1CONbits.TMR1ON = 1;
   T1CON = 0b10110100;// RD16, T1RUN=0, 1/32 fOSC, TNR1CS=0, TMR1ON=0;
   TMR1H = (65536 - 400) >> 8; // Tick = 4us, Count = 600(2.4ms)
   TMR1L = (65536 - 400) & 255;
//   T1CONbits.TMR1ON = 0;
   PIR1bits.TMR1IF = 0;
   PIE1bits.TMR1IE = 1;
   IPR1bits.TMR1IP = 1;
   T1CONbits.TMR1ON = 1;
}

void rencoder_start(void)
{
    rencoder_stop();
    rencoder_init();
//    rencoder_restart();
    IOCB = 0b01100000; // RB5,RB6
    INTCONbits.RBIF = 0;
    INTCONbits.RBIE = 1;
    INTCONbits.GIE = 1;
    INTCONbits.PEIE = 1;

}

void rencoder_inthook(void)
{
//    IOCB = 0b01100000;
//    IOCBbits.IOCB4 = 1;
    INTCONbits.RBIF = 0;
    if(renc_flag != 0) return;
//    renc_state_a = RENC_PH_A;
//    renc_state_b = RENC_PH_B;
    renc_flag = 0xff;
    rencoder_restart();
    rencoder_count();
    INTCONbits.RBIE = 1;
}

void rencoder_tmrhook(void)
{
    renc_flag = 0;
    rencoder_count();
    IOCB = 0b01100000;
    INTCONbits.RBIF = 0;
    INTCONbits.RBIE = 1;

   PIR1bits.TMR1IF = 0;
   PIE1bits.TMR1IE = 0;
   IPR1bits.TMR1IP = 1;

}

void rencoder_stop(void)
{
   T1CON = 0b10110100;
   TMR1H = 0;
   TMR1L = 0;
   PIR1bits.TMR1IF = 0;
   PIE1bits.TMR1IE = 0;
   IPR1bits.TMR1IP = 1;
    IOCB = 0b00000000; // RB5,RB6
    INTCONbits.RBIE = 0;
    INTCONbits.RBIF = 0;
//   rencoder_init();
}


void rencoder_count(void)
{
   unsigned char dir = RENC_NONE;
   unsigned char pha = RENC_PH_A;
   unsigned char phb = RENC_PH_B;

  // if(renc_flag != 0) return;
//   if(renc_penalty != 0){
//       renc_penalty++;
//       if(renc_penalty > 1) {
//           renc_penalty = 0;
//       }
//       return;
//   }
   /*
    * Count sequence description of rotary-encoder:
    * See figure of http://homepage1.nifty.com/rikiya/software/113ROTENC.htm .
    */
   if(pha != renc_state_a) {
       if(pha == 1){ // A: RISE UP
           if(phb == 0){ // B: Stable
               dir = RENC_RIGHT;
           } else {
               dir = RENC_LEFT;
           }
        //   renc_penalty++;
        }
    } else if(phb != renc_state_b){
        if(phb == 1){ // B: RISE UP
            if(pha == 0){ // A: Stable
                dir = RENC_LEFT;
            } else {
                dir = RENC_RIGHT;
            }
      //      renc_penalty++;
        }
    }  else {
     renc_reset_count++;
     if(renc_reset_count >= 5000) { // 3200ms
	renc_count = 0;
	renc_dir = RENC_NONE;
	renc_state_a = 0;
	renc_state_b = 0;
	renc_reset_count = 0;
        //renc_penalty = 0;
     }
     return;
   }
   renc_state_a = pha;
   renc_state_b = phb;
   if(dir == RENC_NONE) return;

   if(dir == renc_dir) {
     renc_count++;
   } else {
     renc_count = 0;
     renc_dir = dir;
    }
   renc_reset_count = 0;
//   rencoder_up(dir);
}

	 
	
