package controllers
import play.api._
import play.api.i18n._
import play.api.mvc._
import play.api.data._
import play.api.data.Forms._
import forms._
import models._
import org.squeryl._
import org.squeryl.PrimitiveTypeMode._
object ProjectController extends Controller{
  val Home = Redirect(routes.ProjectController.list(0,""))
  val projectRegistForm = Form(
      mapping(
          "name" -> nonEmptyText,
          "users" -> mapping(
              "name" -> text
              )(UserForm.apply)(UserForm.unapply)
          )(ProjectForm.apply)(ProjectForm.unapply)
      )
      
	def createProject = Action { implicit request =>
	  Ok(views.html.createProjectForm(projectRegistForm))
	}
  
  	def projectRegistration() = Action {implicit request =>
  	  projectRegistForm.bindFromRequest.fold(
  	      formWithErrors => BadRequest(views.html.createProjectForm(formWithErrors)),
//	      formWithErrors => BadRequest(views.html.error(formWithErrors)),
  	      project => {
  	        inTransaction {
  	          val user = getUser(project.users.name)
  	          val newProject = PartsListDb.projects.insert(Project(project.name))
  	          newProject.users.associate(user)
  	    	   Home.flashing("success" -> "Project %s has been created".format(project.name))
  	        }
  	      }
  	  )
  	 }
  	
  	def updateProject(id: Long) = Action { implicit request =>
  	  inTransaction {
  	    val project = getProject(id)
  	    val projectForm = ProjectForm(project.name, null)
  		Ok(views.html.updateProjectForm(projectRegistForm.fill(projectForm), id, project))
  	  }
  	}
  	
  	def projectModification(id: Long) = Action { implicit request =>
  	  projectRegistForm.bindFromRequest.fold(
  	      formWithErrors => BadRequest(views.html.updateProjectForm(formWithErrors, id, null)),
  	      project => {
  	        inTransaction {
  	          val updProject = getProject(id)
        	   updProject.name = project.name
  	          if(!project.users.name.isEmpty()) {
  	        	  val user =getUser(project.users.name)
  	        	  updProject.users.associate(user)
  	           }
  	          PartsListDb.projects.update(updProject)
  	          Home.flashing("success" -> "Project %s has been update".format(project.name))
  	        }
  	      }
  	  )
  	}
  	
  	def projectMemberDelete(projectId:Long, memberId:Long) = Action {
  	  inTransaction {
  	    PartsListDb.projectMembers.deleteWhere(pm => pm.projectId === projectId and pm.userId === memberId)
       Home.flashing("success" -> "Project %s has been update".format("ID=" +memberId))
  	  }
  	}
  	
  	def list(page: Int, key: String) = Action{ implicit request =>
  	  inTransaction {
  	    val row = Integer.decode(Messages("list.row"))
  	    val buff = PartsListDb.projects.where(p => p.name like key + "%")
  	    Ok(views.html.projectlist(buff.page(page*row, row), buff.size, key, page))
  	  }
  	}
  	
  	def getUser(name: String):User = {
  	  PartsListDb.users.where(u => u.name === name).head
  	}
  	
  	def getProject(id: Long):Project = {
  	  PartsListDb.projects.where(p => p.id === id).head
  	}
}