# -*- coding: utf-8 -*-
#
#  yaya.py - a (Real) YAYA loader for ninix
#  Copyright (C) 2004 by linjian
#  Copyright (C) 2004-2013 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#  Copyright (C) 2011 by henryhu
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import os
import sys
import logging
import traceback
from ctypes import cdll, c_char_p, c_long, create_string_buffer, byref
import _ctypes

if os.name == 'posix':
    try:
        _yaya = cdll.LoadLibrary('libaya5.so')
    except:
        logging.error('yaya load fail!')
#        traceback.print_exc()
        _yaya = None
else:
    _yaya = None


class Shiori(object):

    def __init__(self, dll_name):
        self.dll_name = dll_name
        self.pathdic = []
        self.reqdic = []
        self.id = None

    def use_saori(self, saori):
        self.saori = saori

    def find(self, topdir, dll_name):
        result = 0
        if _yaya:
            if os.path.isfile(os.path.join(topdir, 'yaya.txt')):
                result = 205
            elif dll_name is not None and \
                 os.path.isfile(os.path.join(topdir,
                                             ''.join((dll_name[:-3], 'txt')))):
                result = 105
        return result

    def show_description(self):
        logging.info(
            'Shiori: a (Real) YAYA loader for ninix\n'
            '        Copyright (C) 2004 by linjian\n'
            '        Copyright (C) 2004-2013 by Shyouzou Sugitani\n'
            '        Copyright (C) 2011 by henryhu')

    def load(self, topdir):
        self.dir = topdir
        if _yaya:
            if self.dir.endswith(os.sep):
                topdir = self.dir
            else:
                topdir = ''.join((self.dir, os.sep))
            path = create_string_buffer(topdir)
            self.pathdic += [path] # so python would not free it
#            logging.debug(repr(self.pathdic))
            # since yaya would free it (...)
            # we must not allow python to free it
            self.id = _yaya.multi_load(path, len(topdir))
            ret = 1
#            logging.debug('load result: {0:d}'.format(ret))
            ## FIXME: ctypes.CFUNCTYPE
            ##_yaya.setcallback(self.saori_exist,
            ##                  self.saori_load,
            ##                  self.saori_unload,
            ##                  self.saori_request)
            return ret
        else:
            return 0

    def unload(self):
        if _yaya:
            _yaya.multi_unload(self.id)
            self.id = None

    def request(self, req_string):
        if _yaya:
            reqf = _yaya.multi_request
            reqf.restype = c_char_p
            request = create_string_buffer(req_string)
            # since yaya may free it (...)
            # we must not allow python to free it
            self.reqdic += [request] # so python would not free it
            rlen = c_long(len(request))
#            logging.debug('request: {0}'.format(req_string))
            ret = reqf(self.id, request, byref(rlen))
#            logging.debug('result len: {0:d}'.format(rlen.value))
#            logging.debug(ret)
            return ret
        else:
            return '' # FIXME

##    def saori_exist(self, saori):
##        module = self.saori.request(saori)
##        if module:
##            self.saori_list[saori] = [module, 0]
##            return len(self.saori_list)
##        else:
##            return 0
##
##    def saori_load(self, saori, path):
##        result = 0
##        if saori in self.saori_list and self.saori_list[saori][1] == 0:
##            result = self.saori_list[saori][0].load(path)
##            self.saori_list[saori][1] = result
##        return result
##
##    def saori_unload(self, saori):
##        result = 0
##        if saori in self.saori_list and self.saori_list[saori][1] != 0:
##            result = self.saori_list[saori][0].unload()
##            self.saori_list[saori][1] = 0
##        return result
##
##    def saori_request(self, saori, req):
##        result = 'SAORI/1.0 500 Internal Server Error'
##        if saori in self.saori_list:
##            if self.saori_list[saori][1] == 0:
##                head, tail = os.path.split(saori)
##                self.saori_list[saori][1] = \
##                                          self.saori_list[saori][0].load(head)
##            if self.saori_list[saori][1]:
##                result = self.saori_list[saori][0].request(req)
##        return result
