/*
 * FeliCa2Money
 *
 * Copyright (C) 2001-2007 Takuya Murakami
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef	_CARD_H
#define	_CARD_H

#include <stdio.h>
#include "Transaction.h"

/**
   @brief J[hNX
*/
class CardBase {
protected:	
    AnsiString	Ident;		///< J[h (Ident)
    AnsiString	CardName;	///< J[h
    AnsiString	CardId;		///< J[hŗLID (IDm)

public:
    /// J[hIDݒ肷
    inline void SetCardId(AnsiString &id) {
	CardId = id;
    }

    /// Ident Ԃ
    inline char *getIdent(void)	{ return Ident.c_str(); }

    /// J[hԂ
    inline char *getCardName(void)	{ return CardName.c_str(); }

    /// J[hŗLIDԂ
    inline char *getCardId(void)    { return CardId.c_str(); }
};

/**
   @brief J[hNX(gUNVǗ)
*/
class Card : public CardBase
{
protected:
    vector<Transaction*> list;	///< gUNVXg

private:
    int prev_key, serial;		///< gUNVIDp

public:
    Card();
    virtual ~Card();

    /**
       @brief J[hǂݍ
	   
       J[hǂݍ݁AJ[hID擾AgUNVXg\B
    */
    virtual int ReadCard(void) = 0;

    inline bool hasAnyTransaction(void) { return list.size() > 0 ? true : false; }

    inline vector<Transaction *>::iterator begin() {
	return list.begin();
    }
    inline vector<Transaction *>::iterator end() {
	return list.end();
    }

    /** gUNV ID  */
    int GenerateTransactionId(int key);
};

/**
   @brief J[hNX (Cp[Tt)
*/
class CardWithLineParser : public Card
{
public:
    int ParseLines(TStringList *lines, bool reverse = false);

private:    
    /**
       @brief gUNV̐
       @param nrows[in] ̓J
       @param rows[in] ̓J̊e
       @param err[out] G[R[h
       @return gUNV

       SFCPeep ̊eo͍sɑ΂Aes̃J𕪉̂ɓnB
       {֐́A͂AgUNV𐶐ĕԂB
    */
    virtual Transaction *GenerateTransaction(int nrows, AnsiString *rows, int *err) = 0;

    /** ^uŋ؂ꂽg[N؂o */
    char * getTabbedToken(char **pos);
};

#endif	// _CARD_H
