#include "stdafx.h"

#include "NameAcceptor.h"

class __declspec(uuid("{F6ABBA6B-B56F-42d8-A7E5-03E7143596F0}")) CSimpleNameAcceptor
	: public CComObjectRoot
	, public INameAcceptor
{
public:
	BEGIN_COM_MAP(CSimpleNameAcceptor)
		COM_INTERFACE_ENTRY(INameAcceptor)
	END_COM_MAP( )

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT Init(LPCWSTR v_pPrefix) throw()
	{
		if ( !v_pPrefix) {
			v_pPrefix = L"";
		}
		try {
			prefix_ = v_pPrefix;
		}
		catch (...) {
			return E_OUTOFMEMORY;
		}
		return S_OK;
	}

	virtual HRESULT __stdcall IsAcceptable(LPCWSTR v_pName) throw()
	{
		if ( !v_pName) {
			v_pName = L"";
		}

		try {
			int prefixLen = prefix_.GetLength();
			if (prefixLen == 0) {
				// p^[ȂΔr܂łȂɐ
				return S_OK;
			}

			CAtlStringW name(v_pName);
			int nameLen = name.GetLength();

			if (nameLen < prefixLen) {
				// Ώۂp^[ZΏɕs
				return S_FALSE;
			}

			if (nameLen > prefixLen) {
				// p^[̒܂Ő؂l߂
				name.Truncate(prefixLen);
			}

			return prefix_.Compare(name) == 0 ? S_OK : S_FALSE;
		}
		catch (...) {
			return E_FAIL;
		}
	}

protected:

	CAtlStringW prefix_;
};


HRESULT __stdcall CreateSimpleNameAcceptor(LPCWSTR v_pPrefix, INameAcceptor** v_ppAcceptor) throw()
{
	if ( !v_ppAcceptor) {
		return E_POINTER;
	}

	HRESULT hr;

	CComObject<CSimpleNameAcceptor>* pAcceptorImpl = NULL;
	hr = CComObject<CSimpleNameAcceptor>::CreateInstance(&pAcceptorImpl);
	if (FAILED(hr)) {
		return hr;
	}
	CComPtr<INameAcceptor> pAcceptor(pAcceptorImpl);

	hr = pAcceptorImpl->Init(v_pPrefix);
	if (FAILED(hr)) {
		return hr;
	}

	return pAcceptor.CopyTo(v_ppAcceptor);
}


class __declspec(uuid("{BDD74DA3-8C81-4358-8821-DCF1EB3D6112}"), novtable) CSimpleNameAcceptorFactory
	: public CComObjectRoot
	, public CComCoClass<CSimpleNameAcceptorFactory, &__uuidof(CSimpleNameAcceptorFactory)>
	, public ISingleArgNameAcceptorFactory
{
public:
	DECLARE_OBJECT_DESCRIPTION("CSimpleNameAcceptorFactory Object")

	BEGIN_COM_MAP(CSimpleNameAcceptorFactory)
		COM_INTERFACE_ENTRY(ISingleArgNameAcceptorFactory)
	END_COM_MAP( )

	DECLARE_CLASSFACTORY()
	DECLARE_NO_REGISTRY()

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct() throw()
	{
		return S_OK;
	}

	virtual HRESULT __stdcall CreateSingleArgNameAcceptor(LPCWSTR v_pArg, INameAcceptor** v_ppAcceptor) throw()
	{
		return CreateSimpleNameAcceptor(v_pArg, v_ppAcceptor);
	}
};

OBJECT_ENTRY_NON_CREATEABLE_EX_AUTO(__uuidof(CSimpleNameAcceptorFactory), CSimpleNameAcceptorFactory);

HRESULT __stdcall CreateSimpleNameAcceptorFactory(ISingleArgNameAcceptorFactory** v_ppFactory) throw()
{
	return CSimpleNameAcceptorFactory::CreateInstance(v_ppFactory);
}
