#include "stdafx.h"

#include "NameAcceptor.h"

class __declspec(uuid("{1AECA6C1-4786-45cc-99EE-B0CAAB406025}")) CMultiNameAcceptor
	: public IMultiNameAcceptor
	, public CComObjectRoot
	, public CComCoClass<CMultiNameAcceptor, &__uuidof(CMultiNameAcceptor)>
{
public:
	DECLARE_OBJECT_DESCRIPTION("CMultiNameAcceptor Object")

	BEGIN_COM_MAP(CMultiNameAcceptor)
		COM_INTERFACE_ENTRY(IMultiNameAcceptor)
		COM_INTERFACE_ENTRY(INameAcceptor)
	END_COM_MAP( )

	DECLARE_CLASSFACTORY()
	DECLARE_NO_REGISTRY()

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct() throw()
	{
		bMatchAll_ = FALSE;
		return S_OK;
	}

	//// INameAcceptor ////

	virtual HRESULT __stdcall IsAcceptable(LPCWSTR v_pName) throw()
	{
		ObjectLock lock(this);

		try {
			POSITION pos = ifs_.GetHeadPosition();
			while (pos) {
				CComPtr<INameAcceptor> pAcceptor = ifs_.GetNext(pos);
				HRESULT hr = pAcceptor->IsAcceptable(v_pName);
				if (FAILED(hr)) {
					return hr;
				}
				if (bMatchAll_) {
					if (hr == S_FALSE) {
						// S}b`[hŁAꂩS_FALSEԂ
						return S_FALSE;
					}
				}
				else {
					if (hr == S_OK) {
						// 1}b`[hŁAꂩS_OKԂ
						return S_OK;
					}
				}
			}

			// S}b`ŁAׂĂ}b`A1o^ĂȂS_OK
			// 1}b`ŁAׂĂA}b`A1o^ĂȂS_FALSE
			return bMatchAll_ ? S_OK : S_FALSE;
		}
		catch (...) {
			return E_FAIL;
		}
	}

	//// IMultiNameAcceptor ////

	virtual HRESULT __stdcall SetMode(BOOL v_matchAll) throw()
	{
		ObjectLock lock(this);

		bMatchAll_ = v_matchAll;
		
		return S_OK;
	}

	virtual HRESULT __stdcall GetMode(BOOL* v_pMatchAll) throw()
	{
		if ( !v_pMatchAll) {
			return E_POINTER;
		}

		ObjectLock lock(this);

		*v_pMatchAll = bMatchAll_;

		return S_OK;
	}

	virtual HRESULT __stdcall Add(INameAcceptor* v_pAcceptor) throw()
	{
		if ( !v_pAcceptor) {
			return E_INVALIDARG;
		}

		ObjectLock lock(this);

		try {
			ifs_.AddTail(v_pAcceptor);
		}
		catch (...) {
			return E_FAIL;
		}

		return S_OK;
	}

protected:

	BOOL bMatchAll_;

	CInterfaceList<INameAcceptor> ifs_;

};

OBJECT_ENTRY_NON_CREATEABLE_EX_AUTO(__uuidof(CMultiNameAcceptor), CMultiNameAcceptor);


HRESULT __stdcall CreateMultiNameAcceptor(BOOL v_matchAll,
										  IMultiNameAcceptor** v_ppNameAcceptor) throw()
{
	if ( !v_ppNameAcceptor) {
		return E_POINTER;
	}

	HRESULT hr;

	CComPtr<IMultiNameAcceptor> pMultiNameAcceptor;
	hr = CMultiNameAcceptor::CreateInstance(&pMultiNameAcceptor);
	if (FAILED(hr)) {
		return hr;
	}

	hr = pMultiNameAcceptor->SetMode(v_matchAll);
	if (FAILED(hr)) {
		return hr;
	}

	return pMultiNameAcceptor.CopyTo(v_ppNameAcceptor);
}
