#
# Cookbook Name:: berkshelf-api-server-ya
# Recipe Spec:: default_spec
#
# Copyright 2015, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require_relative '../spec_helper'

describe 'berkshelf-api-server-ya::default' do
  before {
    stub_command(%r|cd /opt/berkshelf-api/v\d+\.\d+\.\d+ && /opt/chef/embedded/bin/bundle check|).
      and_return(true)
  }

  let(:chef_run) { ChefSpec::SoloRunner.new.converge(described_recipe) }

  it 'includes berkshelf-api-server-ya recipes.' do
    expect(chef_run).to include_recipe('berkshelf-api-server-ya::app')
    expect(chef_run).to include_recipe('berkshelf-api-server-ya::http_proxy')
  end
end

