# coding: UTF-8

if $0 == __FILE__ then
	begin
		require 'rubygems'
	rescue LoadError
	end

	ROOT_PATH = File.dirname(File.expand_path(__FILE__))

	$:.unshift(ROOT_PATH + "/../")
	$:.unshift(ROOT_PATH + "/../../main/")

	require 'minitest/autorun'
end

require 'conf/01_system/hash_extension'

#=Hash の deep_merge 拡張のテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_deep_extension.rb 675 2012-05-12 15:12:21Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestHashExtension < MiniTest::Unit::TestCase

	def test_deep_merge
		source = {'a' => 'value1', 'b' => {'c' => 'value2', 'd' => {'e' => 'value3'}}}
		target = {'w' => 'value4', 'b' => {'x' => 'value5', 'y' => {'z' => 'value6'}}}

		result = source.deep_merge(target)
		assert_equal 'value1', result['a']
		assert_equal 'value2', result['b']['c']
		assert_equal 'value3', result['b']['d']['e']
		assert_equal 'value4', result['w']
		assert_equal 'value5', result['b']['x']
		assert_equal 'value6', result['b']['y']['z']
	end

	def test_deep_merge!
		source = {'a' => 'value1', 'b' => {'c' => 'value2', 'd' => {'e' => 'value3'}}}
		target = {'w' => 'value4', 'b' => {'x' => 'value5', 'y' => {'z' => 'value6'}}}

		source.deep_merge!(target)
		assert_equal 'value1', source['a']
		assert_equal 'value2', source['b']['c']
		assert_equal 'value3', source['b']['d']['e']
		assert_equal 'value4', source['w']
		assert_equal 'value5', source['b']['x']
		assert_equal 'value6', source['b']['y']['z']
	end

end
