# coding: UTF-8

require 'plugin/weblog/meta_weblog/meta_weblog_edit'

#=Movable Type のためのブログ記事編集用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: movable_type_edit.rb 895 2012-12-18 10:26:47Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MovableTypeEdit_WeblogPlugin < MetaWeblogEdit_WeblogPlugin

	def header_alias
		result = super
		return result.merge(@parent.header_alias_for_post)
	end

	def before(client, request, response)
		super

		if request.header['mt_tb_ping_urls'] != nil then
			request.header['mt_tb_ping_urls'] = request.header['mt_tb_ping_urls'].split(/[\s,]/)
		end

		response[:categories] = request.header[M2W_WEBLOG_MT_CATEGORIES]
		request.header.delete(M2W_WEBLOG_MT_CATEGORIES)
	end

	def after(client, request, response)
		super

		@parent.set_post_categories(client, response[:blogid], response[:postid], response[:categories], response.errors, response.warnings)
		@parent.publish_post(client, response[:postid], response.errors, response.warnings)
	end

end
