# coding: UTF-8

require 'net/pop'

#=メールを契機に処理を実行するメールコマンドプロセッサー
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: mail_command_processor.rb 835 2012-10-02 17:53:47Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
#
# メールを契機に何らかの処理を実行するための基盤となるメールコマンドプロセッサーです。
# 本クラスは、あくまで基盤です。以下の役割を担います。
#
# - net/pop ライブラリを利用し、メールを受信する。
# - あらかじめ add メソッドで追加されたコマンドに受信したメールを渡して処理させる。
#
# run メソッドが上記動作を実行します。
# １度の run メソッド呼び出しで本クラスは１度のメール走査を行います。
# 定期実行を行いたい場合は、外部プログラムでの対応が必要になります。
#
# また、本クラスは受信したメールをメールボックスから削除する動作は行いません。
# 処理したメールを削除したい場合には、コマンド側でメールの delete メソッドを呼び出す対応を行ってください。
class MailCommandProcessor

	attr_writer :logger

	# メールコマンドプロセッサーを構築します。
	def initialize(pop3_server_address, pop3_server_port = 110, pop3_server_user = nil, pop3_server_password = nil, logger = nil)
		@pop3_server_address = pop3_server_address
		@pop3_server_port = pop3_server_port
		@pop3_server_user = pop3_server_user
		@pop3_server_password = pop3_server_password
		@enable_ssl = false
		@logger = logger
	end

	# SSL を有効にします。
	def enable_ssl(verify_or_params = {}, certs = nil)
		@enable_ssl = true
		@verify_or_params = verify_or_params
		@certs = certs
	end

	# コマンドを設定します。
	def command=(command)
		@command = command
	end

	# メールボックスにあるメールを読み込み、コマンドを実行します。
	# コマンドの実行順序は、add メソッドにより登録した順序となります。
	# コマンドの run メソッドを順番に実行し、戻り値として true が帰ってきた場合は、メールが処理されたと判断して以降のコマンドは実行しません。
	def run
		begin
			@logger.debug("start access to pop3 server #{@pop3_server_address}:#{@pop3_server_port} by #{@pop3_server_user}") if @logger != nil
			pop = Net::POP3.new(@pop3_server_address, @pop3_server_port)
			pop.enable_ssl(@vertify_params, @certs) if @enable_ssl
			pop.start(@pop3_server_user, @pop3_server_password)

			@command.start if @command.respond_to?('start')

			begin
				pop.each_mail do |m|
					@logger.debug("accept mail #{m.unique_id}") if @logger != nil
					@command.run(m) if @command.respond_to?('run')
				end
			rescue => e
				@logger.error("catch error to pop3 server #{@pop3_server_address}:#{@pop3_server_port} by #{@pop3_server_user}") if @logger != nil
				@logger.error(e) if @logger != nil
				@command.catch(e) if @command.respond_to?('catch')
			ensure
				begin
					@logger.debug("finish access to pop3 server #{@pop3_server_address}:#{@pop3_server_port} by #{@pop3_server_user}") if @logger != nil
					@command.finish if @command.respond_to?('finish')
					pop.finish
				rescue => e
					@logger.error("timeout access to pop3 server #{@pop3_server_address}:#{@pop3_server_port} by #{@pop3_server_user}") if @logger != nil
					@logger.error(e) if @logger != nil
				end
			end
		rescue => e
			@logger.error("error access to pop3 server #{@pop3_server_address}:#{@pop3_server_port} by #{@pop3_server_user}") if @logger != nil
			@logger.error(e) if @logger != nil
			raise e
		end
	end

end
