# coding: UTF-8

require 'net/smtp'
require 'mailutils/mail_processor'

#=メール通知
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: m2w_mail_sender.rb 895 2012-12-18 10:26:47Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)

class Mail2WeblogMailSender

	attr_writer :logger

	def initialize(
			smtp_server_address, smtp_server_port,
			smtp_security_type, smtp_server_user,
			smtp_server_password,
			smtp_pop3before_smtp_server_address,
			smtp_pop3before_smtp_server_port,
			smtp_pop3before_smtp_server_user,
			smtp_pop3before_smtp_server_password,
			subject_header,
			subject_separator,
			from_address,
			reply = M2W_REPLY,
			logger = nil)
		@smtp_server_address = smtp_server_address
		@smtp_server_port = smtp_server_port
		@smtp_security_type = smtp_security_type
		@smtp_server_user = smtp_server_user
		@smtp_server_password = smtp_server_password
		@smtp_pop3before_smtp_server_address = smtp_pop3before_smtp_server_address
		@smtp_pop3before_smtp_server_port = smtp_pop3before_smtp_server_port
		@smtp_pop3before_smtp_server_user = smtp_pop3before_smtp_server_user
		@smtp_pop3before_smtp_server_password = smtp_pop3before_smtp_server_password

		@subject_header = subject_header
		@subject_separator = subject_separator
		@from_address = from_address

		@reply = reply
		@logger = logger
	end

	def sendmail(mail)
		@logger.debug("Start  #{self.class.name}#sendmail") if @logger && @logger.debug?

		if @reply then
			if !mail.instance_of?(Mail) && mail.respond_to?("to_s") then
				mail = MailProcessor.parse(mail.to_s)
			end

			@logger.debug("send mail ... subject = #{mail.subject}, from = #{MailProcessor.make_address_content(mail.from_address, M2W_SYSTEM_INNER_ENCODING)}, to = #{MailProcessor.make_addresses_content(mail.to_addresses, M2W_SYSTEM_INNER_ENCODING)}") if @logger && @logger.debug?

			if @smtp_security_type == 'POPbeforeSMTP' then
				pop = Net::POP3.new(@smtp_pop3before_smtp_server_address, @smtp_pop3before_smtp_server_port)
				pop.start(@smtp_pop3before_smtp_server_user, @smtp_pop3before_smtp_server_password)
				pop.finish
			end

			if @smtp_security_type == 'SMTP-AUTH' then
				Net::SMTP.start(@smtp_server_address, @smtp_server_port, @smtp_server_address, @smtp_server_user, @smtp_server_password, :login) do |smtp|
					smtp.send_message(
						MailProcessor.make(mail), mail.from_address.address, MailProcessor.make_address_list(mail.to_addresses)
					)
				end
			else
				Net::SMTP.start(@smtp_server_address, @smtp_server_port, @smtp_server_address) do |smtp|
					smtp.send_message(
						MailProcessor.make(mail), mail.from_address.address, MailProcessor.make_address_list(mail.to_addresses)
					)
				end
			end
		else
			@logger.debug("no send mail") if @logger && @logger.debug?
		end

		@logger.debug("Finish #{self.class.name}#sendmail") if @logger && @logger.debug?
	end

	def make_mail_as_command(command, param, header, content, to_address, attachments = [], mode = 'wiki', related_attachments = [])
		case mode
		when 'wiki', 'plain'
			return Mail.new(make_title(command, param), @from_address, [to_address], make_content(header, content, mode), attachments)
		when 'html'
			return Mail.new(make_title(command, param), @from_address, [to_address], nil, attachments, make_content(header, content, mode), related_attachments)
		else
			raise FormatPluginError.new(
				"不明な書式モードエラー(フォーマットモード = #{mode})",
				"不明な書式モードを指定しました（フォーマットモード = #{mode}）。")
		end
	end

	def make_mail_from_notice(notice)
		return make_mail_as_command(
			notice.type,
			notice.param,
			notice.header,
			notice.content,
			MailProcessor.parse_mail_address(notice.destination),
			notice.attachments,
			notice.format,
			notice.related_attachments)
	end

	def sendmail_as_command(command, param, header, content, to_address, attachments = [], mode = 'wiki', related_attachments = [])
		@logger.debug("Start  #{self.class.name}#sendmail_as_command") if @logger && @logger.debug?

		sendmail(make_mail_as_command(command, param, header, content, to_address, attachments, mode, related_attachments))

		@logger.debug("Finish #{self.class.name}#sendmail_as_command") if @logger && @logger.debug?
	end

	def send_notice(notice)
		@logger.debug("Start  #{self.class.name}#send_notice") if @logger && @logger.debug?

		sendmail(make_mail_from_notice(notice))

		@logger.debug("Finish #{self.class.name}#send_notice") if @logger && @logger.debug?
	end

	def send_notices(notices)
		@logger.debug("Start  #{self.class.name}#send_notices") if @logger && @logger.debug?

		notices.each do |notice|
			send_notice(notice)
		end

		@logger.debug("Finish #{self.class.name}#send_notices") if @logger && @logger.debug?
	end

	def make_title(command, param = nil)
		result = ""
		if @subject_header != nil then
			result << @subject_header
			result << @subject_separator
		end
		result << command
		if param != nil && param != "" then
			result << @subject_separator
			result << param.to_s
		end
		return result
	end

	def make_content(header, content, mode = 'wiki')
		@logger.debug("Start  #{self.class.name}#make_content ... header = #{header.to_s}, content = #{content}, mode = #{mode}") if @logger && @logger.debug?

		result = ""
		if header != nil && header.size > 0 then
			if header.instance_of?(Hash) then
				header.each do |key, value|
					case mode
					when 'wiki', 'plain'
						result << "#{key}#{@subject_separator}#{value}\n"
					when 'html'
						result << "<div>#{key}#{@subject_separator}#{value}</div>\n"
					end
				end
			elsif header.kind_of?(Array) then
				index = 0
				while index < header.size
					case mode
					when 'wiki'
						result << "#{header[index]}#{@subject_separator}#{header[index + 1]}\n"
					when 'html'
						result << "<div>#{header[index]}#{@subject_separator}#{header[index + 1]}</div>\n"
					end
					index = index + 2
				end
			end

			case mode
			when 'wiki', 'plain'
				result << "\n"
			when 'html'
				result << "<br />\n"
			end
		end
		if content != nil then
			result << content
		end

		@logger.debug("Finish #{self.class.name}#make_content ... result = #{result}") if @logger && @logger.debug?
		return result
	end

end
