# coding: UTF-8

if $0 == __FILE__ then
	ROOT_PATH = File.dirname(File.expand_path(__FILE__))

	$:.unshift(ROOT_PATH + "/../")
	$:.unshift(ROOT_PATH + "/../../main/")
	$:.unshift(ROOT_PATH + "/../../main/lib/")

	# mail2weblog のルートパスを設定する
	M2W_ROOT_PATH = ROOT_PATH + "/../../main/"

	require 'm2w_configurator'
	require 'minitest/autorun'
end

require 'm2w_plugin_manager'
require 'style/formatter'

#=Formatter のテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_formatter.rb 674 2012-05-12 13:49:55Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestFormatter < MiniTest::Unit::TestCase

	def test_default_mode_without_html
		formatter = Formatter.new(Mail2WeblogPluginManager.new())

		assert_equal "htmlplain", formatter.mode(Mail2WeblogRequest.new(nil, {}, "", {}))
	end

	def test_default_mode_with_html
		formatter = Formatter.new(Mail2WeblogPluginManager.new())

		assert_equal "html", formatter.mode(Mail2WeblogRequest.new(Mail.new("", nil, nil, "", {}, "", {}), {}, "", {}, {}, "", {}))
	end

	def test_wiki_mode_by_plugin_config
		formatter = Formatter.new(Mail2WeblogPluginManager.new({}, {}, {"COMMON" => {"default_format_mode" => "wiki"}}))

		assert_equal "wiki", formatter.mode(Mail2WeblogRequest.new(nil, {}, "", {}))
	end

	def test_wiki_mode_by_setter
		formatter = Formatter.new(Mail2WeblogPluginManager.new())

		assert_equal "wiki", formatter.mode(Mail2WeblogRequest.new(nil, {"mode" => "wiki"}, "", {}))
	end

	def test_wiki_mode_by_custom_setter
		formatter = Formatter.new(Mail2WeblogPluginManager.new({}, {}, {"COMMON" => {"setter_name_format_mode" => "fmode"}}))

		assert_equal "wiki", formatter.mode(Mail2WeblogRequest.new(nil, {"fmode" => "wiki"}, "", {}))
	end

end
