# coding: UTF-8

require 'mailutils/mail_processor'

require 'net/pop'
require 'net/smtp'

WAIT_MINITES_FOR_DELETING_MAIL = 5
OPEN_TIMEOUT_FOR_DELETING_MAIL = 30
WAIT_MINITES_FOR_RECEIVING_MAIL = 10

#=[ɊւeXg[eBeB
#
# ŏ̒:: gDC[
# |Wg:: $Id: mail_testutils.rb 516 2012-02-09 07:09:11Z toy_dev $
# 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
# CZX:: CPL(Common Public Licence)
class MailTestUtils

	def initialize(smtp_address, smtp_port, smtp_security_type, smtp_user, smtp_password, pop3_address, pop3_port, pop3_user, pop3_password, encoding)
		@smtp_address = smtp_address
		@smtp_port = smtp_port
		@smtp_security_type = smtp_security_type
		@smtp_user = smtp_user
		@smtp_password = smtp_password
		@pop3_address = pop3_address
		@pop3_port = pop3_port
		@pop3_user = pop3_user
		@pop3_password = pop3_password
		@encoding = encoding
	end

	def delete_all(wait_minites = WAIT_MINITES_FOR_DELETING_MAIL, open_timeout = OPEN_TIMEOUT_FOR_DELETING_MAIL)
		if wait_minites > 0 then
			sleep(wait_minites)
		end

		# [{bNXۂɂ
		pop3 = Net::POP3.new(@pop3_address, @pop3_port)
		if open_timeout > 0 then
			pop3.open_timeout = open_timeout
		end
		pop3.start(@pop3_user, @pop3_password)
		begin
			pop3.delete_all
		ensure
			pop3.finish
		end
	end

	def get_mail(wait_minites = WAIT_MINITES_FOR_RECEIVING_MAIL, open_timeout = OPEN_TIMEOUT_FOR_DELETING_MAIL)
		if wait_minites > 0 then
			sleep(wait_minites)
		end

		result = nil
		pop3 = Net::POP3.new(@pop3_address, @pop3_port)
		if open_timeout > 0 then
			pop3.open_timeout = open_timeout
		end
		pop3.start(@pop3_user, @pop3_password) do |pop3|
			pop3.each_mail do |m|
				result = MailProcessor.parse(m.pop, @encoding)
				m.delete
			end
		end

		return result
	end

	def get_mails(wait_minites = WAIT_MINITES_FOR_RECEIVING_MAIL)
		if wait_minites > 0 then
			sleep(wait_minites)
		end

		result = {}
		pop3 = Net::POP3.new(@pop3_address, @pop3_port)
		pop3.open_timeout = 10
		pop3.start(@pop3_user, @pop3_password) do |pop3|
			pop3.each_mail do |m|
				mail = MailProcessor.parse(m.pop, @encoding)
				result[mail.subject] = mail
				m.delete
			end
		end

		return result
	end

	def sendmail_from_file(filename)
		open(filename, 'rb') do |file|
			sendmail(file.read)
		end
	end

	def sendmail(content, to_encoding = M2W_SYSTEM_INNER_ENCODING)
		mail = MailProcessor.parse(content)

		if @smtp_security_type == 'SMTP-AUTH' then
			Net::SMTP.start(@smtp_address, @smtp_port, @smtp_address, @smtp_user, @smtp_password, :login) do |smtp|
				smtp.send_message(content, mail.from_address.address, MailProcessor.make_address_list(mail.to_addresses))
			end
		else
			Net::SMTP.start(@smtp_server_address, @smtp_server_port, @smtp_server_address) do |smtp|
				smtp.send_message(content, mail.from_address.address, MailProcessor.make_address_list(mail.to_addresses))
			end
		end
	end

end
