# coding: UTF-8

require 'plugin/weblog/lib/standard_post'
require 'plugin/weblog/meta_weblog/lib/meta_weblog_post_common'

#=metaWeblog API を使った標準のブログ記事投稿用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: metaweblog_post_extension.rb 132 2011-08-06 00:33:02Z yutaka_at_home $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MetaWeblogPost_WeblogPlugin < StandardPost_WeblogPlugin
	include MetaWeblogPostCommon

	def post_temp_article(client, blogid)
		M2W_LOGGER.debug("Start  metaWeblog.newPost ... blogid = #{blogid}")
		postid = client.call(
			"metaWeblog.newPost",
			blogid,
			@parent.username,
			@parent.password,
			{'title' => M2W_TEMP_POST_TITLE, 'description' => M2W_TEMP_POST_DESCRIPTION},
			0)
		postid = parse_postid(postid).to_s
		M2W_LOGGER.debug("Finish metaWeblog.newPost ... postid = #{postid}")
		return postid
	end

	def repost_formatted_article(client, blogid, postid, header, dateCreated)
		M2W_LOGGER.debug("Start  metaWeblog.editPost ...")
		result = client.call("metaWeblog.editPost", postid, @parent.username, @parent.password, get_header_for_post(header), 1)
		M2W_LOGGER.debug("Finish metaWeblog.editPost ... result = #{result}")
	end

	def delete_temp_article(client, blogid, postid)
		M2W_LOGGER.debug("Start  blogger.deletePost ... blogid = #{blogid}, postid = #{postid}")
		result = client.call(
			"blogger.deletePost",
			1,
			postid,
			@parent.username,
			@parent.password,
			1)
		M2W_LOGGER.debug("Finish blogger.deletePost ... result = #{result}")
	end

	def parse_postid(postid)
		return postid
	end

	def get_blog_name4trackback(client, blogid)
		@parent.get_blog_name4trackback(client, blogid)
	end

end
