# coding: UTF-8

#=設定された環境を使って XML-RPC の試験をするための雛形スクリプトです。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: new_post.rb 409 2011-12-04 10:57:23Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)

# LOAD_PATH に lib フォルダを追加する
$:.unshift(File.dirname(__FILE__) + "/../../main/lib/")
$:.unshift(File.dirname(__FILE__) + "/../../main/")

# Mail2Weblog のルートパスを設定する
M2W_ROOT_PATH = File.dirname(__FILE__) + "/../../main"

require 'm2w_configurator'
require 'uri'
require 'xmlrpc/client'
require 'xmlrpc_support/xmlrpc_parser'

uri = URI.parse(M2W_WEBLOG_ENDPOINT)
client = XMLRPC::Client.new(uri.host, uri.path)
# client.set_parser(XMLRPCParser.new("UTF-8"))

# ブログ記事を取得する
p client.call(
	"metaWeblog.newPost",
	"mail2weblog",
	M2W_WEBLOG_USERNAME,
	M2W_WEBLOG_PASSWORD,
	{
		"title" => "タイトル",
		"description" => "本文",
		"mt_keywords" => "キーワード１,キーワード２",
		"mt_tags" => "タグ１,タグ２",
	},
	1
)
