# coding: UTF-8

ROOT_PATH = File.dirname(File.expand_path(__FILE__))

$:.unshift(ROOT_PATH + "/")
$:.unshift(ROOT_PATH + "/../../")
$:.unshift(ROOT_PATH + "/../../../main/")
$:.unshift(ROOT_PATH + "/../../../main/lib")

# mail2weblog のルートパスを設定する
M2W_ROOT_PATH = ROOT_PATH + "/../../../main/"

require 'm2w_configurator'
require 'm2w_mail_parser'
require 'm2w_mail_sender'
require 'mailutils/mail_processor'
require 'testutils/accessor'
require 'testutils/mail_testutils'
require 'testutils/weblog_testutils'

require 'conf/setting'

require 'minitest/unit'

MiniTest::Unit.autorun

#=ブログ記事投稿コマンドプラグインのテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_post_plugin.rb 410 2011-12-05 02:10:29Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestPostCommandPlugin < MiniTest::Unit::TestCase

	if REAL_M2W_TEST && REAL_POST_TEST  then
		def setup
			@mail_parser = Mail2WeblogMailParser.new(
				M2W_SUBJECT_HEADER,
				M2W_SUBJECT_SEPARATOR_REGEX,
				{})

			@mail_sender = Mail2WeblogMailSender.new(
				SENDER_SMTP_SERVER_ADDRESS,
				SENDER_SMTP_SERVER_PORT,
				SENDER_SMTP_SECURITY_TYPE,
				SENDER_SMTP_SERVER_USER,
				SENDER_SMTP_SERVER_PASSWORD,
				SENDER_POP3_SERVER_ADDRESS,
				SENDER_POP3_SERVER_PORT,
				SENDER_POP3_SERVER_USER,
				SENDER_POP3_SERVER_PASSWORD,
				M2W_SUBJECT_HEADER,
				M2W_SUBJECT_SEPARATOR,
				MailProcessor.parse_mail_address(M2W_REPLY_ADDRESS))

			@mail_testutils = MailTestUtils.new(
				SENDER_SMTP_SERVER_ADDRESS,
				SENDER_SMTP_SERVER_PORT,
				SENDER_SMTP_SECURITY_TYPE,
				SENDER_SMTP_SERVER_USER,
				SENDER_SMTP_SERVER_PASSWORD,
				SENDER_POP3_SERVER_ADDRESS,
				SENDER_POP3_SERVER_PORT,
				SENDER_POP3_SERVER_USER,
				SENDER_POP3_SERVER_PASSWORD,
				M2W_SYSTEM_INNER_ENCODING)
			@mail_testutils.delete_all()

			@weblog_testutils = WeblogTestUtils.new(
				@mail_parser,
				@mail_sender,
				Mail2WeblogPluginManager.new(),
				@mail_testutils,
				SENDER_MAILADDRESS)
		end

		# リアル投稿テストです。
		# 本テストは、設定（conf/setting.rb）に依存します。
		def test_simple
			M2W_LOGGER.debug("Start  #{self.class.name}#test_simple")

			# コマンドを実行する
			from_address = MailAddress.new(SENDER_MAILADDRESS)
			to_addresses = [MailAddress.new(M2W_POP3_SERVER_ADDRESS)]
			keyword = Time.now.strftime("%Yテ%mス%dト%Hマ%Mー%Sク")
			title = "タイトルテスト@#{keyword}"
			attr1 = "属性１@#{keyword}"
			attr2 = "属性２@#{keyword}"
			message = "コンテンツテスト１行目@#{keyword}\n\nコンテンツテスト２行目@#{keyword}"
			content = @mail_sender.make_content(
				{
					'tit' => title,
					'attr1' => attr1,
					'attr2' => attr2,
				},
			message)
			mail = Mail.new("m.post.#{WEBLOG_BLOG_ID}", from_address, to_addresses, content, [])
			command = Post_CommandPlugin.new
			command.weblog = M2W_WEBLOG_EXTENSION
			command.mail_parser = @mail_parser
			command.mail_sender = @mail_sender
			command.mail = mail
			command.param = WEBLOG_BLOG_ID
			assert command.run()
			assert_equal content, command.report[:original_content]
			assert command.report[:postid] != nil
			assert_equal 0, command.report[:attachment_urls].size
			assert_equal 0, command.report[:thumbnail_urls].size
			assert_equal 0, command.report[:errors].size
			assert_equal 0, command.report[:warnings].size

			# メールの受信を確認する
			mail = @mail_testutils.get_mail()
			assert mail != nil
			assert_equal "m.get.#{WEBLOG_BLOG_ID}", mail.subject
			assert_equal M2W_REPLY_ADDRESS, mail.from_address.address
			assert_equal from_address.name, mail.from_address.name
			assert_equal 1, mail.to_addresses.size
			assert_equal from_address.address, mail.to_addresses[0].address
			assert_match /postid\.#{command.report[:postid]}/, mail.content
			assert_equal 0, mail.attachments.size

			# ブログ記事を取得して内容を確認する
			(get_result, mail, header, content, attachments, link) = @weblog_testutils.get(WEBLOG_BLOG_ID, command.report[:postid])
			assert get_result
			assert_equal 3, header.size
			assert_equal title, header['tit']
			assert_equal attr1, header['attr1']
			assert_equal attr2, header['attr2']
			assert_equal message, content
			assert_equal 0, attachments.size

			# ブログ記事の投稿を確認する
			response = Accessor.access_url(link, WEBLOG_ENCODING).encode(M2W_SYSTEM_INNER_ENCODING)
			assert_match title, response
			assert_match %r!<p>.*コンテンツテスト１行目@#{keyword}(</p>.*<p>|<br><br>)コンテンツテスト２行目@#{keyword}.*</p>!m, response

			M2W_LOGGER.debug("Finish #{self.class.name}#test_simple")
		end

		if REAL_ATTACHMENTS_TEST then
			def test_attachments
				M2W_LOGGER.debug("Start  #{self.class.name}#test_attachments")

				# コマンドを実行する
				from_address = MailAddress.new(SENDER_MAILADDRESS)
				to_addresses = [MailAddress.new(RECEIVER_MAILADDRESS)]
				keyword = Time.now.strftime("%Yテ%mス%dト%Hマ%Mー%Sク")
				title = "タイトルテスト@#{keyword}"
				message = "コンテンツテスト\@#{keyword}"

				mail_content = @mail_sender.make_content(
					{"tit" => title},
					REAL_THUMBNAIL_MESSAGES == nil ? message : message + REAL_THUMBNAIL_MESSAGES)
				attachments = REAL_ATTACHMENTS_ACTUAL
				mail = Mail.new("m.post.#{WEBLOG_BLOG_ID}", from_address, to_addresses, mail_content, attachments)
				command = Post_CommandPlugin.new
				command.weblog = M2W_WEBLOG_EXTENSION
				command.mail_parser = @mail_parser
				command.mail_sender = @mail_sender
				command.plugin_manager = Mail2WeblogPluginManager.new()
				command.mail = mail
				command.param = WEBLOG_BLOG_ID
				assert command.run()
				assert_equal mail_content, command.report[:original_content]
				assert command.report[:postid] != nil
				assert command.report[:attachment_urls] != nil
				assert command.report[:thumbnail_urls] != nil
				assert_equal REAL_ERRORS_SIZE, command.report[:errors].size
				assert_equal REAL_WARNINGS_SIZE, command.report[:warnings].size

				# メールの受信を確認する
				mail = @mail_testutils.get_mail()
				assert mail != nil
				assert_equal "m.get.#{WEBLOG_BLOG_ID}", mail.subject
				assert_equal M2W_REPLY_ADDRESS, mail.from_address.address
				assert_equal from_address.name, mail.from_address.name
				assert_equal 1, mail.to_addresses.size
				assert_equal from_address.address, mail.to_addresses[0].address
				assert_match /^postid\.#{command.report[:postid]}$/, mail.content
				assert_equal 0, mail.attachments.size

				# ブログ記事を取得して内容を確認する
				(get_result, mail, header, content, attachments, link) = @weblog_testutils.get(WEBLOG_BLOG_ID, command.report[:postid])
				assert get_result
				assert_equal 1, header.size
				assert_equal title, header["tit"]
				assert_equal REAL_THUMBNAIL_MESSAGES == nil ? message : message + REAL_THUMBNAIL_MESSAGES, content
				# 添付ファイルの内容を確認する
				if REAL_ATTACHMENTS_ACTUAL != nil && REAL_ATTACHMENTS_EXPECTED != nil then
					assert_equal REAL_ATTACHMENTS_EXPECTED.size, command.report[:attachment_urls].size
					assert_equal REAL_THUMBNAILS_SIZE, command.report[:thumbnail_urls].size
					assert_equal REAL_ATTACHMENTS_EXPECTED.clone.delete_if{|attachment| attachment == nil}.size, attachments.clone.delete_if{|attachment| attachment == nil}.size
					i = 0
					while i < REAL_ATTACHMENTS_EXPECTED.size
						M2W_LOGGER.debug("attachment index: #{i}")

						if REAL_ATTACHMENTS_EXPECTED[i] != nil then
							assert_equal REAL_ATTACHMENTS_EXPECTED[i].content, attachments[i].content
							# filepath = M2W_WEBLOG_EXTENSION.get_attachment_filepath(command.report[:postid], Time.now, i + 1, REAL_ATTACHMENTS_ACTUAL[i].filename).gsub(".", "\.")
							# assert_match /#{filepath}$/, command.report[:attachment_urls][i + 1]
							assert_equal Accessor.access_url(command.report[:attachment_urls][i + 1]), attachments[i].content
							if M2W_SYSTEM_RMAGICK_SUPPORTED && REAL_THUMBNAIL_MESSAGES != nil && REAL_THUMBNAILS_SCALE != nil && REAL_THUMBNAILS_SCALE[i] != nil then
								# filepath = M2W_WEBLOG_EXTENSION.get_thumbnail_filepath(command.report[:postid], Time.now, i + 1, attachments[i].filename).gsub(".", "\.")
								# assert_match /#{filepath}$/, command.report[:thumbnail_urls][i + 1]
								response = Accessor.access_url(command.report[:thumbnail_urls][i + 1])
								thumbnail = Magick::Image.from_blob(attachments[i].content).shift.scale(REAL_THUMBNAILS_SCALE[i])
								assert_match response.split(':create', 2)[0], thumbnail.to_blob.split(':create', 2)[0]
							end
						else
							assert_nil command.report[:attachment_urls][i + 1]
							assert_nil attachments[i]
						end

						i = i + 1
					end
				end

				# ブログの投稿を確認する
				response = Accessor.access_url(link, WEBLOG_ENCODING).encode(M2W_SYSTEM_INNER_ENCODING, {:invalid => :replace, :undef => :replace})
				assert_match title, response
				assert_match /<!--m2w_version:[0-9]{2}\.[0-9]{2}\.[0-9]{2}--><!--\[wikicontent\] .+? --><!--\[attachment_urls\] 1=.+? -->.+?#{message}.+?/m, response

				M2W_LOGGER.debug("Finish #{self.class.name}#test_attachments")
			end
		end
	end

end
