#!/usr/local/bin/ruby
# coding: UTF-8

#=mail2weblog のエントリーポイント
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: m2w.rb 175 2011-08-09 15:05:28Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)

# mail2weblog のルートパスを設定する
M2W_ROOT_PATH = File.dirname(File.expand_path(__FILE__))

# LOAD_PATH に必要なフォルダを追加する
$:.unshift(M2W_ROOT_PATH + "/")
$:.unshift(M2W_ROOT_PATH + "/lib")

require 'm2w_configurator'
require 'm2w_mail_parser'
require 'm2w_mail_sender'
require 'm2w_plugin_manager'
require 'weblog_command'
require 'mui/mail_command_processor'

begin
	mail_parser = Mail2WeblogMailParser.new(
		M2W_SUBJECT_HEADER,
		M2W_SUBJECT_SEPARATOR_REGEX)
	mail_sender = Mail2WeblogMailSender.new(
		M2W_SMTP_SERVER_ADDRESS,
		M2W_SMTP_SERVER_PORT,
		M2W_SMTP_SECURITY_TYPE,
		M2W_SMTP_SERVER_USER,
		M2W_SMTP_SERVER_PASSWORD,
		M2W_POP3_BEFORE_SMTP_SERVER_ADDRESS,
		M2W_POP3_BEFORE_SMTP_SERVER_PORT,
		M2W_POP3_BEFORE_SMTP_SERVER_USER,
		M2W_POP3_BEFORE_SMTP_SERVER_PASSWORD,
		M2W_SUBJECT_HEADER,
		M2W_SUBJECT_SEPARATOR,
		MailProcessor.parse_mail_address(M2W_REPLY_ADDRESS))
	mail_command_processor = MailCommandProcessor.new(
		M2W_POP3_SERVER_ADDRESS,
		M2W_POP3_SERVER_PORT,
		M2W_POP3_SERVER_USER,
		M2W_POP3_SERVER_PASSWORD)
	mail_command = WeblogCommand.new(
		M2W_WEBLOG_EXTENSION,
		mail_parser,
		mail_sender,
		Mail2WeblogPluginManager.new)
	mail_command_processor.add(mail_command)

	mail_command_processor.run
rescue => e
	M2W_LOGGER.error(e)
	exit(1)
end

puts "Content-type: text/plain\n\n"
puts "このプログラムは、cron などのスケジュール管理ソフトから呼び出すのが妥当です。"
