# coding: UTF-8

require 'm2w_plugin_manager'
require 'plugin/weblog/meta_weblog/meta_weblog_post'
require 'style/formatter'

M2W_META_WEBLOG_DEFAULT_ENCODING = 'UTF-8'
M2W_META_WEBLOG_ATTACHMENT_ROOT_PATH = 'attrs'
M2W_META_WEBLOG_POST_HEADER_ALIAS = {
  'tit' => 'title',
  'dat' => 'dateCreated',
}

#=metaWeblog API を使った標準のウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id$
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MetaWeblog_WeblogPlugin

	attr_accessor :mail_parser
	attr_accessor :mail_sender
	attr_accessor :plugin_manager

	attr_reader :host
	attr_reader :address
	attr_reader :username
	attr_reader :password
	attr_reader :encoding
	attr_reader :attachment_root_path

	def initialize(host = M2W_WEBLOG_HOST, address = M2W_WEBLOG_ADDRESS, username = M2W_WEBLOG_USERNAME, password = M2W_WEBLOG_PASSWORD, encoding = M2W_META_WEBLOG_DEFAULT_ENCODING, attachment_root_path = M2W_META_WEBLOG_ATTACHMENT_ROOT_PATH)
		@host = host
		@address = address
		@username = username
		@password = password
		@encoding = encoding
		@attachment_root_path = attachment_root_path
	end

	def server
		return XMLRPC::Client.new(host, address)
	end

	def formatter
		return Formatter.new(@plugin_manager)
	end

	# 添付ファイルのパスを取得します。
	def get_attachment_filepath(postid, attachment_index, attachment_filename)
		return "#{@attachment_root_path}#{postid}_#{attachment_index}#{File.extname(attachment_filename)}"
	end

	# ブログ記事投稿用のプラグインを取得します。
	def get_post_plugin()
		return MetaWeblogPost_WeblogPlugin.new(self)
	end

	# ブログ記事取得用のプラグインを取得します。
	def get_get_plugin()
		return MetaWeblogGet_WeblogPlugin.new(self)
	end

	# ブログ記事編集用のプラグインを取得します。
	def get_edit_plugin()
		return MetaWeblogEdit_WeblogPlugin.new(self)
	end

end
