# coding: UTF-8

ROOT_PATH = File.dirname(File.expand_path(__FILE__))

$:.unshift(ROOT_PATH + "/")
$:.unshift(ROOT_PATH + "/../")
$:.unshift(ROOT_PATH + "/../../main/")
$:.unshift(ROOT_PATH + "/../../main/lib")

require 'open-uri'
require 'rsd/rsd_processor'
require 'conf/setting'

require 'minitest/unit'

MiniTest::Unit.autorun

#=RSDProcessor のテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test.rb 112 2011-06-30 12:45:45Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestRSDProcessor < MiniTest::Unit::TestCase

	if REAL_TEST then
		def test_get_uri
			if HOME_PAGE != nil then
				assert RSD_URL, RSDProcessor.get_uri(HOME_PAGE)
			end
		end

		def test_parse
			rsd = nil
			open(RSD_URL) do |f|
				rsd = RSDProcessor.parse(f)
			end
			assert_equal RSD_ENGINE_NAME, rsd.engineName
			assert_equal RSD_ENGINE_LINK, rsd.engineLink
			assert_equal RSD_HOME_PAGE_LINK, rsd.homePageLink

			assert_equal RSD_APIS.size, rsd.apis.size

			RSD_APIS.each do |api|
				name = api[0]
				assert_equal api[1], rsd.apis[name].preferred
				assert_equal api[2], rsd.apis[name].apiLink
				assert_equal api[3], rsd.apis[name].blogID
			end
		end
	end

end
