# coding: UTF-8

require 'net/smtp'
require 'mailutils/mail_processor'

#=メール通知
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: m2w_mail_sender.rb 121 2011-07-17 12:26:08Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)

class Mail2WeblogMailSender

	def initialize(smtp_server_address, smtp_server_port, smtp_security_type, smtp_server_user, smtp_server_password, smtp_pop3before_smtp_server_address, smtp_pop3before_smtp_server_port, smtp_pop3before_smtp_server_user, smtp_pop3before_smtp_server_password, subject_header, subject_separator, from_address)
		@smtp_server_address = smtp_server_address
		@smtp_server_port = smtp_server_port
		@smtp_security_type = smtp_security_type
		@smtp_server_user = smtp_server_user
		@smtp_server_password = smtp_server_password
		@smtp_pop3before_smtp_server_address = smtp_pop3before_smtp_server_address
		@smtp_pop3before_smtp_server_port = smtp_pop3before_smtp_server_port
		@smtp_pop3before_smtp_server_user = smtp_pop3before_smtp_server_user
		@smtp_pop3before_smtp_server_password = smtp_pop3before_smtp_server_password

		@subject_header = subject_header
		@subject_separator = subject_separator
		@from_address = from_address
	end

	def sendmail(mail)
		if @smtp_security_type == 'POPbeforeSMTP' then
			pop = Net::POP3.new(@smtp_pop3before_smtp_server_address, @smtp_pop3before_smtp_server_port)
			pop.start(@smtp_pop3before_smtp_server_user, @smtp_pop3before_smtp_server_password)
			pop.finish
		end

		if @smtp_security_type == 'SMTP-AUTH' then
			Net::SMTP.start(@smtp_server_address, @smtp_server_port, @smtp_server_address, @smtp_server_user, @smtp_server_password, :login) do |smtp|
				smtp.send_message(
					MailProcessor.make(mail), mail.from_address.address, MailProcessor.make_address_list(mail.to_addresses)
				)
			end
		else
			Net::SMTP.start(@smtp_server_address, @smtp_server_port, @smtp_server_address) do |smtp|
				smtp.send_message(
					MailProcessor.make(mail), mail.from_address.address, MailProcessor.make_address_list(mail.to_addresses)
				)
			end
		end
	end

	def sendmail_as_command(command, param, header, content, to_address, attachments = [])
		sendmail(Mail.new(make_title(command, param), @from_address, [to_address], make_content(header, content)))
	end

	def make_title(command, param = nil)
		result = ""
		if @subject_header != nil then
			result << @subject_header
			result << @subject_separator
		end
		result << command
		if param != nil || param == "" then
			result << @subject_separator
			result << param
		end
		return result
	end

	def make_content(header, content)
		result = ""
		if header != nil && header.size > 0 then
			header.each do |key, value|
				result << "#{key}#{@subject_separator}#{value}\n"
				result << "\n"
			end
		end
		if content != nil then
			result << content
		end
		return result
	end

end
