# coding: UTF-8

require 'm2w_common'

require 'mailpart'

#=簡易メール情報取得ユーティリティー
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: mail.rb 39 2011-06-01 13:51:30Z yutaka_at_home $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
#
# net/pop ライブラリを使って取得したメールを解析し、情報の参照性を高めるためのユーティリティーです。
# 汎用ではなく簡易のものです。
#
# - メール種別（Content-Type）の対応状況
# -- サポート対象
# --- テキストメール（text/plain）をサポートします。
# --- 添付ファイル付きメール（multipart/mixed）をサポートします。
# -- 未サポート
# --- HTML メール／デコレーションメール（multipart/related or multipart/alternative）。
# --- その他、サポート対象以外
#
# - エンコードの対応状況
# -- 本文は Content-Transfer-Encoding ヘッダーの値が 7bit のもののみをサポートします。
# -- 添付ファイルは Content-Transfer-Encoding ヘッダーの値が base64 のもののみをサポートします。
class Mail

	def initialize(mail)
		i = 0
		buffers = mail.split(/\r\n|\r|\n/)

		# ヘッダーを解析する
		main_header = parse_header(buffers, 0)
		@header = main_header[:header]

		if main_header[:header]['Content-Type'] != nil then
			# 添付ファイルが無い場合
			if /text\/plain/ =~ main_header[:header]['Content-Type'] then
				@parts = initializeTextPlain(main_header, buffers)
				return
			# 添付ファイルがある場合
			elsif /multipart\/mixed;.+boundary="(.+)"/ =~ main_header[:header]['Content-Type']then
				boundary = $1
				@parts = initializeMultipartMixed(main_header, boundary, buffers)
				return
			end
		end

		raise ArgumentError.new('サポートしていないメールを引数に指定しました。')
	end

	def initializeTextPlain(header, buffers)
		# 本文を解析する
		i = header[:end_line] + 1
		body = ''
		while i < buffers.size
			body = body + buffers[i] + "\n"

			i = i + 1
		end
		return [MailPart.new(header[:header], body)]
	end

	def initializeMultipartMixed(header, boundary, buffers)
		result = []
		i = header[:end_line] + 1
		while i < buffers.size
			if buffers[i] == "--#{boundary}" then
				if i + 1 == buffers.size || buffers[i + 1] == '' then
					break
				else
					part_header = parse_header(buffers, i + 1)
					i = part_header[:end_line] + 1
					if /^ *([a-z]+\/[a-z]+)/ =~ part_header[:header]['Content-Type'] then
						type = $1
					end

					body = ''
					while i < buffers.size && buffers[i] != "--#{boundary}"
						if type =~ /text\/plain/ then
							body = body + buffers[i] + "\n"
						else
							body = body + buffers[i]
						end

						i = i + 1
					end

					if type =~ /text\/plain/ then
						result.insert(0, MailPart.new(part_header[:header], body))
					else
						result.push(MailPart.new(part_header[:header], body))
					end
				end
			else
				i = i + 1
			end
		end
		return result
	end

	def parse_header(buffers, start_line)
		header = {}

		i = start_line
		while i < buffers.size
			line = buffers[i].chomp

			if line =~ /^([a-zA-Z][a-zA-Z0-9\-]+): *(.+)$/ then
				header_name = $1
				header_value = $2
				if header.has_key?(header_name) then
					header[header_name] = header[header_name] + header_value
				else
					header[header_name] = header_value
				end
			elsif line == '' then
				break
			else
				header[header_name] = header[header_name] + line
			end

			i = i + 1
		end

		return {:header => header, :end_line => i}
	end

	def header_keys
		return @header.keys
	end

	def header(key)
		return @header[key]
	end

	def attachments
		if @parts.size >= 1 then
			return @parts[1..@parts.size]
		else
			return []
		end
	end

	# メールの本体を取得します。
	def body(to_encoding = nil)
		if /text\/plain;.+charset="(.+)"/ =~ @parts[0].header['Content-Type'] then
			from_encoding = $1
		end

		if '7bit' != @parts[0].header['Content-Transfer-Encoding'] then
			raise EncodingError.new('7bit 以外の Content-Transfer-Encoding を持つメールはサポートしていません。')
		end

		if to_encoding != nil && from_encoding != nil then
			return m2w_encode(@parts[0].body, to_encoding, from_encoding)
		else
			return m2w_encode(@parts[0].body, from_encoding, from_encoding)
		end
	end

end
