# coding: UTF-8

ROOT_PATH = File.dirname(File.expand_path(__FILE__)) + "/../../m2w"

$:.unshift(ROOT_PATH + "/")
$:.unshift(ROOT_PATH + "/../")
$:.unshift(ROOT_PATH + "/../../main/")
$:.unshift(ROOT_PATH + "/../../main/lib")

# mail2weblog のルートパスを設定する
M2W_ROOT_PATH = ROOT_PATH + "/../../main/"

require 'm2w_configurator'
require 'conf/setting'

require 'minitest/unit'

MiniTest::Unit.autorun

#=PREformatted text（整形済みテキスト）を出力する書式プラグインのテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_pre_plugin.rb 324 2011-10-08 00:42:51Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestPreFormatPlugin < MiniTest::Unit::TestCase

	def test_plugin_contents
		plugin = Pre_FormatPlugin.new()

expected = <<"END_CONTENT"
abc
def
ghi
END_CONTENT

content = <<"END_CONTENT"

abc
def
ghi
END_CONTENT

		result = plugin.plugin_contents(content, {})
		assert_equal "<div><pre>#{expected}</pre></div>", result.chomp('')
	end

	def test_plugin_contents_inline
		plugin = Pre_FormatPlugin.new()

expected = <<"END_CONTENT"
abc
def
ghi
END_CONTENT

content = <<"END_CONTENT"

abc
def
ghi
END_CONTENT

		result = plugin.plugin_contents_inline(content, {})
		assert_equal "<span><pre>#{expected}</pre></span>", result.chomp('')
	end

end
