# coding: UTF-8

require 'plugin/weblog/lib/standard_post'
require 'plugin/weblog/atom_pub/lib/atom_pub_weblog_post_common'

#=AtomPub を使った標準のブログ記事投稿用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: atom_pub_post.rb 614 2012-03-16 23:54:38Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class AtomPubPost_WeblogPlugin < StandardPost_WeblogPlugin
	include AtomPubWeblogPostCommon

	def post_temp_article(client, blogid)
		M2W_LOGGER.debug("Start  AtomPub.create_entry ... endpoist = #{@parent.entry_collection_uri}")
		new_entry = Atom::Entry.new(
			:title => M2W_TEMP_POST_TITLE.encode("BINARY", "BINARY"),
			:content => M2W_TEMP_POST_DESCRIPTION.encode("BINARY", "BINARY"))
		entry_uri = client.create_entry(@parent.entry_collection_uri, new_entry)
		postid = parse_postid(entry_uri)
		M2W_LOGGER.debug("Finish AtomPub.create_entry ... entry_uri = #{entry_uri}, postid = #{postid}")
		return postid
	end

	def repost_formatted_article(client, blogid, postid, header, dateCreated)
		M2W_LOGGER.debug("Start  AtomPub.update_entry ...")
		entry = {}
		entry[:title] = header['title'].encode('BINARY', 'BINARY') if header['title']
		entry[:content] = header['description'].encode('BINARY', 'BINARY') if header['description']
		new_entry = Atom::Entry.new(entry)
		result = client.update_entry("#{@parent.entry_collection_uri}/#{postid}", new_entry)
		M2W_LOGGER.debug("Finish AtomPub.update_entry ... result = #{result}")
	end

	def delete_temp_article(client, blogid, postid)
		M2W_LOGGER.debug("Start  AtomPub.delete_entry ... postid = #{postid}")
		result = client.delete_entry("#{@parent.entry_collection_uri}/#{postid}")
		M2W_LOGGER.debug("Finish AtomPub.delete_entry ... result = #{result}")
	end

	def parse_postid(entry_uri)
		raise WeblogPluginError.new(
			"未実装エラー",
			"実装されていません。")
	end

end
