# coding: UTF-8

#=FC2 ブログの全ての添付ファイルを削除するためのスクリプトです。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: delete_files.rb 764 2012-07-04 12:13:04Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)

# LOAD_PATH に lib フォルダを追加する
$:.unshift(File.dirname(__FILE__) + "/../../lib/")

require 'mechanize'
require 'optparse'

# 引数を解析する
# デフォルト値を設定する
config = {}
OptionParser.new do |opts|
	# オプション情報を設定する
	opts = OptionParser.new
	opts.on('-u USERNAME', '--username USERNAME', '[必須]ログインユーザ名を指定する。'.encode('Shift_JIS')) do |username|
		config['username'] = username
	end
	opts.on('-p PASSWORD', '--password PASSWORD', '[必須]パスワードを指定する。'.encode('Shift_JIS')) do |password|
		config['password'] = password
	end

	opts.parse!(ARGV)

	# 必須オプションをチェックする
	required = ['username', 'password']
	for field in required
		if config[field] == nil then
      p config
			puts opts.help
			exit 1
		end
	end
end

agent = Mechanize.new do |agent|
	agent.user_agent_alias = 'Mac Safari'
	agent.follow_meta_refresh = true
	agent.verify_mode = OpenSSL::SSL::VERIFY_NONE
end

agent.get('http://fc2.com/login.php?ref=blog') do |login_page|
	puts "=== moved to login form."

	blog_page = login_page.form_with(:name => 'form_login') do |form|
		form.id = config['username']
		form.email = config['username']
		form.action = 'https://secure.id.fc2.com/index.php?mode=login&done=blog&switch_language=en'
		form.pass = config['password']
		form.mode = "login"
		form.blog = true
	end.submit

	puts "=== logined"

	filemanager_page = agent.click(blog_page.link_with(:text => 'ファイルアップロード'))

	puts "=== moved to the file manager."

	while true
		delete_count = 0
		filemanager_page = filemanager_page.form_with(:name => 'file') do |form|
			form.checkboxes_with(:name => %r!^multi!).each do |field|
			  field.check
				delete_count = delete_count + 1
			end
			form.type = 'delete'
		end.submit

		if delete_count == 0 then
			break
		end

		puts "=== deleted ... #{delete_count}"
	end
end

puts "=== finished"
