# coding: UTF-8

ROOT_PATH = File.dirname(File.expand_path(__FILE__))

# LOAD_PATH に必要なフォルダを追加する
$:.unshift(ROOT_PATH + "/")
$:.unshift(ROOT_PATH + "/../../main/lib/")

require 'fileutils'
require 'net/pop'
require 'optparse'
require 'mailutils/mail_processor'

#=メールを走査し、内容をファイルにダンプするデバッグ用のツールです。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: dumpmail.rb 869 2012-10-31 00:11:01Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)

# 引数を解析する
# デフォルト値を設定する
config = {'port' => 110, 'outdir' => 'dump', 'sort' => false, 'delete' => false, 'enable_ssl' => false}
OptionParser.new do |opts|
	# オプション情報を設定する
	opts = OptionParser.new
	opts.on('-h HOST', '--host HOST', '[必須]POP3サーバのホスト名を指定する。') {|host| config['host'] = host}
	opts.on('-p PORT', '--port PORT', '[任意]POP3サーバにアクセスする際のポート番号を指定する。指定しなかった場合は 110 をデフォルトとする。') {|port| config['port'] = port}
	opts.on('-u USERNAME', '--user USERNAME', '[必須]POP3サーバにアクセスする際のユーザ名を指定する。') {|username| config['username'] = username}
	opts.on('-w PASSWORD', '--pass PASSWORD', '[必須]POP3サーバにアクセスする際のパスワードを指定する。') {|password| config['password'] = password}
	opts.on('-e', '--enable_ssl', '[任意]POP3サーバにSSLでアクセスする場合指定する。') {config['enable_ssl'] = true}
	opts.on('-o OUTDIR', '--outdir OUTDIR', '[任意]ダンプ結果の出力先フォルダを指定する。') {|outdir| config['outdir'] = outdir}
	opts.on('-s', '--sort', '[任意]指定した場合はメールアドレスによりメールを振り分けます。') {|sort| config['sort'] = true}
	opts.on('-d', '--delete', '[任意]指定した場合は同時にPOP3サーバからメールを削除します。') {|delete| config['delete'] = true}
	opts.on('--debug', '[任意]デバッグ情報を標準エラー出力に出力する場合に指定する。指定しなかった場合は dump ふぉデフォルトとする。') {config['debug'] = true}

	opts.parse!(ARGV)

	# 必須オプションをチェックする
	required = ['host', 'port', 'username', 'password', 'delete']
	for field in required
		if config[field] == nil then
      p config
			puts opts.help
			exit 1
		end
	end
end

FileUtils.makedirs(config['outdir'])

def get_directory(buffer, config)
	if config['sort'] then
		begin
			mail = MailProcessor.parse(buffer, "UTF-8")
			if mail.from_address.address =~ /^(.+)@(.+)$/ then
				return "#{$2}/#{$1}"
			else
				return mail.from_address.address
			end
		rescue => e
			return "_parse_error/"
		end
	end
	return ''
end

pop = Net::POP3.new(config['host'], config['port'])
pop.enable_ssl(OpenSSL::SSL::VERIFY_NONE) if config['enable_ssl']
pop.start(config['username'], config['password'])

count = 1
pop.each_mail do |m|
	buffer = m.pop
	opposite_directory = get_directory(buffer, config)
	absolute_directory = "#{config['outdir']}/#{opposite_directory}"

	begin
		if !File.exist?(absolute_directory) then
			FileUtils.makedirs(absolute_directory)
		end
	rescue => e
		opposite_directory = '_directory_error/'
		absolute_directory = "#{config['outdir']}/#{opposite_directory}"
		if !File.exist?(absolute_directory) then
			FileUtils.makedirs(absolute_directory)
		end
	end

  puts "write: #{opposite_directory}#{count}.txt"
  File.open("#{absolute_directory}#{count}.txt",'wb') do |stream|
	  stream.write(buffer)
	end
  count = count + 1
	if config['delete'] then
		m.delete
	end
end

pop.finish
