# coding: UTF-8

require 'plugin/weblog/lib/standard_command'
require 'plugin/weblog/lib/weblog_plugin_error'
require 'plugin/weblog/lib/weblog_plugin_warning'

require 'open-uri'

#=標準のブログ記事削除用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: standard_delete.rb 864 2012-10-23 22:36:39Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class StandardDelete_WeblogPlugin < StandardCommand_WeblogPlugin

	def delete(request)
		@logger.debug("Start  #{self.class.name}#delete ... endpoint = #{@parent.endpoint}, header = #{request.header.to_s}") if @logger && @logger.debug?
		result = false

		client = @parent.client
		formatter = @parent.formatter
		postid = request.header['postid']
		response = Mail2WeblogResponse.new

		before(client, request, response)

		begin
			result = delete_article(client, postid)
		rescue => e
			@logger.error("ブログ記事の削除に失敗しました。") if @logger
			@logger.error(e) if @logger
			response.errors.push(WeblogPluginError.new(
				"ブログ記事削除エラー(メッセージ = #{e.message})",
				"ブログ記事の削除に失敗しました(メッセージ = #{e.message})。"))
			@logger.debug("Finish #{self.class.name}#delete ... result = false") if @logger && @logger.debug?
			return response
		end

		response[:postid] = postid.to_s

		after(client, request, response)

		@logger.debug("Finish #{self.class.name}#delete ... result = #{result}") if @logger && @logger.debug?
		response.success = result
		return response
	end

	def header_alias
		return {}
	end

	def before(client, request, response)
	end

	def after(client, request, response)
	end

	def delete_article(client, postid)
		raise WeblogPluginError.new(
			"未実装エラー",
			"実装されていません。")
	end

end
