# coding: UTF-8

require 'style/formatter'

require 'plugin/weblog/lib/weblog_plugin_error'
require 'plugin/weblog/lib/weblog_plugin_warning'

M2W_WEBLOG_HATENA_DIARY_LINE_BREAK = "&amp;#10;"

#=はてなダイアリー専用のフォーマット変換を行います。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: hatena_diary_formatter.rb 832 2012-10-02 16:20:59Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class HatenaDiaryFormatter < Formatter

	def preset(request, vars, errors, warnings)
	end

	def format(request, vars, errors, warnings)
		@logger.debug("Start  #{self.class}#format ... vars = #{vars}") if @logger && @logger.debug?

		# 全てのコンテンツに書式プラグインを適用する
		result = {'description' => ''}
		request.contents.each do |name, each_content|
			result[name] = each_content.encode(M2W_SYSTEM_INNER_ENCODING)
		end

		description = __get_commentout_content(request)
		description << __get_commentout_attachment_urls_content({})
		description << result['description']
		result['description'] = description

		@logger.debug("Finish #{self.class}#format ... result = #{result}") if @logger && @logger.debug?

		return result
	end

	def escape(content)
		result = CGI.escapeHTML(content)
		return result.gsub(/\n/, M2W_WEBLOG_HATENA_DIARY_LINE_BREAK)
	end

	def unescape(content)
		result = content.gsub(M2W_WEBLOG_HATENA_DIARY_LINE_BREAK, "\n")
		return CGI.unescapeHTML(result)
	end

end
