# coding: UTF-8

require 'plugin/format/lib/format_plugin_utils'

M2W_WEBLOG_FORMAT_DEFAULT_MODE = 'html'

#=プラグインマネージャー
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: m2w_plugin_manager.rb 849 2012-10-20 11:08:55Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Mail2WeblogPluginManager
	include FormatPluginUtils

	attr_reader :command_plugin_config
	attr_reader :format_plugin_config
	attr_reader :weblog_plugin_config
	attr_writer :logger

	def initialize(command_plugin_config = {}, format_plugin_config = {}, weblog_plugin_config = {}, logger = nil)
		@command_plugin_config = command_plugin_config != nil ? command_plugin_config : {}
		@format_plugin_config = format_plugin_config != nil ? format_plugin_config : {}
		@weblog_plugin_config = weblog_plugin_config != nil ? weblog_plugin_config : {}
		@logger = logger
	end

	def get_plugin_name(name)
		while /^(.+)_([a-z])(.+)$/ =~ name
			name = $1 + $2.upcase + $3
		end
		return name.slice(0, 1).upcase + name.slice(1, name.length - 1)
	end

	def get_plugin(name, suffix)
		begin
			result = eval("#{get_plugin_name(name)}_#{suffix}").new
			result.logger = @logger if @logger && result.respond_to?('logger=')
			return result
		rescue NameError => e
			@logger.error("存在しないプラグインを取得しようとしました。") if @logger
			@logger.error(e) if @logger
			return nil
		end
	end

	def get_command_adapter_plugin(name, type)
		return get_plugin(name, "#{M2W_COMMAND_ADAPTER_PLUGIN_SUFFIX}4#{get_plugin_name(type)}")
	end

	def get_command_plugin(name)
		return get_plugin(name, M2W_COMMAND_PLUGIN_SUFFIX)
	end

	def get_format_plugin(name)
		return get_plugin(name, M2W_FORMAT_PLUGIN_SUFFIX)
	end

	def call_format_plugin_preset(name, param, vars)
		plugin = get_format_plugin(name)
		if plugin != nil then
			if plugin.respond_to?("plugin_preset") then
				return plugin.plugin_preset(param, get_format_plugin_vars(name, vars))
			end
		else
			raise FormatPluginWarning.new(
				"不明なプラグイン指定(プラグイン名 = #{name})",
				"不明なプラグインを指定しました（プラグイン名 = #{name}）。")
		end

		return {}
	end

	def call_format_plugin_preset_inline(name, param, vars)
		plugin = get_format_plugin(name)
		if plugin != nil then
			if plugin.respond_to?("plugin_preset_inline") then
				return plugin.plugin_preset_inline(param, get_format_plugin_vars(name, vars))
			end
		else
			raise FormatPluginWarning.new(
				"不明なプラグイン指定(プラグイン名 = #{name})",
				"不明なプラグインを指定しました（プラグイン名 = #{name}）。")
		end

		return {}
	end

	def call_format_plugin_contents(name, param, vars)
		plugin = get_format_plugin(name)
		if plugin != nil then
			if plugin.respond_to?("plugin_contents") then
				return plugin.plugin_contents(param, get_format_plugin_vars(name, vars))
			else
				raise FormatPluginWarning.new(
					"予期しないプラグイン指定(プラグイン名 = #{name}, 定義 = plugin_contents)",
					"予期しないプラグインを指定しました（プラグイン名 = #{name}, 定義 = plugin_contents）。")
			end
		else
			raise FormatPluginWarning.new(
				"不明なプラグイン指定(プラグイン名 = #{name})",
				"不明なプラグインを指定しました（プラグイン名 = #{name}）。")
		end
	end

	def call_format_plugin_contents_inline(name, param, vars)
		plugin = get_format_plugin(name)
		if plugin != nil then
			if plugin.respond_to?("plugin_contents_inline") then
				return plugin.plugin_contents_inline(param, get_format_plugin_vars(name, vars))
			else
				raise FormatPluginWarning.new(
					"予期しないプラグイン指定(プラグイン名 = #{name}, 定義 = plugin_contents_inline)",
					"予期しないプラグインを指定しました（プラグイン名 = #{name}, 定義 = plugin_contents_inline）。")
			end
		else
			raise FormatPluginWarning.new(
				"不明なプラグイン指定(プラグイン名 = #{name})",
				"不明なプラグインを指定しました（プラグイン名 = #{name}）。")
		end
	end

	def get_format_plugin_vars(name, vars)
		result = vars.clone
		set_format_plugin_common_conf(result, @format_plugin_config['COMMON'])
		set_format_plugin_conf(result, @format_plugin_config[name])

		if result[M2W_FORMAT_PLUGIN_CONF_NAME] == nil then
			result[M2W_FORMAT_PLUGIN_CONF_NAME] = {}
		end

		result[M2W_FORMAT_PLUGIN_CONF_NAME][M2W_FORMAT_PLUGIN_NAME] = name

		return result
	end

	def get_weblog_plugin(name)
		return get_plugin(name, M2W_WEBLOG_PLUGIN_SUFFIX)
	end

	def get_weblog_filepath(url_type, postid, date, attachment_index, attachment_filename, default)
		if @weblog_plugin_config['COMMON'] != nil then
			format = @weblog_plugin_config['COMMON'][url_type]
			if format != nil then
				vars = {}
				vars['${postid}'] = postid.to_s
				vars['${year}'] = date.year.to_s.rjust(2, '0')
				vars['${month}'] = date.month.to_s.rjust(2, '0')
				vars['${day}'] = date.day.to_s.rjust(2, '0')
				vars['${hour}'] = date.hour.to_s.rjust(2, '0')
				vars['${min}'] = date.min.to_s.rjust(2, '0')
				vars['${sec}'] = date.sec.to_s.rjust(2, '0')
				vars['${index}'] = attachment_index.to_s
				vars['${filename}'] = attachment_filename.to_s
				vars['${filename_basename}'] = File.basename(attachment_filename, '.*')
				vars['${filename_extname}'] = File.extname(attachment_filename)

				result = format
				vars.each do |key, value|
					result = result.gsub(key, value)
				end

				return result
			end
		end

		return default
	end

	def parse_weblog_date(date_string, default_date = nil)
		if @weblog_plugin_config['COMMON'] != nil then
			if weblog_plugin_config['COMMON']['gmt_offset_hour'] != nil || weblog_plugin_config['COMMON']['gmt_offset_min'] != nil then
				offset = 0
				if weblog_plugin_config['COMMON']['gmt_offset_hour'] != nil && /^[+-]?[0-9]+$/ =~ weblog_plugin_config['COMMON']['gmt_offset_hour'] then
					offset = offset + 3600 * weblog_plugin_config['COMMON']['gmt_offset_hour'].to_i
				end
				if weblog_plugin_config['COMMON']['gmt_offset_min'] != nil && /^[+-]?[0-9]+$/ =~ weblog_plugin_config['COMMON']['gmt_offset_min'] then
					offset = offset + 60 * weblog_plugin_config['COMMON']['gmt_offset_min'].to_i
				end
				result = date_string != nil ? Time.parse(date_string) : default_date
				if result != nil then
					gmt_offset = result.gmt_offset
					result.gmtime
					result = result + gmt_offset - offset
					return result
				else
					return nil
				end
			end
		end

		return date_string != nil ? Time.parse(date_string) : default_date
	end

	def default_format_mode
		if @weblog_plugin_config['COMMON'] != nil && @weblog_plugin_config['COMMON']['default_format_mode'] != nil then
			return @weblog_plugin_config['COMMON']['default_format_mode']
		else
			return M2W_WEBLOG_FORMAT_DEFAULT_MODE
		end
	end

	def setter_name(name, default_value = nil)
		if @weblog_plugin_config['COMMON'] != nil then
			if @weblog_plugin_config['COMMON']["setter_name_#{name}"] != nil then
				return @weblog_plugin_config['COMMON']["setter_name_#{name}"]
			end
		end

		return default_value
	end

	def get_img_template_name(vars)
		if @weblog_plugin_config["COMMON"] != nil && @weblog_plugin_config["COMMON"]["img_template_name"] != nil then
			return @weblog_plugin_config["COMMON"]["img_template_name"]
		elsif vars["img_template_name"] != nil then
			return vars["img_template_name"]
		else
			return nil
		end
	end

	def get_weblog_thumbnail_setting(vars)
		img_template_name = get_img_template_name(vars)

		if img_template_name != nil && img_template_name != "" then
			result = {'condition_width' => '300', 'width' => '400', 'keep' => '1'}

			@weblog_plugin_config['COMMON'].each do |key, value|
				if /^thumbnail_(.+)$/ =~ key then
					thumbnail_key = $1
					if value == nil || value == '' then
						result.delete(thumbnail_key)
					else
						result[thumbnail_key] = value
					end
				end
			end

			return result
		end

		return nil
	end

end
