#!ruby
# coding: UTF-8

require 'fileutils'
require 'yaml'

TRACKBACK_LOG_FILENAME = 'trackback.log'
WAIT_TIME = 10
SLEEP_TIME = 1

first_time = Time.now
trackbacks = []

while trackbacks.size == 0 && Time.now - first_time < WAIT_TIME
	sleep(SLEEP_TIME)

	if File.exist?(TRACKBACK_LOG_FILENAME) then
		trackbacks = open(TRACKBACK_LOG_FILENAME, 'r') do |file|
			YAML.load(file)
		end
		FileUtils.rm(TRACKBACK_LOG_FILENAME)
	end
end

puts "Content-Type: text/plain;"
puts
puts YAML.dump(trackbacks)
