# coding: UTF-8

require 'plugin/weblog/lib/standard_get'

#=tDiary のブログ記事取得用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: t_diary_get.rb 776 2012-07-10 09:54:17Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TDiaryGet_WeblogPlugin < StandardGet_WeblogPlugin

	def get_article(client, postid)
		M2W_LOGGER.debug("Start  metaWeblog.getPost ... postid = #{postid}")
		post = client.call("metaWeblog.getPost", postid, @parent.username, @parent.password)
		M2W_LOGGER.debug("Finish metaWeblog.getPost ... result = #{post.to_s}")

		if post['description'] == nil then
			raise WeblogPluginError.new(
				"本文取得エラー",
				"本文の取得に失敗しました。"
			)
		end

		if post['link'] == nil then
			raise WeblogPluginError.new(
				"リンク取得エラー",
				"リンクの取得に失敗しました。"
			)
		end

		return [post['description'], translate_link(post['link'])]
	end

	def translate_link(link)
		if link =~ %r!^(.+?)/([0-9]+?)\.html#(p[0-9]+?)$! then
			return "#{$1}/?date=#{$2}##{$3}"
		else
			return link
		end
	end

end
