# coding: UTF-8

require 'plugin/weblog/lib/standard_command'

#=はてなダイアリーのためのブログ記事取得用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: hatena_diary_get.rb 408 2011-12-04 10:56:06Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class HatenaDiaryGet_WeblogPlugin < StandardCommand_WeblogPlugin

	def header_alias
		return {}
	end

	def get(header, content, attachments, blogid)
		M2W_LOGGER.debug("Start  #{self.class.name}#get ... endpoint = #{@parent.endpoint}, header = #{header.to_s}")
		result = false

		client = @parent.client
		formatter = @parent.formatter

		postid = header['postid']

		before(client, header, content, attachments, postid)

		header = @parent.mail_parser.get_alias_header(header, header_alias())

		# ブログ記事を取得する
		M2W_LOGGER.debug("Start  AtomPub.get_entry ... postid = #{postid}")
		entry = client.get_entry(@parent.entry_collection_uri + "/" + postid)
		M2W_LOGGER.debug("Finish AtomPub.get_entry")

		# ブログ記事情報を解析する
		entry.elem.each_element("hatena:syntax") do |element|
			(version, wikicontent) = formatter.get_uncommentout_content(element.text)
			@report[:original_content] = wikicontent
			@report[:postid] = postid
			result = true
		end
		entry.elem.each_element_with_attribute("rel", "alternate") do |element|
			@report[:link] = element.attributes['href']
		end
		@report[:attachments] = []

		after(client, header, content, attachments, postid)

		M2W_LOGGER.debug("Finish #{self.class.name}#get ... result = #{result}")
		return result
	end

	def before(client, header, content, attachments, postid)
	end

	def after(client, header, content, attachments, postid)
	end

end
