# coding: UTF-8

if $0 == __FILE__ then
	ROOT_PATH = File.dirname(File.expand_path(__FILE__))

	$:.unshift(ROOT_PATH + "/../../../")
	$:.unshift(ROOT_PATH + "/../../../../main/")
	$:.unshift(ROOT_PATH + "/../../../../main/lib/")

	# mail2weblog のルートパスを設定する
	M2W_ROOT_PATH = ROOT_PATH + "/../../../../main/"

	require 'm2w_configurator'
	require 'minitest/autorun'
end

#=Alteil II のユニットへのリンクを貼り付ける書式プラグインのテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_alteil_plugin.rb 675 2012-05-12 15:12:21Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestAlteilFormatPlugin < MiniTest::Unit::TestCase

	def test_plugin_contents
		plugin = Alteil_FormatPlugin.new()

		result = plugin.plugin_contents('太陽人神『アンノウン』', {})
		assert_match %r!<div><a href=".+?id=1337">太陽人神『アンノウン』</a></div>!, result

		assert_raises(FormatPluginWarning) do
			plugin.plugin_contents('存在しないユニット名', {})
		end
	end

	def test_plugin_contents_inline
		plugin = Alteil_FormatPlugin.new()

		result = plugin.plugin_contents_inline('太陽人神『アンノウン』', {})
		assert_match %r!<a href=".+?id=1337">太陽人神『アンノウン』</a>!, result

		assert_raises(FormatPluginWarning) do
			plugin.plugin_contents_inline('存在しないユニット名', {})
		end
	end

end
